/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.db;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.naming.InitialContext;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jboss.logging.Logger;
import org.jboss.portal.common.util.Tools;
import org.jboss.portal.identity.CachedUserImpl;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.NoSuchUserException;
import org.jboss.portal.identity.Role;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.db.HibernateRoleImpl;
import org.jboss.portal.identity.db.HibernateUserImpl;
import org.jboss.portal.identity.db.HibernateUserModuleImpl;
import org.jboss.portal.identity.service.MembershipModuleService;

public class HibernateMembershipModuleImpl
extends MembershipModuleService {
    private static final Logger log = Logger.getLogger(HibernateMembershipModuleImpl.class);
    protected SessionFactory sessionFactory;
    protected String sessionFactoryJNDIName;
    private HibernateUserModuleImpl userModule;

    public void start() throws Exception {
        this.sessionFactory = (SessionFactory)new InitialContext().lookup(this.sessionFactoryJNDIName);
        super.start();
    }

    public void stop() throws Exception {
        this.sessionFactory = null;
        super.stop();
    }

    public String getSessionFactoryJNDIName() {
        return this.sessionFactoryJNDIName;
    }

    public void setSessionFactoryJNDIName(String sessionFactoryJNDIName) {
        this.sessionFactoryJNDIName = sessionFactoryJNDIName;
    }

    public Set getRoles(User user) throws IdentityException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user instanceof CachedUserImpl) {
            try {
                user = this.getUserModule().findUserById(user.getId());
            }
            catch (NoSuchUserException e) {
                throw new IdentityException("Illegal state - cached user doesn't exist in identity store: ", e);
            }
        }
        if (!(user instanceof HibernateUserImpl)) {
            throw new IllegalArgumentException("User is not a HibernateUserImpl user");
        }
        HibernateUserImpl ui = (HibernateUserImpl)user;
        Set roles = ui.getRoles();
        HashSet<HibernateRoleImpl> copy = new HashSet<HibernateRoleImpl>();
        for (HibernateRoleImpl role : roles) {
            copy.add(role);
        }
        return Collections.unmodifiableSet(copy);
    }

    public Set getUsers(Role role) throws IdentityException {
        if (!(role instanceof HibernateRoleImpl)) {
            throw new IllegalArgumentException("Role is not a HibernateRoleImpl role");
        }
        HibernateRoleImpl ri = (HibernateRoleImpl)role;
        Set users = ri.getUsers();
        HashSet<HibernateUserImpl> copy = new HashSet<HibernateUserImpl>();
        for (HibernateUserImpl user : users) {
            copy.add(user);
        }
        return Collections.unmodifiableSet(copy);
    }

    public void assignUsers(Role role, Set users) throws IdentityException {
        if (!(role instanceof HibernateRoleImpl)) {
            throw new IllegalArgumentException("Role is not a HibernateRoleImpl role");
        }
        for (Object o : users) {
            if (o instanceof CachedUserImpl) {
                try {
                    o = this.getUserModule().findUserById(((User)o).getId());
                }
                catch (NoSuchUserException e) {
                    log.error((Object)"Illegal state - cached user doesn't exist in identity store: ", (Throwable)e);
                }
            }
            if (o instanceof HibernateUserImpl) {
                HibernateUserImpl user = (HibernateUserImpl)o;
                user.getRoles().add(role);
                continue;
            }
            throw new IllegalArgumentException("Only HibernateUserImpl users can be accepted");
        }
        this.fireMembershipChangedEvent(role, users);
    }

    public void assignRoles(User user, Set roles) throws IdentityException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user instanceof CachedUserImpl) {
            try {
                user = this.getUserModule().findUserById(user.getId());
            }
            catch (NoSuchUserException e) {
                throw new IdentityException("Illegal state - cached user doesn't exist in identity store: ", e);
            }
        }
        if (!(user instanceof HibernateUserImpl)) {
            throw new IllegalArgumentException("User is not a HibernateUserImpl user");
        }
        HashSet copy = new HashSet();
        for (Object o : roles) {
            if (o instanceof HibernateRoleImpl) {
                copy.add(o);
                continue;
            }
            throw new IllegalArgumentException("Only HibernateRoleImpl roles can be accepted");
        }
        HibernateUserImpl ui = (HibernateUserImpl)user;
        ui.setRoles(copy);
        this.fireMembershipChangedEvent(user, roles);
    }

    public Set findRoleMembers(String roleName, int offset, int limit, String userNameFilter) throws IdentityException {
        if (roleName != null) {
            try {
                Query query;
                Session session = this.getCurrentSession();
                if (userNameFilter.trim().length() != 0) {
                    userNameFilter = "%" + userNameFilter.replaceAll("%", "") + "%";
                    query = session.createQuery("from HibernateUserImpl as user left join user.roles role where role.name=:name AND user.userName LIKE :filter order by user.userName");
                    query.setString("filter", userNameFilter);
                } else {
                    query = session.createQuery("from HibernateUserImpl as user left join user.roles role where role.name=:name order by user.userName");
                }
                query.setString("name", roleName);
                query.setFirstResult(offset);
                query.setMaxResults(limit);
                Iterator iterator = query.iterate();
                Set result = Tools.toSet((Iterator)iterator, (boolean)true);
                LinkedHashSet<Object> newResult = new LinkedHashSet<Object>();
                for (Object[] oArr : result) {
                    newResult.add(oArr[0]);
                }
                return newResult;
            }
            catch (HibernateException e) {
                String message = "Cannot find role  " + roleName;
                log.error((Object)message, (Throwable)e);
                throw new IdentityException(message, e);
            }
        }
        throw new IllegalArgumentException("id cannot be null");
    }

    protected HibernateUserModuleImpl getUserModule() throws IdentityException {
        if (this.userModule == null) {
            try {
                this.userModule = (HibernateUserModuleImpl)this.getIdentityContext().getObject("User");
            }
            catch (ClassCastException e) {
                throw new IdentityException("Not supported object as part of the context - must be HibernateUserModuleImpl", e);
            }
        }
        return this.userModule;
    }

    protected Session getCurrentSession() {
        if (this.sessionFactory == null) {
            throw new IllegalStateException("No session factory");
        }
        return this.sessionFactory.getCurrentSession();
    }
}

