/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.ldap;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.ldap.LDAPConnectionContext;
import org.jboss.portal.identity.service.UserProfileModuleService;

public abstract class LDAPUserProfileModule
extends UserProfileModuleService {
    private static final Logger log = Logger.getLogger(LDAPUserProfileModule.class);
    private LDAPConnectionContext connectionContext;

    public void start() throws Exception {
        if (this.getConnectionJNDIName() == null) {
            throw new IdentityException("Cannot obtain ldap connection context JNDI name");
        }
        try {
            this.connectionContext = (LDAPConnectionContext)new InitialContext().lookup(this.getConnectionJNDIName());
        }
        catch (NamingException e) {
            log.error((Object)"Couldn't obtain connection context");
        }
        super.start();
    }

    protected LDAPConnectionContext getConnectionContext() throws IdentityException {
        if (this.connectionContext == null) {
            throw new IdentityException("No LDAPConnectionContext available");
        }
        return this.connectionContext;
    }

    public void setConnectionContext(LDAPConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }
}

