/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.sso.opensso;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.security.jacc.PolicyContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Context;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.jboss.logging.Logger;
import org.jboss.portal.identity.helper.IdentityTools;

public class OpenSSOAuthenticationValve
extends ValveBase {
    private static final Logger log = Logger.getLogger(OpenSSOAuthenticationValve.class);
    public static final String WEB_REQUEST_KEY = "javax.servlet.http.HttpServletRequest";
    private Set urlPatterns;
    private String loginURL;
    private String logoutURL;
    private boolean appendLoginGoto = true;
    private boolean appendLogoutGoto = true;
    private String loginParameters;
    private String logoutParameters;
    private String authType = "FORM";

    public void invoke(Request request, Response response) throws IOException, ServletException {
        Request httpRequest = request;
        HttpSession session = httpRequest.getSession();
        request.setAttribute("ssoEnabled", (Object)"true");
        SSOToken token = this.getToken();
        String requestURI = request.getRequestURI();
        if (this.isSecuredURI(requestURI) && token == null) {
            this.redirectToOpenSSOLogin((HttpServletRequest)request, (HttpServletResponse)response);
            return;
        }
        if (token != null && this.isTokenValid(token)) {
            try {
                String user = token.getProperty("UserId");
                request.setAttribute("ssoSuccess", (Object)new Boolean(true));
                Principal principal = ((Context)this.container).getRealm().authenticate(user, (String)null);
                if (principal != null) {
                    this.register(request, response, principal, this.getAuthType(), user, null);
                }
            }
            catch (Exception e) {
                log.error((Object)"Failed to perform JAAS login: ", (Throwable)e);
            }
        }
        this.getNext().invoke(request, response);
        if (!(token == null || this.isTokenValid(token) && request.getAttribute("org.jboss.portal.logout") == null)) {
            this.destroyToken(token);
            this.redirectToOpenSSOLogout((HttpServletRequest)request, (HttpServletResponse)response);
        } else if (token == null && request.getUserPrincipal() != null) {
            request.getSession().invalidate();
        }
    }

    private void redirectToOpenSSOLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuffer redirect = new StringBuffer();
        redirect.append(this.getLoginURL());
        if (this.isAppendLoginGoto()) {
            redirect.append("?goto=").append(request.getRequestURL());
        }
        if (this.getLoginParameters() != null && this.getLoginParameters().length() > 0) {
            if (this.isAppendLoginGoto()) {
                redirect.append("&");
            } else {
                redirect.append("?");
            }
            redirect.append(this.getLoginParameters());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Redirect to OpenSSO login URL: " + redirect.toString()));
        }
        response.sendRedirect(redirect.toString());
    }

    private void redirectToOpenSSOLogout(HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuffer redirect = new StringBuffer();
        redirect.append(this.getLogoutURL());
        if (this.isAppendLogoutGoto()) {
            StringBuffer url = new StringBuffer();
            if (request.isSecure()) {
                url.append("https://");
            } else {
                url.append("http://");
            }
            url.append(request.getServerName()).append(":").append(request.getServerPort()).append(request.getContextPath());
            redirect.append("?goto=").append(url);
        }
        if (this.getLogoutParameters() != null && this.getLogoutParameters().length() > 0) {
            if (this.isAppendLogoutGoto()) {
                redirect.append("&");
            } else {
                redirect.append("?");
            }
            redirect.append(this.getLogoutParameters());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Redirect to OpenSSO logout URL: " + redirect.toString()));
        }
        response.sendRedirect(redirect.toString());
    }

    private SSOToken getToken() {
        try {
            HttpServletRequest request = (HttpServletRequest)PolicyContext.getContext((String)WEB_REQUEST_KEY);
            SSOTokenManager manager = SSOTokenManager.getInstance();
            SSOToken token = manager.createSSOToken(request);
            return token;
        }
        catch (Exception e) {
            log.debug((Object)("Failed to obtain SSO Token: " + e));
            return null;
        }
    }

    private boolean isTokenValid(SSOToken token) {
        if (token == null) {
            throw new IllegalArgumentException("Token cannot be null");
        }
        try {
            SSOTokenManager manager = SSOTokenManager.getInstance();
            return manager.isValidToken(token);
        }
        catch (Exception e) {
            log.debug((Object)("Failed to validate SSO Token: " + e));
            return false;
        }
    }

    private void destroyToken(SSOToken token) {
        if (token == null) {
            throw new IllegalArgumentException("Token cannot be null");
        }
        try {
            SSOTokenManager manager = SSOTokenManager.getInstance();
            manager.destroyToken(token);
        }
        catch (Exception e) {
            log.debug((Object)("Failed to destroy SSO Token: " + e));
        }
    }

    private boolean isSecuredURI(String uri) {
        Set patterns = this.getSecuredUrlPatterns();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking if requested uri '" + uri + "' matches secured url patterns: " + patterns));
        }
        for (String pattern : patterns) {
            if (uri.indexOf(pattern) == -1) continue;
            return true;
        }
        return false;
    }

    public Set getSecuredUrlPatterns() {
        if (this.urlPatterns == null) {
            this.urlPatterns = IdentityTools.findSecuredURLs((Context)((Context)this.container));
            HashSet<String> urls = new HashSet<String>();
            for (String pattern : this.urlPatterns) {
                urls.add(pattern.replaceAll("\\*", ""));
            }
            this.urlPatterns = urls;
        }
        return this.urlPatterns;
    }

    private void register(Request request, Response response, Principal principal, String authType, String username, String password) {
        request.setAuthType(authType);
        request.setUserPrincipal(principal);
        Session session = request.getSessionInternal(false);
        if (session != null) {
            session.setAuthType(authType);
            session.setPrincipal(principal);
            if (username != null) {
                session.setNote("org.apache.catalina.session.USERNAME", (Object)username);
            } else {
                session.removeNote("org.apache.catalina.session.USERNAME");
            }
            if (password != null) {
                session.setNote("org.apache.catalina.session.PASSWORD", (Object)password);
            } else {
                session.removeNote("org.apache.catalina.session.PASSWORD");
            }
        }
    }

    public String getLoginURL() {
        return this.loginURL;
    }

    public void setLoginURL(String loginURL) {
        this.loginURL = loginURL;
    }

    public String getLogoutURL() {
        return this.logoutURL;
    }

    public void setLogoutURL(String logoutURL) {
        this.logoutURL = logoutURL;
    }

    public boolean isAppendLoginGoto() {
        return this.appendLoginGoto;
    }

    public void setAppendLoginGoto(boolean appendLoginGoto) {
        this.appendLoginGoto = appendLoginGoto;
    }

    public boolean isAppendLogoutGoto() {
        return this.appendLogoutGoto;
    }

    public void setAppendLogoutGoto(boolean appendLogoutGoto) {
        this.appendLogoutGoto = appendLogoutGoto;
    }

    public String getLoginParameters() {
        return this.loginParameters;
    }

    public void setLoginParameters(String loginParameters) {
        this.loginParameters = loginParameters;
    }

    public String getLogoutParameters() {
        return this.logoutParameters;
    }

    public void setLogoutParameters(String logoutParameters) {
        this.logoutParameters = logoutParameters;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }
}

