/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.web.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jboss.portal.common.http.QueryStringParser;
import org.jboss.portal.common.net.media.ContentType;
import org.jboss.portal.common.net.media.MediaType;
import org.jboss.portal.web.Body;
import org.jboss.portal.web.IllegalRequestException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestDecoder {
    private static final Charset UTF_8_CHARSET = Charset.forName("UTF-8");
    private final MediaType mediaType;
    private final Map<String, String[]> queryParameters;
    private final Body body;

    public RequestDecoder(HttpServletRequest request) throws UnsupportedEncodingException {
        if (request == null) {
            throw new IllegalArgumentException("No null http request accepted");
        }
        String queryString = request.getQueryString();
        this.queryParameters = queryString != null ? QueryStringParser.getInstance().parseQueryString(queryString) : Collections.emptyMap();
        if (request.getContentType() != null) {
            ContentType contentType = ContentType.create((String)request.getContentType());
            this.mediaType = contentType.getMediaType();
        } else {
            this.mediaType = null;
        }
        if ("POST".equals(request.getMethod())) {
            if (MediaType.APPLICATION_X_WWW_FORM_URLENCODED.equals((Object)this.mediaType)) {
                String characterEncoding = request.getCharacterEncoding();
                if (characterEncoding == null) {
                    request.setCharacterEncoding(UTF_8_CHARSET.name());
                } else {
                    Charset charset = Charset.forName(characterEncoding);
                    if (!UTF_8_CHARSET.equals(charset)) {
                        throw new IllegalRequestException("Charset " + characterEncoding + " not accepted, it should be UTF8");
                    }
                }
                HashMap<String, String[]> bodyParameterMap = new HashMap<String, String[]>();
                for (Map.Entry entry : request.getParameterMap().entrySet()) {
                    String paramName = (String)entry.getKey();
                    String[] paramValues = (String[])entry.getValue();
                    String[] queryValues = this.queryParameters.get(paramName);
                    if (queryValues != null) {
                        int bodyValuesLength = paramValues.length - queryValues.length;
                        if (bodyValuesLength <= 0) continue;
                        String[] bodyValues = new String[bodyValuesLength];
                        System.arraycopy(paramValues, queryValues.length, bodyValues, 0, bodyValuesLength);
                        bodyParameterMap.put(paramName, bodyValues);
                        continue;
                    }
                    bodyParameterMap.put(paramName, paramValues);
                }
                this.body = new Body.Form(request.getCharacterEncoding(), bodyParameterMap);
            } else {
                this.body = new Body.Raw(request.getCharacterEncoding(), request);
            }
        } else {
            this.body = null;
        }
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public Map<String, String[]> getQueryParameters() {
        return this.queryParameters;
    }

    public Body getBody() {
        return this.body;
    }
}

