/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.application;

import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.Locale;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.application.ViewHandlerWrapper;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.portlet.RenderResponse;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeUtil;
import javax.portlet.faces.annotation.PortletNamingContainer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portletbridge.component.UIPortletViewRoot;
import org.jboss.portletbridge.context.PortalActionURL;
import org.jboss.portletbridge.richfaces.RichFacesHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletViewHandler
extends ViewHandlerWrapper {
    private static final String FACELETS_VIEW_HANDLER_CLASS = "org.jboss.portletbridge.application.FaceletPortletViewHandler";
    private static final Log _log = LogFactory.getLog(PortletViewHandler.class);
    private static final String SAVESTATE_FIELD_MARKER = "~com.sun.faces.saveStateFieldMarker~";
    ViewHandler parent;
    private volatile Class<? extends UIViewRoot> viewRootClass;

    public PortletViewHandler(ViewHandler parent) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (null == classLoader) {
                classLoader = PortletViewHandler.class.getClassLoader();
            }
            Class<ViewHandler> faceletsViewRootClass = classLoader.loadClass(FACELETS_VIEW_HANDLER_CLASS).asSubclass(ViewHandler.class);
            parent = faceletsViewRootClass.getConstructor(ViewHandler.class).newInstance(parent);
        }
        catch (Throwable e) {
            _log.info((Object)"No Facelets library is presented");
        }
        this.parent = parent;
        this.getViewRootClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<? extends UIViewRoot> getViewRootClass() {
        if (null == this.viewRootClass) {
            PortletViewHandler portletViewHandler = this;
            synchronized (portletViewHandler) {
                if (null == this.viewRootClass) {
                    try {
                        RichFacesHelper richFacesHelper = new RichFacesHelper();
                        this.viewRootClass = richFacesHelper.getViewRootClass();
                    }
                    catch (NoClassDefFoundError e) {
                        this.viewRootClass = UIPortletViewRoot.class;
                    }
                }
            }
        }
        return this.viewRootClass;
    }

    public Locale calculateLocale(FacesContext context) {
        Locale locale;
        if (this.isPortletRequest(context)) {
            locale = context.getExternalContext().getRequestLocale();
            if (null == locale) {
                locale = super.calculateLocale(context);
            }
        } else {
            locale = super.calculateLocale(context);
        }
        return locale;
    }

    public UIViewRoot createView(FacesContext facesContext, String viewId) {
        boolean portletRequest = this.isPortletRequest(facesContext);
        if (portletRequest) {
            viewId = this.evaluateUrl(facesContext, viewId);
            try {
                PortalActionURL viewIdUrl = new PortalActionURL(viewId);
                viewId = viewIdUrl.getPath();
                Map<String, String[]> viewIdParameters = viewIdUrl.getParameters();
                facesContext.getExternalContext().getRequestMap().put("org.jboss.portletbridge.VIEW_ID_PARAMETERS", viewIdParameters);
            }
            catch (MalformedURLException e) {
                _log.warn((Object)"Mailformed ViewId url", (Throwable)e);
            }
        }
        UIViewRoot root = super.createView(facesContext, viewId);
        Class<?> rootClass = root.getClass();
        if (portletRequest && rootClass.getAnnotation(PortletNamingContainer.class) == null) {
            try {
                UIViewRoot portletRoot = this.getViewRootClass().newInstance();
                portletRoot.setViewId(root.getViewId());
                portletRoot.setLocale(root.getLocale());
                portletRoot.setRenderKitId(root.getRenderKitId());
                root = portletRoot;
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
        }
        return root;
    }

    public void writeState(FacesContext context) throws IOException {
        StringBuilderWriter stringBuilderWriter = StringBuilderWriter.getInstance();
        if (null != stringBuilderWriter) {
            stringBuilderWriter.stateWrited();
            context.getResponseWriter().write(SAVESTATE_FIELD_MARKER);
        } else {
            super.writeState(context);
        }
    }

    public String getActionURL(FacesContext context, String url) {
        url = this.evaluateUrl(context, url);
        return super.getActionURL(context, url);
    }

    protected String evaluateUrl(FacesContext context, String url) {
        if (url.startsWith("#") && (url = (String)context.getApplication().evaluateExpressionGet(context, url, String.class)) == null) {
            throw new FacesException("Evaluated view ID is null " + url);
        }
        return url;
    }

    protected boolean isPortletRequest(FacesContext context) {
        return BridgeUtil.isPortletRequest() || context.getExternalContext().getRequestParameterMap().containsKey("javax.faces.portletbridge.STATE_ID");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        ExternalContext externalContext;
        block12: {
            externalContext = context.getExternalContext();
            String renderPolicyParam = externalContext.getInitParameter("javax.portlet.faces.renderPolicy");
            Bridge.BridgeRenderPolicy renderPolicy = renderPolicyParam == null ? Bridge.BridgeRenderPolicy.DEFAULT : Bridge.BridgeRenderPolicy.valueOf((String)renderPolicyParam);
            if (null == externalContext.getRequestMap().get("javax.portlet.faces.phase") || renderPolicy == Bridge.BridgeRenderPolicy.ALWAYS_DELEGATE) {
                super.renderView(context, viewToRender);
                return;
            }
            if (renderPolicy == Bridge.BridgeRenderPolicy.DEFAULT) {
                try {
                    super.renderView(context, viewToRender);
                    return;
                }
                catch (Throwable t) {
                    if (!_log.isDebugEnabled()) break block12;
                    _log.debug((Object)"Error rendering view by parent ViewHandler, try to render as portletbridge JSP page", t);
                }
            }
        }
        if (!viewToRender.isRendered()) {
            return;
        }
        ExternalContext extContext = externalContext;
        RenderResponse renderResponse = (RenderResponse)extContext.getResponse();
        try {
            extContext.getRequestMap().put("javax.portlet.faces.RenderContentAfterView", Boolean.TRUE);
            if (this.executePageToBuildView(context, viewToRender)) {
                renderResponse.flushBuffer();
                return;
            }
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        RenderKitFactory renderFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit renderKit = renderFactory.getRenderKit(context, viewToRender.getRenderKitId());
        ResponseWriter oldWriter = context.getResponseWriter();
        StringBuilderWriter strWriter = new StringBuilderWriter(context, renderResponse.getWriter(), 4096);
        try {
            ResponseWriter newWriter = null != oldWriter ? oldWriter.cloneWithWriter((Writer)strWriter) : renderKit.createResponseWriter((Writer)strWriter, null, renderResponse.getCharacterEncoding());
            context.setResponseWriter(newWriter);
            newWriter.startDocument();
            this.doRenderView(context, viewToRender);
            newWriter.endDocument();
            strWriter.flushToWriter();
        }
        finally {
            strWriter.release();
        }
        if (null != oldWriter) {
            context.setResponseWriter(oldWriter);
        }
        renderResponse.flushBuffer();
    }

    private void doRenderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        viewToRender.encodeAll(context);
    }

    private boolean executePageToBuildView(FacesContext context, UIViewRoot viewToExecute) throws IOException {
        String requestURI = viewToExecute.getViewId();
        ExternalContext extContext = context.getExternalContext();
        extContext.dispatch(requestURI);
        return false;
    }

    protected ViewHandler getWrapped() {
        return this.parent;
    }

    private static final class StringBuilderWriter
    extends Writer {
        private static final ThreadLocal<StringBuilderWriter> instance = new ThreadLocal();
        private final StringBuilder mBuilder;
        private final FacesContext context;
        private final Writer responseWriter;
        private boolean stateWrited = false;
        private static final int SAVESTATE_MARK_LEN = "~com.sun.faces.saveStateFieldMarker~".length();

        public StringBuilderWriter(FacesContext context, Writer responseWriter, int initialCapacity) {
            if (initialCapacity < 0) {
                throw new IllegalArgumentException();
            }
            this.mBuilder = new StringBuilder(initialCapacity);
            this.context = context;
            this.responseWriter = responseWriter;
            instance.set(this);
        }

        public void release() {
            instance.remove();
        }

        public void stateWrited() {
            this.stateWrited = true;
        }

        public static StringBuilderWriter getInstance() {
            return instance.get();
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            if (this.stateWrited) {
                this.mBuilder.append(cbuf, off, len);
            } else {
                this.responseWriter.write(cbuf, off, len);
            }
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }

        public void write(String str) throws IOException {
            if (this.stateWrited) {
                this.mBuilder.append(str);
            } else {
                this.responseWriter.write(str);
            }
        }

        public void write(String str, int off, int len) throws IOException {
            if (this.stateWrited) {
                this.mBuilder.append(str, off, off + len);
            } else {
                this.responseWriter.write(str, off, len);
            }
        }

        public StringBuilder getBuffer() {
            return this.mBuilder;
        }

        public String toString() {
            return this.mBuilder.toString();
        }

        public void flushToWriter() throws IOException {
            if (this.stateWrited) {
                StateManager stateManager = this.context.getApplication().getStateManager();
                ResponseWriter oldResponseWriter = this.context.getResponseWriter();
                this.context.setResponseWriter(oldResponseWriter.cloneWithWriter(this.responseWriter));
                Object stateToWrite = stateManager.saveView(this.context);
                int pos = 0;
                int tildeIdx = this.mBuilder.indexOf(PortletViewHandler.SAVESTATE_FIELD_MARKER);
                while (tildeIdx >= 0) {
                    this.responseWriter.write(this.mBuilder.substring(pos, tildeIdx));
                    stateManager.writeState(this.context, stateToWrite);
                    pos = tildeIdx + SAVESTATE_MARK_LEN;
                    tildeIdx = this.mBuilder.indexOf(PortletViewHandler.SAVESTATE_FIELD_MARKER, pos);
                }
                this.responseWriter.write(this.mBuilder.substring(pos));
                this.context.setResponseWriter(oldResponseWriter);
            }
        }
    }
}

