/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.controller;

import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.StateString;
import org.jboss.portal.portlet.controller.PortletControllerContext;
import org.jboss.portal.portlet.controller.PortletRequestHandler;
import org.jboss.portal.portlet.controller.PortletResourceRequestHandler;
import org.jboss.portal.portlet.controller.RequestHandler;
import org.jboss.portal.portlet.controller.request.ControllerRequest;
import org.jboss.portal.portlet.controller.request.PortletRequest;
import org.jboss.portal.portlet.controller.request.PortletResourceRequest;
import org.jboss.portal.portlet.controller.response.ControllerResponse;
import org.jboss.portal.portlet.controller.state.PortletPageNavigationalState;
import org.jboss.portal.portlet.controller.state.PortletWindowNavigationalState;
import org.jboss.portal.portlet.invocation.RenderInvocation;
import org.jboss.portal.portlet.invocation.response.PortletInvocationResponse;
import org.jboss.portal.portlet.spi.PortletInvocationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletController {
    private boolean distributeNonConsumableEvents = true;
    private boolean distributeNonProduceableEvents = true;
    private int producedEventThreshold = 32;
    private int consumedEventThreshold = 64;

    public boolean getDistributeNonConsumableEvents() {
        return this.distributeNonConsumableEvents;
    }

    public void setDistributeNonConsumableEvents(boolean distributeNonConsumableEvents) {
        this.distributeNonConsumableEvents = distributeNonConsumableEvents;
    }

    public boolean getDistributeNonProduceableEvents() {
        return this.distributeNonProduceableEvents;
    }

    public void setDistributeNonProduceableEvents(boolean distributeNonProduceableEvents) {
        this.distributeNonProduceableEvents = distributeNonProduceableEvents;
    }

    public int getProducedEventThreshold() {
        return this.producedEventThreshold;
    }

    public void setProducedEventThreshold(int producedEventThreshold) {
        this.producedEventThreshold = producedEventThreshold;
    }

    public int getConsumedEventThreshold() {
        return this.consumedEventThreshold;
    }

    public void setConsumedEventThreshold(int consumedEventThreshold) {
        this.consumedEventThreshold = consumedEventThreshold;
    }

    public ControllerResponse process(PortletControllerContext controllerContext, ControllerRequest controllerRequest) throws PortletInvokerException {
        RequestHandler handler;
        if (controllerContext == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (controllerRequest == null) {
            throw new IllegalArgumentException("Null request");
        }
        if (controllerRequest instanceof PortletRequest) {
            handler = new PortletRequestHandler(this);
        } else if (controllerRequest instanceof PortletResourceRequest) {
            handler = new PortletResourceRequestHandler(this);
        } else {
            throw new IllegalArgumentException("Unknown request type: " + controllerRequest.getClass().getName());
        }
        return handler.handle(controllerContext, controllerRequest);
    }

    public PortletInvocationResponse render(PortletControllerContext controllerContext, List<Cookie> cookies, PortletPageNavigationalState pageNavigationalState, String windowId) throws PortletInvokerException {
        PortletWindowNavigationalState windowNS = null;
        if (pageNavigationalState != null) {
            windowNS = pageNavigationalState.getPortletWindowNavigationalState(windowId);
        }
        Map<String, String[]> publicNS = null;
        if (pageNavigationalState != null) {
            publicNS = pageNavigationalState.getPortletPublicNavigationalState(windowId);
        }
        Mode mode = Mode.VIEW;
        WindowState windowState = WindowState.NORMAL;
        StateString portletNS = null;
        if (windowNS != null) {
            if (windowNS.getMode() != null) {
                mode = windowNS.getMode();
            }
            if (windowNS.getWindowState() != null) {
                windowState = windowNS.getWindowState();
            }
            if (windowNS.getPortletNavigationalState() != null) {
                portletNS = windowNS.getPortletNavigationalState();
            }
        }
        PortletInvocationContext renderContext = controllerContext.createPortletInvocationContext(windowId, pageNavigationalState);
        RenderInvocation render = new RenderInvocation(renderContext);
        render.setMode(mode);
        render.setWindowState(windowState);
        render.setNavigationalState(portletNS);
        render.setPublicNavigationalState(publicNS);
        return controllerContext.invoke(cookies, render);
    }
}

