/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.management;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import org.jboss.portal.core.management.WSRPPortletManagement;
import org.jboss.portal.portlet.Portlet;
import org.jboss.portal.portlet.federation.FederatedPortletInvoker;
import org.jboss.portal.portlet.federation.FederatingPortletInvoker;
import org.jboss.portal.portlet.management.LocalPortletManagement;
import org.jboss.portal.portlet.management.PortletContainerManagementInterceptor;
import org.jboss.portal.portlet.management.PortletInfo;
import org.jboss.system.ServiceMBeanSupport;

public class PortletDiscoveryService
extends ServiceMBeanSupport {
    public static final String WSRP_JMX_PREFIX = "portal.management:service=Management,type=WSRPPorlet,name=";
    public static final String LOCAL_JMX_PREFIX = "portal.management:service=Management,type=LocalPortlet,name=";
    private PortletContainerManagementInterceptor interceptor;
    private FederatingPortletInvoker federatingPortletInvoker;
    private Map registeredPortlets = new HashMap();

    public void start() {
        try {
            this.processPortletDiscovery();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        for (ObjectName objectName : this.registeredPortlets.values()) {
            try {
                this.getServer().unregisterMBean(objectName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.registeredPortlets.size() != 0) {
            this.log.error((Object)"Unable to remove all the Portlet management MBeans");
        }
    }

    public FederatingPortletInvoker getFederatingPortletInvoker() {
        return this.federatingPortletInvoker;
    }

    public void setFederatingPortletInvoker(FederatingPortletInvoker federatingPortletInvoker) {
        this.federatingPortletInvoker = federatingPortletInvoker;
    }

    public void setInterceptor(PortletContainerManagementInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public void processPortletDiscovery() throws Exception {
        Collection federatedInvokers = this.federatingPortletInvoker.getFederatedInvokers();
        for (FederatedPortletInvoker federatedPortletInvoker : federatedInvokers) {
            if (federatedPortletInvoker.getId().equals("local")) {
                this.registerPortlets(federatedPortletInvoker.getPortlets(), false);
                continue;
            }
            this.registerPortlets(federatedPortletInvoker.getPortlets(), true);
        }
    }

    private void registerPortlets(Collection portlets, boolean wsrp) {
        for (Portlet portlet : portlets) {
            String portletId = portlet.getContext().getId();
            PortletInfo pinfo = this.interceptor.getPortletInfo(portletId);
            boolean used = this.interceptor.getPortletInfo(portletId).isUsed();
            if (this.registeredPortlets.containsKey(portletId) || !used) continue;
            try {
                ObjectName objectName = this.createManagementMBean(portlet, wsrp);
                this.registeredPortlets.put(portletId, objectName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private ObjectName createManagementMBean(Portlet portlet, boolean wsrp) throws Exception {
        WSRPPortletManagement management = null;
        management = wsrp ? new WSRPPortletManagement(portlet, this.interceptor) : new LocalPortletManagement(portlet, this.interceptor);
        ObjectName objectName = new ObjectName(this.getMBeanName(portlet, wsrp));
        this.getServer().registerMBean(management, objectName);
        this.log.debug((Object)("Registered Management MBean for: " + portlet.getContext().getId()));
        return objectName;
    }

    private String getMBeanName(Portlet portlet, boolean wsrp) {
        String id = portlet.getContext().getId();
        if (wsrp) {
            return WSRP_JMX_PREFIX + id;
        }
        return LOCAL_JMX_PREFIX + id;
    }
}

