/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.federation.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jboss.portal.portlet.InvokerUnavailableException;
import org.jboss.portal.portlet.NoSuchPortletException;
import org.jboss.portal.portlet.Portlet;
import org.jboss.portal.portlet.PortletContext;
import org.jboss.portal.portlet.PortletInvoker;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.federation.FederatedPortletInvoker;
import org.jboss.portal.portlet.federation.FederatingPortletInvoker;
import org.jboss.portal.portlet.federation.impl.FederatedPortletInvokerService;
import org.jboss.portal.portlet.invocation.PortletInvocation;
import org.jboss.portal.portlet.invocation.response.PortletInvocationResponse;
import org.jboss.portal.portlet.state.DestroyCloneFailure;
import org.jboss.portal.portlet.state.PropertyChange;
import org.jboss.portal.portlet.state.PropertyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FederatingPortletInvokerService
implements FederatingPortletInvoker {
    private static final Logger log = Logger.getLogger(FederatingPortletInvokerService.class);
    static final String SEPARATOR = ".";
    private volatile Map<String, FederatedPortletInvoker> registry = new HashMap<String, FederatedPortletInvoker>();

    @Override
    public synchronized FederatedPortletInvoker registerInvoker(String federatedId, PortletInvoker federatedInvoker) {
        if (federatedId == null) {
            throw new IllegalArgumentException("No null id");
        }
        if (federatedInvoker == null) {
            throw new IllegalArgumentException("No null invoker");
        }
        if (this.registry.containsKey(federatedId)) {
            throw new IllegalArgumentException("Attempting dual registration of " + federatedId);
        }
        HashMap<String, FederatedPortletInvoker> copy = new HashMap<String, FederatedPortletInvoker>(this.registry);
        FederatedPortletInvokerService invoker = new FederatedPortletInvokerService(this, federatedId, federatedInvoker);
        copy.put(federatedId, invoker);
        this.registry = copy;
        return invoker;
    }

    @Override
    public synchronized void unregisterInvoker(String federatedId) {
        if (federatedId == null) {
            throw new IllegalArgumentException("No null id accepted");
        }
        if (!this.registry.containsKey(federatedId)) {
            throw new IllegalArgumentException("Attempting to unregister unknown invoker " + federatedId);
        }
        HashMap<String, FederatedPortletInvoker> copy = new HashMap<String, FederatedPortletInvoker>(this.registry);
        copy.remove(federatedId);
        this.registry = copy;
    }

    @Override
    public FederatedPortletInvoker getFederatedInvoker(String federatedId) throws IllegalArgumentException {
        if (federatedId == null) {
            throw new IllegalArgumentException("No null id provided");
        }
        return this.registry.get(federatedId);
    }

    @Override
    public Collection<FederatedPortletInvoker> getFederatedInvokers() {
        return this.registry.values();
    }

    public Set<Portlet> getPortlets() throws PortletInvokerException {
        LinkedHashSet<Portlet> portlets = new LinkedHashSet<Portlet>();
        for (FederatedPortletInvoker federated : this.registry.values()) {
            try {
                Set offeredPortlets = federated.getPortlets();
                portlets.addAll(offeredPortlets);
            }
            catch (InvokerUnavailableException e) {
                Throwable cause = e.getCause();
                log.debug((Object)e.fillInStackTrace());
                log.warn((Object)("PortletInvoker with id: " + federated.getId() + " is not available.\nReason: " + e.getMessage() + "\nCaused by:\n" + (cause == null ? e : cause)));
            }
        }
        return portlets;
    }

    public Portlet getPortlet(PortletContext compoundPortletContext) throws IllegalArgumentException, PortletInvokerException {
        FederatedPortletInvoker federated = this.getFederatedPortletInvokerFor(compoundPortletContext);
        return federated.getPortlet(compoundPortletContext);
    }

    public PortletInvocationResponse invoke(PortletInvocation invocation) throws PortletInvokerException {
        PortletContext compoundPortletContext = invocation.getTarget();
        FederatedPortletInvoker federated = this.getFederatedPortletInvokerFor(compoundPortletContext);
        return federated.invoke(invocation);
    }

    public PortletContext createClone(PortletContext compoundPortletContext) throws PortletInvokerException {
        FederatedPortletInvoker federated = this.getFederatedPortletInvokerFor(compoundPortletContext);
        return federated.createClone(compoundPortletContext);
    }

    public List<DestroyCloneFailure> destroyClones(List<PortletContext> portletContexts) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        if (portletContexts == null) {
            throw new IllegalArgumentException("No null list accepted");
        }
        if (portletContexts.size() == 0) {
            return Collections.emptyList();
        }
        FederatedPortletInvoker invoker = null;
        for (PortletContext compoundPortletContext : portletContexts) {
            FederatedPortletInvoker federated = this.getFederatedPortletInvokerFor(compoundPortletContext);
            if (invoker == null) {
                invoker = federated;
                continue;
            }
            if (invoker.equals(federated)) continue;
            throw new PortletInvokerException("Cannot destroy portlet lists that requires more than one federated invoker");
        }
        return invoker.destroyClones(portletContexts);
    }

    public PropertyMap getProperties(PortletContext compoundPortletContext, Set<String> keys) throws PortletInvokerException {
        FederatedPortletInvoker federated = this.getFederatedPortletInvokerFor(compoundPortletContext);
        return federated.getProperties(compoundPortletContext, keys);
    }

    public PropertyMap getProperties(PortletContext compoundPortletContext) throws PortletInvokerException {
        FederatedPortletInvoker federated = this.getFederatedPortletInvokerFor(compoundPortletContext);
        return federated.getProperties(compoundPortletContext);
    }

    public PortletContext setProperties(PortletContext compoundPortletContext, PropertyChange[] changes) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        FederatedPortletInvoker federated = this.getFederatedPortletInvokerFor(compoundPortletContext);
        return federated.setProperties(compoundPortletContext, changes);
    }

    private FederatedPortletInvoker getFederatedPortletInvokerFor(PortletContext compoundPortletContext) throws IllegalArgumentException, NoSuchPortletException {
        if (compoundPortletContext == null) {
            throw new IllegalArgumentException("No null portlet id accepted");
        }
        String compoundPortletId = compoundPortletContext.getId();
        int pos = compoundPortletId.indexOf(SEPARATOR);
        if (pos == -1) {
            throw new IllegalArgumentException("Bad portlet id format " + compoundPortletId);
        }
        String invokerId = compoundPortletId.substring(0, pos);
        FederatedPortletInvoker federated = this.registry.get(invokerId);
        if (federated == null) {
            throw new NoSuchPortletException(compoundPortletId);
        }
        return federated;
    }
}

