/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jboss.ejb3.Ejb3Registry;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulContainer;

public class StatefulBeanContextReference
implements Externalizable {
    private static final long serialVersionUID = 2644760020735482423L;
    private transient StatefulBeanContext beanContext;
    private Object oid;
    private String containerGuid;
    private String containerClusterUid;
    private boolean isClustered = false;

    public StatefulBeanContextReference() {
    }

    public StatefulBeanContextReference(StatefulBeanContext beanContext) {
        this.beanContext = beanContext;
        this.oid = beanContext.getId();
        StatefulContainer statefulContainer = (StatefulContainer)beanContext.getContainer();
        this.containerGuid = Ejb3Registry.guid(statefulContainer);
        this.containerClusterUid = Ejb3Registry.clusterUid(statefulContainer);
        this.isClustered = statefulContainer.isClustered();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.containerGuid = in.readUTF();
        this.containerClusterUid = in.readUTF();
        this.oid = in.readObject();
        this.isClustered = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.containerGuid);
        out.writeUTF(this.containerClusterUid);
        out.writeObject(this.oid);
        out.writeBoolean(this.isClustered);
    }

    public StatefulBeanContext getBeanContext() {
        if (this.beanContext == null) {
            StatefulContainer container = (StatefulContainer)Ejb3Registry.findContainer(this.containerGuid);
            if (this.isClustered && container == null) {
                container = (StatefulContainer)Ejb3Registry.getClusterContainer(this.containerClusterUid);
            }
            this.beanContext = container.getCache().get(this.oid, false);
        }
        return this.beanContext;
    }
}

