/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.identity.services.workflow.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.portal.common.io.IOTools;
import org.jboss.portal.core.identity.services.IdentityUserManagementService;
import org.jboss.portal.core.identity.services.metadata.CoreIdentityConfigurationException;
import org.jboss.portal.core.identity.services.metadata.IdentityUIConfiguration;
import org.jboss.portal.core.identity.services.metadata.IdentityUIConfigurationService;
import org.jboss.portal.core.identity.services.workflow.RegistrationService;
import org.jboss.portal.core.identity.services.workflow.UserContainer;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.jems.as.JNDI;
import org.jboss.portal.jems.as.system.AbstractJBossService;
import org.jboss.portal.workflow.service.WorkflowService;
import org.jbpm.JbpmContext;
import org.jbpm.db.GraphSession;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistrationServiceImpl
extends AbstractJBossService
implements RegistrationService {
    private String subscriptionMode = null;
    private String adminSubscriptionMode = null;
    private IdentityUIConfigurationService identityUIConfigurationService;
    private IdentityUserManagementService identityUserManagementService;
    private WorkflowService workflowService = null;
    private static final Logger log = Logger.getLogger(RegistrationServiceImpl.class);
    private JNDI.Binding jndiBinding;
    private String jndiName = null;

    public void startService() throws Exception {
        super.startService();
        IdentityUIConfiguration cf = this.identityUIConfigurationService.getConfiguration();
        this.subscriptionMode = cf.getSubscriptionMode();
        this.adminSubscriptionMode = cf.getAdminSubscriptionMode();
        if (this.jndiName != null) {
            this.jndiBinding = new JNDI.Binding(this.jndiName, (Object)this);
            this.jndiBinding.bind();
        }
    }

    public void stopService() throws Exception {
        super.stopService();
        if (this.jndiBinding != null) {
            this.jndiBinding.unbind();
            this.jndiBinding = null;
        }
    }

    public WorkflowService getWorkflowService() throws CoreIdentityConfigurationException {
        if (this.workflowService == null) {
            this.workflowService = this.identityUIConfigurationService.getWorkflowService();
        }
        return this.workflowService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public void setJNDIName(String jndiName) {
        this.jndiName = jndiName;
    }

    public void setIdentityUIConfigurationService(IdentityUIConfigurationService identityUIConfigurationService) {
        this.identityUIConfigurationService = identityUIConfigurationService;
    }

    public IdentityUIConfigurationService getIdentityUIConfigurationService() {
        return this.identityUIConfigurationService;
    }

    public IdentityUserManagementService getIdentityUserManagementService() {
        return this.identityUserManagementService;
    }

    public void setIdentityUserManagementService(IdentityUserManagementService identityManagementService) {
        this.identityUserManagementService = identityManagementService;
    }

    @Override
    public String registerUser(String url, String username, String password, Map<String, Object> profileMap, List<String> roles, Locale locale, boolean adminFlag) throws CoreIdentityConfigurationException {
        if (adminFlag) {
            if (this.adminSubscriptionMode == null || "automatic".equals(this.adminSubscriptionMode)) {
                try {
                    this.getIdentityUserManagementService().createUser(username, password, profileMap, roles);
                    return "registered";
                }
                catch (IdentityException e) {
                    throw new CoreIdentityConfigurationException("registration failed", e);
                }
            }
            UserContainer user = new UserContainer(username, password, profileMap, roles);
            this.registerUserWorkflow(url, user, locale, this.adminSubscriptionMode);
            return "registration_pending";
        }
        if (this.subscriptionMode == null || "automatic".equals(this.subscriptionMode)) {
            try {
                this.getIdentityUserManagementService().createUser(username, password, profileMap, roles);
                return "registered";
            }
            catch (IdentityException e) {
                throw new CoreIdentityConfigurationException("registration failed", e);
            }
        }
        UserContainer user = new UserContainer(username, password, profileMap, roles);
        this.registerUserWorkflow(url, user, locale, this.subscriptionMode);
        return "registration_pending";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerUserWorkflow(String url, UserContainer user, Locale locale, String processName) throws CoreIdentityConfigurationException {
        JbpmContext jbpmContext = null;
        ProcessInstance processInstance = null;
        boolean success = false;
        try {
            jbpmContext = this.getWorkflowService().getJbpmConfiguration().createJbpmContext();
            processInstance = jbpmContext.newProcessInstance(processName);
            Token token = processInstance.getRootToken();
            processInstance.getContextInstance().setVariable("portalURL", (Object)url);
            processInstance.getContextInstance().setVariable("user", (Object)user);
            processInstance.getContextInstance().setVariable("email", user.getProfileMap().get("user.business-info.online.email"));
            processInstance.getContextInstance().setVariable("locale", (Object)locale);
            processInstance.getContextInstance().setVariable("action", (Object)"register");
            token.signal();
            success = true;
        }
        finally {
            if (processInstance != null && success) {
                jbpmContext.save(processInstance);
            }
            IOTools.safeClose((Object)jbpmContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String approve(String id, boolean approve) throws CoreIdentityConfigurationException {
        JbpmContext jbpmContext;
        block4: {
            if (!this.identityUIConfigurationService.getConfiguration().enableWorkflow()) {
                return "registered";
            }
            jbpmContext = null;
            try {
                Token token;
                long processId = Long.valueOf(id);
                jbpmContext = this.getWorkflowService().getJbpmConfiguration().createJbpmContext();
                ProcessInstance processInstance = jbpmContext.getProcessInstance(processId);
                if (processInstance == null || !(token = processInstance.getRootToken()).getNode().getName().equals("admin_approval")) break block4;
                if (approve) {
                    token.signal("approved");
                    break block4;
                }
                token.signal("rejected");
            }
            catch (Throwable throwable) {
                IOTools.safeClose(jbpmContext);
                throw throwable;
            }
        }
        IOTools.safeClose((Object)jbpmContext);
        return "registration_pending";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPendingCount() throws CoreIdentityConfigurationException {
        int count = 0;
        JbpmContext jbpmContext = null;
        try {
            List adminProcessInstances;
            List userProcessInstances = this.getProcessInstances(jbpmContext, this.subscriptionMode);
            if (userProcessInstances != null && userProcessInstances.size() > 0) {
                for (ProcessInstance instance : userProcessInstances) {
                    Node node = instance.getRootToken().getNode();
                    if (!"admin_approval".equals(node.getName())) continue;
                    count = !instance.hasEnded() ? count + 1 : count;
                }
            }
            if (!this.adminSubscriptionMode.equals(this.subscriptionMode) && !this.adminSubscriptionMode.equals("automatic") && (adminProcessInstances = this.getProcessInstances(jbpmContext, this.adminSubscriptionMode)) != null && adminProcessInstances.size() > 0) {
                for (ProcessInstance instance : adminProcessInstances) {
                    Node node = instance.getRootToken().getNode();
                    if (!"admin_approval".equals(node.getName())) continue;
                    count = !instance.hasEnded() ? count + 1 : count;
                }
            }
        }
        finally {
            IOTools.safeClose(jbpmContext);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UserContainer> getPendingUsers(String nodeName) throws CoreIdentityConfigurationException {
        ArrayList<UserContainer> queue = new ArrayList<UserContainer>();
        JbpmContext jbpmContext = null;
        try {
            List adminProcessInstances;
            List userProcessInstances = this.getProcessInstances(jbpmContext, this.subscriptionMode);
            if (userProcessInstances != null && userProcessInstances.size() > 0) {
                queue.addAll(this.getPendingUser(userProcessInstances, nodeName));
            }
            if (!this.adminSubscriptionMode.equals(this.subscriptionMode) && !this.adminSubscriptionMode.equals("automatic") && (adminProcessInstances = this.getProcessInstances(jbpmContext, this.adminSubscriptionMode)) != null && adminProcessInstances.size() > 0) {
                queue.addAll(this.getPendingUser(adminProcessInstances, nodeName));
            }
        }
        finally {
            IOTools.safeClose(jbpmContext);
        }
        return queue;
    }

    private List<UserContainer> getPendingUser(List processInstances, String nodeName) {
        ArrayList<UserContainer> queue = new ArrayList<UserContainer>();
        if (processInstances != null) {
            for (ProcessInstance instance : processInstances) {
                UserContainer user;
                if (instance.hasEnded()) continue;
                Node node = instance.getRootToken().getNode();
                Object obj = instance.getContextInstance().getVariable("user");
                if (nodeName != null && nodeName.equals(node.getName())) {
                    if (!(obj instanceof UserContainer)) continue;
                    user = (UserContainer)obj;
                    user.setProcessId(String.valueOf(instance.getId()));
                    user.setCurrentNode(node.getName());
                    queue.add(user);
                    continue;
                }
                if (nodeName != null || !(obj instanceof UserContainer)) continue;
                user = (UserContainer)obj;
                user.setProcessId(String.valueOf(instance.getId()));
                user.setCurrentNode(node.getName());
                queue.add(user);
            }
        }
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkUsername(String username) throws CoreIdentityConfigurationException {
        JbpmContext jbpmContext = null;
        try {
            List adminProcessInstances;
            List userProcessInstances = this.getProcessInstances(jbpmContext, this.subscriptionMode);
            if (userProcessInstances != null && userProcessInstances.size() > 0 && this.checkUsername(userProcessInstances, username)) {
                boolean bl = true;
                return bl;
            }
            if (!this.adminSubscriptionMode.equals(this.subscriptionMode) && !this.adminSubscriptionMode.equals("automatic") && (adminProcessInstances = this.getProcessInstances(jbpmContext, this.adminSubscriptionMode)) != null && adminProcessInstances.size() > 0 && this.checkUsername(adminProcessInstances, username)) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            IOTools.safeClose(jbpmContext);
        }
        return false;
    }

    private boolean checkUsername(List processInstances, String username) {
        boolean usernameTaken = false;
        if (processInstances != null) {
            for (ProcessInstance instance : processInstances) {
                Object obj;
                if (instance.hasEnded() || !((obj = instance.getContextInstance().getVariable("user")) instanceof UserContainer)) continue;
                UserContainer user = (UserContainer)obj;
                if (username == null || !username.equals(user.getUsername())) continue;
                usernameTaken = true;
            }
        }
        return usernameTaken;
    }

    private List getProcessInstances(JbpmContext jbpmContext, String processName) throws CoreIdentityConfigurationException {
        List processInstances = new ArrayList();
        if (!"automatic".equals(processName)) {
            GraphSession graphSession;
            ProcessDefinition processDefinition;
            if (jbpmContext == null) {
                jbpmContext = this.getWorkflowService().getJbpmConfiguration().createJbpmContext();
            }
            if ((processDefinition = (graphSession = jbpmContext.getGraphSession()).findLatestProcessDefinition(processName)) != null) {
                processInstances = graphSession.findProcessInstances(processDefinition.getId());
            } else {
                throw new CoreIdentityConfigurationException("Could not find process definition for process name: " + processName);
            }
        }
        return processInstances;
    }
}

