/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.security.impl.jacc;

import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import org.jboss.logging.Logger;
import org.jboss.portal.security.PortalPermission;
import org.jboss.portal.security.PortalSecurityException;
import org.jboss.portal.security.SecurityConstants;
import org.jboss.portal.security.impl.jacc.JACCPortalAuthorizationManagerFactory;
import org.jboss.portal.security.impl.jacc.JACCPortalPermissionCollection;
import org.jboss.portal.security.impl.jacc.JACCPortalPrincipal;
import org.jboss.portal.security.impl.jacc.SecurityContext;
import org.jboss.portal.security.spi.auth.PortalAuthorizationManager;
import org.jboss.portal.security.spi.provider.AuthorizationDomain;
import org.jboss.portal.security.spi.provider.PermissionFactory;

public class JACCPortalAuthorizationManager
implements PortalAuthorizationManager {
    private static Logger log = Logger.getLogger(JACCPortalAuthorizationManager.class);
    private static final boolean trace = log.isTraceEnabled();
    private final JACCPortalAuthorizationManagerFactory factory;
    private PolicyConfigurationFactory pcf;
    private static final ThreadLocal checkedSubjectLocal = new ThreadLocal();
    private SecurityContext securityContext = null;

    void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public JACCPortalAuthorizationManager(JACCPortalAuthorizationManagerFactory factory) {
        this.factory = factory;
        try {
            this.pcf = PolicyConfigurationFactory.getPolicyConfigurationFactory();
        }
        catch (Exception e) {
            log.error((Object)"Unable to obtain the PolicyConfigurationFactory", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkRoleConfig(String contextID, String roleName) throws PortalSecurityException {
        Map configuredRoles;
        Map map = configuredRoles = this.factory.configuredRoles;
        synchronized (map) {
            if (!configuredRoles.containsKey(roleName)) {
                Collection domains = this.factory.getAuthorizationDomainRegistry().getDomains();
                for (AuthorizationDomain domain : domains) {
                    JACCPortalPermissionCollection collection = new JACCPortalPermissionCollection(roleName, domain);
                    PermissionFactory permissionFactory = domain.getPermissionFactory();
                    PortalPermission container = permissionFactory.createPermissionContainer(collection);
                    if (SecurityConstants.UNCHECKED_ROLE_NAME.equals(roleName)) {
                        this.securityContext.addToUncheckedPolicy(container);
                        continue;
                    }
                    this.securityContext.addToRole(roleName, container);
                }
                configuredRoles.put(roleName, roleName);
            }
        }
    }

    private boolean internalCheckPermission(PortalPermission permission) throws IllegalArgumentException, PortalSecurityException {
        Principal[] principals;
        if (permission == null) {
            throw new IllegalArgumentException("No null permission can be checked");
        }
        String contextID = PolicyContext.getContextID();
        if (contextID == null) {
            throw new PortalSecurityException("No policy context id");
        }
        Subject currentSubject = (Subject)checkedSubjectLocal.get();
        this.checkRoleConfig(contextID, SecurityConstants.UNCHECKED_ROLE_NAME);
        if (currentSubject != null) {
            Set<JACCPortalPrincipal> tmp = currentSubject.getPrincipals(JACCPortalPrincipal.class);
            JACCPortalPrincipal pp2 = null;
            for (JACCPortalPrincipal pp2 : tmp) {
                if (pp2 != null) break;
            }
            if (pp2 == null) {
                pp2 = new JACCPortalPrincipal(currentSubject);
                tmp.add(pp2);
                for (Principal role : pp2.getRoles()) {
                    this.checkRoleConfig(contextID, role.getName());
                    if (!trace) continue;
                    log.trace((Object)("Internal check. Contains role: " + role.getName()));
                }
            }
            principals = pp2.getPrincipals();
        } else {
            principals = new Principal[]{};
        }
        ProtectionDomain pd = new ProtectionDomain(null, null, null, principals);
        boolean implied = this.securityContext.implies(pd, permission);
        return implied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkPermission(Subject checkedSubject, PortalPermission permission) throws IllegalArgumentException, PortalSecurityException {
        try {
            checkedSubjectLocal.set(checkedSubject);
            if (trace && checkedSubject != null) {
                for (Principal principal : checkedSubject.getPrincipals()) {
                    log.trace((Object)("Principal name: " + principal.getName()));
                }
            }
            if (trace) {
                log.trace((Object)("hasPermission:name=" + permission.getName() + "uri=" + permission.getURI() + "::actions=" + permission.getActions() + "::type=" + permission.getType()));
            }
            boolean result = this.internalCheckPermission(permission);
            if (trace) {
                log.trace((Object)("hasPermission:result=" + result));
            }
            boolean bl = result;
            return bl;
        }
        finally {
            checkedSubjectLocal.set(null);
        }
    }

    public boolean checkPermission(PortalPermission permission) throws IllegalArgumentException, PortalSecurityException {
        try {
            Subject subject = (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
            return this.checkPermission(subject, permission);
        }
        catch (PolicyContextException e) {
            throw new PortalSecurityException(e);
        }
    }

    static Subject getCheckedSubject() {
        return (Subject)checkedSubjectLocal.get();
    }
}

