/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.aspects.controller.node;

import org.jboss.portal.common.invocation.InvocationException;
import org.jboss.portal.core.aspects.controller.node.Navigation;
import org.jboss.portal.core.controller.ControllerCommand;
import org.jboss.portal.core.controller.ControllerInterceptor;
import org.jboss.portal.core.controller.ControllerResponse;
import org.jboss.portal.core.impl.api.PortalRuntimeContextImpl;
import org.jboss.portal.core.impl.api.node.PortalNodeImpl;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.core.model.portal.command.WindowCommand;
import org.jboss.portal.core.model.portal.command.render.RenderPageCommand;
import org.jboss.portal.security.spi.auth.PortalAuthorizationManager;
import org.jboss.portal.security.spi.auth.PortalAuthorizationManagerFactory;

public class PortalNodeInterceptor
extends ControllerInterceptor {
    private PortalAuthorizationManagerFactory portalAuthorizationManagerFactory;

    public PortalAuthorizationManagerFactory getPortalAuthorizationManagerFactory() {
        return this.portalAuthorizationManagerFactory;
    }

    public void setPortalAuthorizationManagerFactory(PortalAuthorizationManagerFactory portalAuthorizationManagerFactory) {
        this.portalAuthorizationManagerFactory = portalAuthorizationManagerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ControllerResponse invoke(ControllerCommand cmd) throws Exception, InvocationException {
        PortalNodeImpl next = this.getNode(cmd);
        PortalNodeImpl previous = Navigation.getCurrentNode();
        boolean noFactory = Navigation.getPortalRuntimeContext() == null;
        try {
            Navigation.setCurrentNode(next);
            if (noFactory) {
                Navigation.setPortalRuntimeContext(new PortalRuntimeContextImpl(cmd.getControllerContext()));
            }
            ControllerResponse controllerResponse = (ControllerResponse)cmd.invokeNext();
            return controllerResponse;
        }
        finally {
            Navigation.setCurrentNode(previous);
            if (noFactory) {
                Navigation.setPortalRuntimeContext(null);
            }
        }
    }

    private PortalNodeImpl getNode(ControllerCommand cmd) {
        PortalAuthorizationManager pam = this.portalAuthorizationManagerFactory.getManager();
        PortalNodeImpl next = null;
        if (cmd instanceof WindowCommand) {
            WindowCommand windowCmd = (WindowCommand)cmd;
            Window window = windowCmd.getWindow();
            next = new PortalNodeImpl(pam, (PortalObject)window);
        } else if (cmd instanceof RenderPageCommand) {
            RenderPageCommand rpCmd = (RenderPageCommand)cmd;
            Page page = rpCmd.getPage();
            next = new PortalNodeImpl(pam, (PortalObject)page);
        }
        return next;
    }
}

