/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.controller.portlet;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.common.util.CollectionBuilder;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.controller.portlet.ControllerUserContext;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.portlet.impl.spi.AbstractClientContext;
import org.jboss.portal.portlet.impl.spi.AbstractRequestContext;
import org.jboss.portal.portlet.impl.spi.AbstractSecurityContext;
import org.jboss.portal.portlet.impl.spi.AbstractServerContext;
import org.jboss.portal.portlet.spi.ClientContext;
import org.jboss.portal.portlet.spi.PortalContext;
import org.jboss.portal.portlet.spi.RequestContext;
import org.jboss.portal.portlet.spi.SecurityContext;
import org.jboss.portal.portlet.spi.ServerContext;
import org.jboss.portal.portlet.spi.UserContext;
import org.jboss.portal.portlet.spi.WindowContext;
import org.jboss.portal.server.PortalConstants;

public class PortletContextFactory {
    private PortalContext portalContext;
    private RequestContext requestContext;
    private SecurityContext securityContext;
    private UserContext userContext;
    private WindowContext windowContext;
    private ServerContext serverContext;
    private AbstractClientContext clientContext;
    private static final PortalContextImpl portalContextImpl = new PortalContextImpl();

    public PortletContextFactory(ControllerContext controllerContext, Portal portal, Window window) {
        this.requestContext = new AbstractRequestContext(controllerContext.getServerInvocation().getServerContext().getClientRequest());
        this.securityContext = new AbstractSecurityContext(controllerContext.getServerInvocation().getServerContext().getClientRequest());
        this.userContext = new ControllerUserContext(controllerContext);
        this.portalContext = new org.jboss.portal.core.model.portal.portlet.PortalContextImpl(portal);
        this.windowContext = new org.jboss.portal.core.model.portal.portlet.WindowContextImpl(window);
        this.serverContext = new AbstractServerContext(controllerContext.getServerInvocation().getServerContext().getClientRequest(), controllerContext.getServerInvocation().getServerContext().getClientResponse());
        this.clientContext = new AbstractClientContext(controllerContext.getServerInvocation().getServerContext().getClientRequest());
    }

    public PortletContextFactory(ControllerContext controllerContext) {
        this.requestContext = new AbstractRequestContext(controllerContext.getServerInvocation().getServerContext().getClientRequest());
        this.securityContext = new AbstractSecurityContext(controllerContext.getServerInvocation().getServerContext().getClientRequest());
        this.userContext = new ControllerUserContext(controllerContext);
        this.portalContext = portalContextImpl;
        this.windowContext = new WindowContextImpl("abc");
        this.serverContext = new AbstractServerContext(controllerContext.getServerInvocation().getServerContext().getClientRequest(), controllerContext.getServerInvocation().getServerContext().getClientResponse());
        this.clientContext = new AbstractClientContext(controllerContext.getServerInvocation().getServerContext().getClientRequest());
    }

    public PortalContext createPortalContext() {
        return this.portalContext;
    }

    public RequestContext createRequestContext() {
        return this.requestContext;
    }

    public SecurityContext createSecurityContext() {
        return this.securityContext;
    }

    public UserContext createUserContext() {
        return this.userContext;
    }

    public WindowContext createWindowContext() {
        return this.windowContext;
    }

    public ServerContext createServerContext() {
        return this.serverContext;
    }

    public ClientContext createClientContext() {
        return this.clientContext;
    }

    private static class WindowContextImpl
    implements WindowContext {
        private String id;

        public WindowContextImpl(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PortalContextImpl
    implements PortalContext {
        private final Set<WindowState> windowStates = Collections.unmodifiableSet((Set)CollectionBuilder.hashSet().add((Object)WindowState.MAXIMIZED).add((Object)WindowState.MINIMIZED).add((Object)WindowState.NORMAL).get());
        private final Set<Mode> modes = Collections.unmodifiableSet((Set)CollectionBuilder.hashSet().add((Object)Mode.EDIT).add((Object)Mode.HELP).add((Object)Mode.VIEW).get());
        private final Map props = Collections.EMPTY_MAP;

        public String getInfo() {
            return PortalConstants.VERSION.toString();
        }

        public Set<WindowState> getWindowStates() {
            return this.windowStates;
        }

        public Set<Mode> getModes() {
            return this.modes;
        }

        public Map getProperties() {
            return this.props;
        }
    }
}

