/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.model.instance.persistent;

import org.jboss.portal.common.i18n.LocalizedString;
import org.jboss.portal.core.impl.model.instance.AbstractInstanceCustomization;
import org.jboss.portal.core.impl.model.instance.AbstractInstanceDefinition;
import org.jboss.portal.core.impl.model.instance.InstanceContainerContext;
import org.jboss.portal.core.impl.model.instance.persistent.PersistentInstanceDefinition;
import org.jboss.portal.portlet.PortletContext;

class PersistentInstanceCustomization
extends AbstractInstanceCustomization {
    protected Long key;
    protected PersistentInstanceDefinition relatedDefinition;
    protected String customizationId;
    protected LocalizedString displayName;
    protected PersistentInstanceDefinition owner;
    protected boolean persistent;

    public PersistentInstanceCustomization(PersistentInstanceDefinition owner, String customizationId, PortletContext portletContext) {
        if (owner == null) {
            throw new IllegalArgumentException();
        }
        if (customizationId == null) {
            throw new IllegalArgumentException();
        }
        if (portletContext == null) {
            throw new IllegalArgumentException();
        }
        this.owner = owner;
        this.persistent = false;
        this.customizationId = customizationId;
        this.portletRef = portletContext.getId();
        this.state = portletContext.getState();
    }

    public PersistentInstanceCustomization() {
        this.owner = null;
        this.persistent = true;
    }

    public Long getKey() {
        return this.key;
    }

    public void setKey(Long key) {
        this.key = key;
    }

    public String getId() {
        return this.owner.getInstanceId();
    }

    public LocalizedString getDisplayName() {
        return this.owner.getDisplayName();
    }

    public void setDisplayName(LocalizedString localizedString) {
        this.displayName = localizedString;
    }

    public String getCustomizationId() {
        return this.customizationId;
    }

    public void setCustomizationId(String customizationId) {
        this.customizationId = customizationId;
    }

    public AbstractInstanceDefinition getOwner() {
        return this.owner;
    }

    public PersistentInstanceDefinition getRelatedDefinition() {
        return this.relatedDefinition;
    }

    public void setRelatedDefinition(PersistentInstanceDefinition relatedDefinition) {
        this.relatedDefinition = relatedDefinition;
        this.owner = relatedDefinition;
    }

    protected boolean isPersistent() {
        return this.persistent;
    }

    protected InstanceContainerContext getContainerContext() {
        return this.owner.containerContext;
    }
}

