/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.model.portal;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.InitialContext;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.exception.ConstraintViolationException;
import org.jboss.logging.Logger;
import org.jboss.portal.core.impl.model.portal.AbstractPortalObjectContainer;
import org.jboss.portal.core.impl.model.portal.ContextImpl;
import org.jboss.portal.core.impl.model.portal.ObjectNode;
import org.jboss.portal.core.impl.model.portal.PortalObjectImpl;
import org.jboss.portal.core.model.portal.DuplicatePortalObjectException;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.jems.hibernate.ObjectContextualizer;
import org.jboss.portal.security.impl.JBossAuthorizationDomainRegistry;
import org.jboss.portal.security.spi.auth.PortalAuthorizationManagerFactory;
import org.jboss.portal.security.spi.provider.AuthorizationDomain;

public class PersistentPortalObjectContainer
extends AbstractPortalObjectContainer {
    private static final String LOOKUP_QUERY_FOR_ROOT = "from ObjectNode where path=:path or path is null";
    private static final String LOOKUP_QUERY = "from ObjectNode where path=:path";
    private static Logger log = Logger.getLogger(PersistentPortalObjectContainer.class);
    protected SessionFactory sessionFactory;
    protected AbstractPortalObjectContainer.ContainerContext ctx = new AbstractPortalObjectContainer.ContainerContext(){

        public void destroyChild(ObjectNode node) {
            Session session = PersistentPortalObjectContainer.this.sessionFactory.getCurrentSession();
            PortalObjectImpl object = node.getObject();
            session.delete((Object)object);
            session.delete((Object)node);
            session.flush();
        }

        public void createChild(ObjectNode node) throws DuplicatePortalObjectException {
            Session session = PersistentPortalObjectContainer.this.sessionFactory.getCurrentSession();
            try {
                session.save((Object)node);
                session.save((Object)node.getObject());
                session.flush();
            }
            catch (ConstraintViolationException e) {
                log.warn((Object)("The configured database is probably case-insensitive. " + e.getMessage()));
                session.close();
                throw new DuplicatePortalObjectException();
            }
        }

        public void updated(ObjectNode node) {
            Session session = PersistentPortalObjectContainer.this.sessionFactory.getCurrentSession();
            session.flush();
        }
    };
    protected PortalAuthorizationManagerFactory portalAuthorizationManagerFactory;
    protected JBossAuthorizationDomainRegistry authorizationDomainRegistry;
    protected String sessionFactoryJNDIName;
    protected ObjectContextualizer contextualizer = new ObjectContextualizer((Object)this.ctx);
    protected ConcurrentHashMap cache = new ConcurrentHashMap();
    protected boolean cacheNaturalId;
    protected String rootName;

    public String getRootName() {
        return this.rootName;
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }

    public void flushNaturalIdCache() {
        this.cache.clear();
    }

    public int getNaturalIdCacheSize() {
        return this.cache.size();
    }

    public boolean getCacheNaturalId() {
        return this.cacheNaturalId;
    }

    public void setCacheNaturalId(boolean cacheNaturalId) {
        this.cacheNaturalId = cacheNaturalId;
    }

    public JBossAuthorizationDomainRegistry getAuthorizationDomainRegistry() {
        return this.authorizationDomainRegistry;
    }

    public void setAuthorizationDomainRegistry(JBossAuthorizationDomainRegistry authDomainRegistry) {
        this.authorizationDomainRegistry = authDomainRegistry;
    }

    public PortalAuthorizationManagerFactory getPortalAuthorizationManagerFactory() {
        return this.portalAuthorizationManagerFactory;
    }

    public void setPortalAuthorizationManagerFactory(PortalAuthorizationManagerFactory pamf) {
        this.portalAuthorizationManagerFactory = pamf;
    }

    public void setSessionFactoryJNDIName(String sessionFactoryJNDIName) {
        this.sessionFactoryJNDIName = sessionFactoryJNDIName;
    }

    public AbstractPortalObjectContainer.ContainerContext getContainerContext() {
        return this.ctx;
    }

    protected void startService() throws Exception {
        this.sessionFactory = (SessionFactory)new InitialContext().lookup(this.sessionFactoryJNDIName);
        this.contextualizer.attach(this.sessionFactory);
        if (this.authorizationDomainRegistry != null) {
            this.authorizationDomainRegistry.addDomain((AuthorizationDomain)this);
        }
        super.startService();
    }

    protected void stopService() throws Exception {
        super.stopService();
        if (this.authorizationDomainRegistry != null) {
            this.authorizationDomainRegistry.removeDomain((AuthorizationDomain)this);
        }
        this.sessionFactory = null;
    }

    protected ContextImpl createRoot(String namespace) throws DuplicatePortalObjectException {
        log.debug((Object)"Detecting the existence of the portal object root context");
        Session session = this.sessionFactory.getCurrentSession();
        ObjectNode root = this.getObjectNode((org.hibernate.Session)session, new PortalObjectId(namespace, PortalObjectPath.ROOT_PATH));
        if (root == null) {
            log.debug((Object)"The root context of the object tree does not exist, about to create it");
            root = new ObjectNode(this.ctx, new PortalObjectId(namespace, PortalObjectPath.ROOT_PATH), namespace);
            session.save((Object)root);
            ContextImpl ctx = new ContextImpl();
            root.setObject(ctx);
            ctx.setObjectNode(root);
            session.save((Object)ctx);
            log.info((Object)("Created portal object root context for namespace " + namespace));
            return ctx;
        }
        throw new DuplicatePortalObjectException("namespace " + namespace + " already exists");
    }

    protected ObjectNode getObjectNode(PortalObjectId path) {
        return this.getObjectNode((org.hibernate.Session)this.sessionFactory.getCurrentSession(), path);
    }

    private ObjectNode getObjectNodeNoCache(org.hibernate.Session session, PortalObjectId id) {
        String queryString = LOOKUP_QUERY;
        if (id.getPath().getLength() == 0 && id.getNamespace().length() == 0) {
            queryString = LOOKUP_QUERY_FOR_ROOT;
        }
        Query query = session.createQuery(queryString);
        query.setParameter("path", (Object)id);
        Object result = query.uniqueResult();
        return (ObjectNode)result;
    }

    private ObjectNode getObjectNode(org.hibernate.Session session, PortalObjectId id) {
        ObjectNode objectNode;
        Long pk;
        Long l = pk = this.cacheNaturalId ? (Long)this.cache.get(id) : null;
        if (pk == null) {
            objectNode = this.getObjectNodeNoCache(session, id);
        } else {
            objectNode = (ObjectNode)session.get(ObjectNode.class, (Serializable)pk);
            if (objectNode == null) {
                objectNode = this.getObjectNodeNoCache(session, id);
            }
        }
        if (this.cacheNaturalId) {
            if (objectNode != null) {
                this.cache.put(id, objectNode.getKey());
            } else {
                this.cache.remove(id);
            }
        }
        return objectNode;
    }
}

