/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model.portal.navstate;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.portal.WindowState;
import org.jboss.portal.common.invocation.AttributeResolver;
import org.jboss.portal.core.model.portal.navstate.PageNavigationalState;
import org.jboss.portal.core.model.portal.navstate.WindowNavigationalState;

public class NavigationAttributeResolver
implements AttributeResolver {
    static final String mapName = "osivia.navigationMap";
    final HttpServletRequest request;
    private static final Logger logger = Logger.getLogger(NavigationAttributeResolver.class);

    public NavigationAttributeResolver(HttpServletRequest request) {
        this.request = request;
    }

    private synchronized Map<Object, Object> getMap() {
        ConcurrentHashMap map = (ConcurrentHashMap)this.request.getAttribute(mapName);
        if (map == null) {
            map = new ConcurrentHashMap();
            this.request.setAttribute(mapName, map);
        }
        return map;
    }

    public Set getKeys() {
        return this.getMap().keySet();
    }

    private void dump(String action, Object attrKey, Object attrValue) {
        if (attrValue != null && attrValue instanceof PageNavigationalState) {
            PageNavigationalState pageState = (PageNavigationalState)attrValue;
            String[] sPath = null;
            if (pageState != null) {
                sPath = pageState.getParameter(new QName("", "osivia.cms.contentPath"));
            }
            String pathPublication = null;
            if (sPath != null && sPath.length > 0) {
                pathPublication = sPath[0];
            }
            logger.info((Object)(action + " osivia.cms.contentPath-> " + pathPublication));
        }
        if (attrValue != null && attrValue instanceof WindowNavigationalState) {
            WindowNavigationalState windowState = (WindowNavigationalState)attrValue;
            if (attrKey.toString().endsWith("CMSPlayerWindow")) {
                logger.info((Object)(action + "  REQUEST " + attrKey + "-> " + windowState.getWindowState()));
                if (windowState.getWindowState().equals((Object)WindowState.NORMAL)) {
                    StackTraceElement[] trace = Thread.currentThread().getStackTrace();
                    int l = 1;
                    for (StackTraceElement traceElement : trace) {
                        logger.info((Object)traceElement);
                        if (++l > 5) break;
                    }
                }
            }
        }
    }

    public Object getAttribute(Object attrKey) throws IllegalArgumentException {
        Object value = this.getMap().get(attrKey);
        return value;
    }

    public void setAttribute(Object attrKey, Object attrValue) throws IllegalArgumentException {
        if (attrValue == null) {
            this.getMap().remove(attrKey);
        } else {
            this.getMap().put(attrKey, attrValue);
        }
    }
}

