/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.theme.impl;

import org.jboss.portal.common.util.ContentInfo;
import org.jboss.portal.common.util.MarkupInfo;
import org.jboss.portal.theme.LayoutInfo;
import org.jboss.portal.theme.LayoutServiceInfo;
import org.jboss.portal.theme.PortalRenderSet;
import org.jboss.portal.theme.render.ObjectRenderer;
import org.jboss.portal.theme.render.ObjectRendererContext;
import org.jboss.portal.theme.render.RendererContext;
import org.jboss.portal.theme.render.RendererFactory;
import org.jboss.portal.theme.render.renderer.DecorationRendererContext;
import org.jboss.portal.theme.render.renderer.PageRenderer;
import org.jboss.portal.theme.render.renderer.PageRendererContext;
import org.jboss.portal.theme.render.renderer.PortletRendererContext;
import org.jboss.portal.theme.render.renderer.RegionRendererContext;
import org.jboss.portal.theme.render.renderer.WindowRendererContext;

public class RendererFactoryImpl
implements RendererFactory {
    private PageRenderer pageRenderer;
    private LayoutServiceInfo layoutServiceInfo;
    private LayoutInfo layoutInfo;

    public RendererFactoryImpl(PageRenderer pageRenderer, LayoutServiceInfo layoutServiceInfo, LayoutInfo layoutInfo) {
        this.pageRenderer = pageRenderer;
        this.layoutServiceInfo = layoutServiceInfo;
        this.layoutInfo = layoutInfo;
    }

    public ObjectRenderer getRenderer(RendererContext rendererContext, ObjectRendererContext objectRendererContext) {
        if (objectRendererContext instanceof PageRendererContext) {
            return this.pageRenderer;
        }
        if (objectRendererContext instanceof RegionRendererContext) {
            return this.getRegionRenderer(rendererContext, (RegionRendererContext)objectRendererContext);
        }
        if (objectRendererContext instanceof WindowRendererContext) {
            return this.getWindowRenderer(rendererContext, (WindowRendererContext)objectRendererContext);
        }
        if (objectRendererContext instanceof PortletRendererContext) {
            return this.getPortletRenderer(rendererContext, (PortletRendererContext)objectRendererContext);
        }
        if (objectRendererContext instanceof DecorationRendererContext) {
            return this.getDecorationRenderer(rendererContext, (DecorationRendererContext)objectRendererContext);
        }
        return null;
    }

    private ObjectRenderer getRegionRenderer(RendererContext rendererContext, RegionRendererContext objectRenderContext) {
        return this.getRenderSet(rendererContext).getRegionRenderer();
    }

    public ObjectRenderer getWindowRenderer(RendererContext rendererContext, WindowRendererContext result) {
        PortalRenderSet renderSet;
        String renderSetName = null;
        if (result != null) {
            renderSetName = result.getProperty("theme.windowRendererId");
        }
        if (result != null && renderSetName == null) {
            renderSetName = rendererContext.getProperty("theme.windowRendererId");
        }
        if (renderSetName != null && (renderSet = this.layoutServiceInfo.getRenderSet(renderSetName, rendererContext.getMediaType())) != null) {
            return renderSet.getWindowRenderer();
        }
        return this.getRenderSet(rendererContext).getWindowRenderer();
    }

    public ObjectRenderer getDecorationRenderer(RendererContext rendererContext, DecorationRendererContext result) {
        PortalRenderSet renderSet;
        String renderSetName = null;
        if (result != null) {
            renderSetName = result.getProperty("theme.decorationRendererId");
        }
        if (result != null && renderSetName == null) {
            renderSetName = rendererContext.getProperty("theme.decorationRendererId");
        }
        if (renderSetName != null && (renderSet = this.layoutServiceInfo.getRenderSet(renderSetName, rendererContext.getMediaType())) != null) {
            return renderSet.getDecorationRenderer();
        }
        return this.getRenderSet(rendererContext).getDecorationRenderer();
    }

    public ObjectRenderer getPortletRenderer(RendererContext rendererContext, PortletRendererContext result) {
        PortalRenderSet renderSet;
        String renderSetName = null;
        if (result != null) {
            renderSetName = result.getProperty("theme.portletRendererId");
        }
        if (result != null && renderSetName == null) {
            renderSetName = rendererContext.getProperty("theme.portletRendererId");
        }
        if (renderSetName != null && (renderSet = this.layoutServiceInfo.getRenderSet(renderSetName, rendererContext.getMediaType())) != null) {
            return renderSet.getPortletRenderer();
        }
        return this.getRenderSet(rendererContext).getPortletRenderer();
    }

    private PortalRenderSet getRenderSet(RendererContext rendererContext) {
        String renderSetName = rendererContext.getProperty("theme.renderSetId");
        MarkupInfo contentInfo = rendererContext.getMarkupInfo();
        return this.layoutServiceInfo.getRenderSet(this.layoutInfo, (ContentInfo)contentInfo, renderSetName);
    }
}

