/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.identity.ui.validators;

import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class EmailValidator
implements Validator {
    private static final String EMAIL_VALIDATION = "^[_a-zA-Z0-9-]+(\\.[_a-zA-Z0-9-]+)*@[a-zA-Z0-9-]+(\\.[a-zA-Z0-9-]+)*\\.(([0-9]{1,3})|([a-zA-Z]{2,3})|(aero|coop|info|museum|name))$";

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        ResourceBundle bundle = ResourceBundle.getBundle("conf.bundles.Identity", context.getViewRoot().getLocale());
        if (value != null) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("The value must be a String");
            }
            if (!Pattern.matches(EMAIL_VALIDATION, (String)value)) {
                throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("IDENTITY_VALIDATION_ERROR_INVALID_EMAIL"), bundle.getString("IDENTITY_VALIDATION_ERROR_INVALID_EMAIL")));
            }
        } else {
            throw new ValidatorException(new FacesMessage("Required"));
        }
    }
}

