/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.aspects.portlet;

import java.io.Serializable;
import java.util.Map;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.common.util.ParameterMap;
import org.jboss.portal.portlet.ParametersStateString;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.PortletInvokerInterceptor;
import org.jboss.portal.portlet.StateString;
import org.jboss.portal.portlet.aspects.portlet.cache.ContentRef;
import org.jboss.portal.portlet.aspects.portlet.cache.StrongContentRef;
import org.jboss.portal.portlet.cache.CacheControl;
import org.jboss.portal.portlet.invocation.PortletInvocation;
import org.jboss.portal.portlet.invocation.RenderInvocation;
import org.jboss.portal.portlet.invocation.response.ContentResponse;
import org.jboss.portal.portlet.invocation.response.PortletInvocationResponse;
import org.jboss.portal.portlet.invocation.response.RevalidateMarkupResponse;
import org.jboss.portal.portlet.spi.UserContext;

public class ConsumerCacheInterceptor
extends PortletInvokerInterceptor {
    public PortletInvocationResponse invoke(PortletInvocation invocation) throws IllegalArgumentException, PortletInvokerException {
        String scopeKey = "cached_markup." + invocation.getWindowContext().getId();
        UserContext userContext = invocation.getUserContext();
        if (invocation instanceof RenderInvocation) {
            ContentResponse fragment;
            RenderInvocation renderInvocation = (RenderInvocation)invocation;
            StateString navigationalState = renderInvocation.getNavigationalState();
            Map<String, String[]> publicNavigationalState = renderInvocation.getPublicNavigationalState();
            WindowState windowState = renderInvocation.getWindowState();
            Mode mode = renderInvocation.getMode();
            CacheEntry cachedEntry = (CacheEntry)userContext.getAttribute(scopeKey);
            if (cachedEntry != null) {
                boolean useEntry = false;
                StateString entryNavigationalState = cachedEntry.navigationalState;
                Map entryPublicNavigationalState = cachedEntry.publicNavigationalState;
                if (navigationalState == null) {
                    if (entryNavigationalState == null) {
                        useEntry = true;
                    } else if (entryNavigationalState instanceof ParametersStateString) {
                        useEntry = ((ParametersStateString)entryNavigationalState).getSize() == 0;
                    }
                } else if (entryNavigationalState == null) {
                    if (navigationalState instanceof ParametersStateString) {
                        useEntry = ((ParametersStateString)navigationalState).getSize() == 0;
                    }
                } else {
                    useEntry = navigationalState.equals(entryNavigationalState);
                }
                if (useEntry) {
                    if (publicNavigationalState == null) {
                        if (entryPublicNavigationalState != null) {
                            useEntry = entryPublicNavigationalState.size() == 0;
                        }
                    } else if (entryPublicNavigationalState == null) {
                        useEntry = publicNavigationalState.size() == 0;
                    } else {
                        ParameterMap publicPM = ParameterMap.wrap(publicNavigationalState);
                        ParameterMap entryPM = ParameterMap.wrap((Map)entryPublicNavigationalState);
                        useEntry = publicPM.equals((Object)entryPM);
                    }
                }
                useEntry &= windowState.equals((Object)cachedEntry.windowState);
                if (!(useEntry &= mode.equals((Object)cachedEntry.mode))) {
                    cachedEntry = null;
                    userContext.setAttribute(scopeKey, null);
                }
            }
            ContentResponse contentResponse = fragment = cachedEntry != null ? cachedEntry.contentRef.getContent() : null;
            if (fragment == null || cachedEntry.expirationTimeMillis < System.currentTimeMillis()) {
                if (fragment != null) {
                    renderInvocation.setValidationToken(cachedEntry.validationToken);
                }
                PortletInvocationResponse response = super.invoke(invocation);
                CacheControl control = null;
                if (response instanceof ContentResponse) {
                    fragment = (ContentResponse)response;
                    control = fragment.getCacheControl();
                } else if (response instanceof RevalidateMarkupResponse) {
                    RevalidateMarkupResponse revalidate = (RevalidateMarkupResponse)response;
                    control = revalidate.getCacheControl();
                }
                long expirationTimeMillis = 0L;
                String validationToken = null;
                if (control != null) {
                    if (control.getExpirationSecs() == -1) {
                        expirationTimeMillis = Long.MAX_VALUE;
                    } else if (control.getExpirationSecs() > 0) {
                        expirationTimeMillis = System.currentTimeMillis() + (long)(control.getExpirationSecs() * 1000);
                    }
                    if (control.getValidationToken() != null) {
                        validationToken = control.getValidationToken();
                    } else if (cachedEntry != null) {
                        validationToken = cachedEntry.validationToken;
                    }
                }
                if (expirationTimeMillis > 0L) {
                    CacheEntry cacheEntry = new CacheEntry(navigationalState, publicNavigationalState, windowState, mode, fragment, expirationTimeMillis, validationToken);
                    userContext.setAttribute(scopeKey, cacheEntry);
                }
                return response;
            }
            return fragment;
        }
        userContext.setAttribute(scopeKey, null);
        return super.invoke(invocation);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheEntry
    implements Serializable {
        private final StateString navigationalState;
        private final WindowState windowState;
        private final Mode mode;
        private final Map<String, String[]> publicNavigationalState;
        private final ContentRef contentRef;
        private final long expirationTimeMillis;
        private final String validationToken;

        public CacheEntry(StateString navigationalState, Map<String, String[]> publicNavigationalState, WindowState windowState, Mode mode, ContentResponse content, long expirationTimeMillis, String validationToken) {
            if (expirationTimeMillis <= 0L) {
                throw new IllegalArgumentException();
            }
            this.navigationalState = navigationalState;
            this.windowState = windowState;
            this.mode = mode;
            this.publicNavigationalState = publicNavigationalState;
            this.contentRef = new StrongContentRef(content);
            this.expirationTimeMillis = expirationTimeMillis;
            this.validationToken = validationToken;
        }
    }
}

