/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.impl.jsr168.api;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.common.util.Tools;
import org.jboss.portal.portlet.impl.jsr168.PortletUtils;
import org.jboss.portal.portlet.spi.PortalContext;

public class PortalContextImpl
implements javax.portlet.PortalContext {
    private PortalContext portal;
    private Map properties;
    private Set supportedPortletModes;
    private Set supportedWindowStates;

    public PortalContextImpl(PortalContext portal) {
        if (portal == null) {
            throw new IllegalArgumentException("Must provide a non-null PortalContext!");
        }
        this.portal = portal;
        this.properties = portal.getProperties();
    }

    public String getPortalInfo() {
        return this.portal.getInfo();
    }

    public String getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Must provide a non-null property name");
        }
        return (String)this.properties.get(name);
    }

    public Enumeration getPropertyNames() {
        return Tools.toEnumeration(this.properties.keySet().iterator());
    }

    public Enumeration getSupportedPortletModes() {
        if (this.supportedPortletModes == null) {
            Set<Mode> tmp = this.portal.getModes();
            this.supportedPortletModes = new HashSet(tmp.size());
            for (Mode mode : tmp) {
                this.supportedPortletModes.add(PortletUtils.decodePortletMode(mode.toString()));
            }
        }
        return Tools.toEnumeration(this.supportedPortletModes.iterator());
    }

    public Enumeration getSupportedWindowStates() {
        if (this.supportedWindowStates == null) {
            Set<WindowState> tmp = this.portal.getWindowStates();
            this.supportedWindowStates = new HashSet(tmp.size());
            for (WindowState windowState : tmp) {
                this.supportedWindowStates.add(PortletUtils.decodeWindowState(windowState.toString()));
            }
        }
        return Tools.toEnumeration(this.supportedWindowStates.iterator());
    }
}

