/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.impl.spi;

import org.jboss.portal.portlet.PortletContext;
import org.jboss.portal.portlet.StateEvent;
import org.jboss.portal.portlet.spi.InstanceContext;
import org.jboss.portal.portlet.state.AccessMode;

public class AbstractInstanceContext
implements InstanceContext {
    private final String id;
    private final AccessMode accessMode;
    private PortletContext clonedContext;
    private PortletContext modifiedContext;

    public AbstractInstanceContext(String id) {
        this(id, AccessMode.READ_ONLY);
    }

    public AbstractInstanceContext(String id, AccessMode accessMode) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if (accessMode == null) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.accessMode = accessMode;
    }

    public String getId() {
        return this.id;
    }

    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    public void onStateEvent(StateEvent event) {
        switch (event.getType()) {
            case PORTLET_CLONED_EVENT: {
                this.clonedContext = event.getPortletContext();
                break;
            }
            case PORTLET_MODIFIED_EVENT: {
                this.modifiedContext = event.getPortletContext();
            }
        }
    }

    public PortletContext getClonedContext() {
        return this.clonedContext;
    }

    public PortletContext getModifiedContext() {
        return this.modifiedContext;
    }
}

