/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.store.bulkload;

import java.util.HashSet;
import java.util.Set;
import net.sf.ehcache.constructs.nonstop.NonStopCacheException;
import org.terracotta.modules.ehcache.store.bulkload.BulkLoadToolkitCache;
import org.terracotta.toolkit.cache.ToolkitCache;
import org.terracotta.toolkit.cluster.ClusterInfo;
import org.terracotta.toolkit.internal.ToolkitInternal;

public class BulkLoadShutdownHook
implements Runnable {
    private final Set<BulkLoadToolkitCache> registeredCaches = new HashSet<BulkLoadToolkitCache>();
    private final ClusterInfo terracottaClusterInfo;
    private final ToolkitInternal toolkit;
    private boolean init = false;

    public BulkLoadShutdownHook(ToolkitInternal toolkit) {
        this.toolkit = toolkit;
        this.terracottaClusterInfo = toolkit.getClusterInfo();
    }

    public synchronized void init() {
        if (this.init) {
            return;
        }
        this.toolkit.registerBeforeShutdownHook(new Runnable(){

            @Override
            public void run() {
                BulkLoadShutdownHook.this.shutdownRegisteredCaches();
            }
        });
        this.init = true;
    }

    @Override
    public void run() {
        this.shutdownRegisteredCaches();
    }

    private synchronized void shutdownRegisteredCaches() {
        if (this.registeredCaches.size() != 0 && this.terracottaClusterInfo.areOperationsEnabled()) {
            for (BulkLoadToolkitCache cache : this.registeredCaches) {
                try {
                    if (!cache.isBulkLoadEnabledInCurrentNode()) continue;
                    cache.setBulkLoadEnabledInCurrentNode(false);
                }
                catch (NonStopCacheException nonStopCacheException) {}
            }
        }
    }

    public synchronized void registerCache(BulkLoadToolkitCache cache) {
        this.registeredCaches.add(cache);
    }

    public synchronized void unregisterCache(ToolkitCache cache) {
        this.registeredCaches.remove(cache);
    }
}

