/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.admin.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.faces.el.PropertyResolver;
import javax.faces.model.SelectItem;
import org.jboss.portal.common.i18n.LocalizedString;
import org.jboss.portal.common.net.media.MediaType;
import org.jboss.portal.common.util.IteratorStatus;
import org.jboss.portal.common.util.Tools;
import org.jboss.portal.core.impl.model.content.ContentProviderRegistryService;
import org.jboss.portal.core.model.content.ContentType;
import org.jboss.portal.core.model.content.spi.portlet.ContentPortlet;
import org.jboss.portal.core.model.instance.Instance;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.core.portlet.info.PortletInfoInfo;
import org.jboss.portal.core.portlet.info.WSRPInfo;
import org.jboss.portal.faces.el.DelegatingPropertyResolver;
import org.jboss.portal.faces.el.decorator.AbstractBeanDecorator;
import org.jboss.portal.faces.el.decorator.AbstractPropertyDecorator;
import org.jboss.portal.faces.el.decorator.BeanDecorator;
import org.jboss.portal.faces.el.decorator.PropertyDecorator;
import org.jboss.portal.faces.el.decorator.SimpleBeanDecorator;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.RoleModule;
import org.jboss.portal.portlet.Portlet;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.info.NavigationInfo;
import org.jboss.portal.portlet.info.PortletInfo;
import org.jboss.portal.security.AuthorizationDomainRegistry;
import org.jboss.portal.security.spi.provider.AuthorizationDomain;
import org.jboss.portal.theme.LayoutService;
import org.jboss.portal.theme.PortalLayout;
import org.jboss.portal.theme.PortalRenderSet;
import org.jboss.portal.theme.PortalTheme;
import org.jboss.portal.theme.ServerRegistrationID;
import org.jboss.portal.theme.ThemeService;

public class AdminPropertyResolver
extends DelegatingPropertyResolver {
    public AdminPropertyResolver() {
        this.init();
    }

    public AdminPropertyResolver(PropertyResolver delegate) {
        super(delegate);
        this.init();
    }

    private void init() {
        SimpleBeanDecorator roleModuleDecorator = new SimpleBeanDecorator();
        roleModuleDecorator.setProperty((Object)"roles", (PropertyDecorator)new AbstractPropertyDecorator(Set.class){

            public Object getValue(Object bean) {
                try {
                    RoleModule module = (RoleModule)bean;
                    return module.findRoles();
                }
                catch (IdentityException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        this.registerDecorator(RoleModule.class, (BeanDecorator)roleModuleDecorator);
        SimpleBeanDecorator localizedStringDecorator = new SimpleBeanDecorator();
        localizedStringDecorator.setProperty((Object)"value", (PropertyDecorator)new AbstractPropertyDecorator(String.class){

            public Object getValue(Object bean) {
                LocalizedString string = (LocalizedString)bean;
                return AdminPropertyResolver.this.getValueForRequestLocale(string);
            }
        });
        this.registerDecorator(LocalizedString.class, (BeanDecorator)localizedStringDecorator);
        SimpleBeanDecorator portletDecorator = new SimpleBeanDecorator();
        portletDecorator.setProperty((Object)"name", (PropertyDecorator)new AbstractPropertyDecorator(String.class){

            public Object getValue(Object bean) throws IllegalArgumentException {
                Portlet portlet = (Portlet)bean;
                String displayName = AdminPropertyResolver.this.getValueForRequestLocale(portlet.getInfo().getMeta().getMetaValue("display-name"));
                return displayName != null ? displayName : portlet.getContext().getId();
            }
        });
        portletDecorator.setProperty((Object)"description", (PropertyDecorator)new AbstractPropertyDecorator(LocalizedString.class){

            public Object getValue(Object bean) throws IllegalArgumentException {
                Portlet portlet = (Portlet)bean;
                return portlet.getInfo().getMeta().getMetaValue("description");
            }
        });
        portletDecorator.setProperty((Object)"keywords", (PropertyDecorator)new AbstractPropertyDecorator(LocalizedString.class){

            public Object getValue(Object bean) throws IllegalArgumentException {
                Portlet portlet = (Portlet)bean;
                return portlet.getInfo().getMeta().getMetaValue("keywords");
            }
        });
        portletDecorator.setProperty((Object)"title", (PropertyDecorator)new AbstractPropertyDecorator(LocalizedString.class){

            public Object getValue(Object bean) throws IllegalArgumentException {
                Portlet portlet = (Portlet)bean;
                return portlet.getInfo().getMeta().getMetaValue("title");
            }
        });
        portletDecorator.setProperty((Object)"remotable", (PropertyDecorator)new AbstractPropertyDecorator(Boolean.class){

            public Object getValue(Object bean) throws IllegalArgumentException {
                Portlet portlet = (Portlet)bean;
                PortletInfo info = portlet.getInfo();
                if (info.getAttachment(WSRPInfo.class) != null) {
                    return ((WSRPInfo)info.getAttachment(WSRPInfo.class)).isRemotable();
                }
                return Boolean.FALSE;
            }
        });
        portletDecorator.setProperty((Object)"modes", (PropertyDecorator)new AbstractPropertyDecorator(List.class){

            public Object getValue(Object bean) throws IllegalArgumentException {
                Portlet portlet = (Portlet)bean;
                Set set = portlet.getInfo().getCapabilities().getAllModes();
                return Tools.toList(set.iterator());
            }
        });
        portletDecorator.setProperty((Object)"windowStates", (PropertyDecorator)new AbstractPropertyDecorator(List.class){

            public Object getValue(Object bean) throws IllegalArgumentException {
                Portlet portlet = (Portlet)bean;
                Set set = portlet.getInfo().getCapabilities().getWindowStates(MediaType.TEXT_HTML);
                return Tools.toList(set.iterator());
            }
        });
        portletDecorator.setProperty((Object)"mediaTypes", (PropertyDecorator)new AbstractPropertyDecorator(List.class){

            public Object getValue(Object bean) throws IllegalArgumentException {
                Portlet portlet = (Portlet)bean;
                Set set = portlet.getInfo().getCapabilities().getMediaTypes();
                return Tools.toList(set.iterator());
            }
        });
        portletDecorator.setProperty((Object)"locales", (PropertyDecorator)new AbstractPropertyDecorator(List.class){

            public Object getValue(Object bean) throws IllegalArgumentException {
                Portlet portlet = (Portlet)bean;
                Set locales = portlet.getInfo().getCapabilities().getAllLocales();
                if (locales != null) {
                    return new ArrayList(locales);
                }
                return Collections.emptyList();
            }
        });
        portletDecorator.setProperty((Object)"transportGuarantees", (PropertyDecorator)new AbstractPropertyDecorator(List.class){

            public Object getValue(Object bean) throws IllegalArgumentException {
                Portlet portlet = (Portlet)bean;
                Set tg = portlet.getInfo().getSecurity().getTransportGuarantees();
                if (tg != null) {
                    return new ArrayList(tg);
                }
                return Collections.emptyList();
            }
        });
        portletDecorator.setProperty((Object)"preferenceKeys", (PropertyDecorator)new AbstractPropertyDecorator(List.class){

            public Object getValue(Object bean) throws IllegalArgumentException {
                Portlet portlet = (Portlet)bean;
                Set pk = portlet.getInfo().getPreferences().getKeys();
                if (pk != null) {
                    return new ArrayList(pk);
                }
                return Collections.emptyList();
            }
        });
        portletDecorator.setProperty((Object)"publicParameters", (PropertyDecorator)new AbstractPropertyDecorator(List.class){

            public Object getValue(Object bean) throws IllegalArgumentException {
                Portlet portlet = (Portlet)bean;
                NavigationInfo navigationInfo = portlet.getInfo().getNavigation();
                if (navigationInfo == null) {
                    return Collections.emptyList();
                }
                Collection pp = navigationInfo.getPublicParameters();
                if (pp != null) {
                    return new ArrayList(pp);
                }
                return Collections.emptyList();
            }
        });
        portletDecorator.setProperty((Object)"consumedEvents", (PropertyDecorator)new AbstractPropertyDecorator(List.class){

            public Object getValue(Object bean) throws IllegalArgumentException {
                Portlet portlet = (Portlet)bean;
                Map ce = portlet.getInfo().getEventing().getConsumedEvents();
                if (ce != null) {
                    return new ArrayList(ce.values());
                }
                return Collections.emptyList();
            }
        });
        portletDecorator.setProperty((Object)"producedEvents", (PropertyDecorator)new AbstractPropertyDecorator(List.class){

            public Object getValue(Object bean) throws IllegalArgumentException {
                Portlet portlet = (Portlet)bean;
                Map pe = portlet.getInfo().getEventing().getProducedEvents();
                if (pe != null) {
                    return new ArrayList(pe.values());
                }
                return Collections.emptyList();
            }
        });
        portletDecorator.setProperty((Object)"smallIconLocation", (PropertyDecorator)new PortletIconPropertyDecorator("small"));
        portletDecorator.setProperty((Object)"largeIconLocation", (PropertyDecorator)new PortletIconPropertyDecorator("large"));
        this.registerDecorator(Portlet.class, (BeanDecorator)portletDecorator);
        SimpleBeanDecorator instanceDecorator = new SimpleBeanDecorator();
        instanceDecorator.setProperty((Object)"portlet", (PropertyDecorator)new AbstractPropertyDecorator(Portlet.class){

            public Object getValue(Object bean) {
                Instance instance = (Instance)bean;
                try {
                    return instance.getPortlet();
                }
                catch (PortletInvokerException e) {
                    return null;
                }
            }
        });
        instanceDecorator.setProperty((Object)"displayName", (PropertyDecorator)new InstanceDisplayNamePropertyDecorator());
        this.registerDecorator(Instance.class, (BeanDecorator)instanceDecorator);
        SimpleBeanDecorator portalObjectDecorator = new SimpleBeanDecorator(){
            {
                this.setProperty("portals", (PropertyDecorator)new AbstractPropertyDecorator(List.class){

                    public Object getValue(Object bean) {
                        PortalObject object = (PortalObject)bean;
                        PortalObjectId id = object.getId();
                        if ("dashboard".equals(id.getNamespace())) {
                            return Collections.EMPTY_LIST;
                        }
                        return this.getChildren(object, 2);
                    }
                });
                this.setProperty("pages", (PropertyDecorator)new AbstractPropertyDecorator(List.class){

                    public Object getValue(Object bean) {
                        PortalObject object = (PortalObject)bean;
                        return this.getChildren(object, 4);
                    }
                });
                this.setProperty("windows", (PropertyDecorator)new AbstractPropertyDecorator(List.class){

                    public Object getValue(Object bean) {
                        PortalObject object = (PortalObject)bean;
                        return this.getChildren(object, 8);
                    }
                });
                this.setProperty("maximizedStateExists", (PropertyDecorator)new AbstractPropertyDecorator(Boolean.class){

                    public Object getValue(Object bean) {
                        PortalObject object = (PortalObject)bean;
                        ArrayList children = new ArrayList(this.getChildren(object, 8));
                        IteratorStatus i = new IteratorStatus(children.iterator());
                        while (i.hasNext()) {
                            PortalObject portalObject = (PortalObject)i.next();
                            if (!portalObject.getDeclaredProperties().containsValue("MAXIMIZED")) continue;
                            return Boolean.TRUE;
                        }
                        return Boolean.FALSE;
                    }
                });
            }

            private List getChildren(PortalObject object, int mask) {
                return new ArrayList(object.getChildren(mask));
            }
        };
        portalObjectDecorator.setProperty((Object)"id", (PropertyDecorator)new AbstractPropertyDecorator(String.class){

            public Object getValue(Object bean) {
                PortalObject object = (PortalObject)bean;
                PortalObjectId id = object.getId();
                return id.toString(PortalObjectPath.LEGACY_BASE64_FORMAT);
            }
        });
        portalObjectDecorator.setProperty((Object)"default", (PropertyDecorator)new AbstractPropertyDecorator(Boolean.class){

            public Object getValue(Object bean) {
                PortalObject object = (PortalObject)bean;
                PortalObject portalObject = object.getParent();
                if (portalObject == null) {
                    portalObject = object;
                }
                return object.getName().equals(portalObject.getDeclaredProperty("portal.defaultObjectName"));
            }
        });
        portalObjectDecorator.setProperty((Object)"typeName", (PropertyDecorator)new AbstractPropertyDecorator(String.class){

            public Object getValue(Object bean) {
                PortalObject object = (PortalObject)bean;
                if (object != null) {
                    switch (object.getType()) {
                        case 0: {
                            return "context";
                        }
                        case 1: {
                            return "portal";
                        }
                        case 2: {
                            return "page";
                        }
                        case 3: {
                            return "window";
                        }
                    }
                }
                return "none";
            }
        });
        this.registerDecorator(PortalObject.class, (BeanDecorator)portalObjectDecorator);
        this.registerDecorator(ContentProviderRegistryService.class, (BeanDecorator)new AbstractBeanDecorator(){

            protected PropertyDecorator getProperty(Object propertyName) {
                ContentType contentType = ContentType.create((String)((String)propertyName));
                final String instanceName = ContentProviderRegistryService.getInstance().getContentProvider(contentType).getPortletInfo().getPortletName(ContentPortlet.EDIT_CONTENT_MODE);
                return instanceName == null ? null : new AbstractPropertyDecorator(String.class){

                    public Object getValue(Object bean) throws IllegalArgumentException {
                        return instanceName;
                    }
                };
            }
        });
        this.registerDecorator(AuthorizationDomainRegistry.class, (BeanDecorator)new AbstractBeanDecorator(){

            protected PropertyDecorator getProperty(final Object propertyName) {
                return new AbstractPropertyDecorator(AuthorizationDomain.class){

                    public Object getValue(Object bean) throws IllegalArgumentException {
                        return ((AuthorizationDomainRegistry)bean).getDomain((String)propertyName);
                    }
                };
            }
        });
        SimpleBeanDecorator layoutServiceDecorator = new SimpleBeanDecorator();
        layoutServiceDecorator.setProperty((Object)"layoutItems", (PropertyDecorator)new AbstractPropertyDecorator(SelectItem[].class){

            public Object getValue(Object bean) throws IllegalArgumentException {
                LayoutService layoutService = (LayoutService)bean;
                Collection layouts = layoutService.getLayouts();
                SelectItem[] items = new SelectItem[layouts.size() + 1];
                IteratorStatus i = new IteratorStatus(layouts.iterator());
                while (i.hasNext()) {
                    PortalLayout layout = (PortalLayout)i.next();
                    SelectItem item = new SelectItem();
                    String layoutName = layout.getLayoutInfo().getName();
                    item.setValue((Object)layoutName);
                    item.setLabel(layoutName);
                    items[i.getIndex()] = item;
                }
                items[items.length - 1] = new SelectItem((Object)"", "default");
                return items;
            }
        });
        layoutServiceDecorator.setProperty((Object)"renderSetItems", (PropertyDecorator)new AbstractPropertyDecorator(SelectItem[].class){

            public Object getValue(Object bean) throws IllegalArgumentException {
                LayoutService layoutService = (LayoutService)bean;
                Collection renderSets = layoutService.getRenderSets();
                HashMap<String, String> names = new HashMap<String, String>();
                for (ServerRegistrationID renderSetId : renderSets) {
                    PortalRenderSet renderSet = layoutService.getRenderSet(renderSetId, MediaType.TEXT_HTML);
                    if (renderSet == null) continue;
                    names.put(renderSet.getName(), renderSet.getName());
                }
                SelectItem[] items = new SelectItem[names.size() + 1];
                IteratorStatus i = new IteratorStatus(names.keySet().iterator());
                while (i.hasNext()) {
                    String key = (String)i.next();
                    items[i.getIndex()] = new SelectItem((Object)key, (String)names.get(key));
                }
                items[items.length - 1] = new SelectItem((Object)"", "default");
                return items;
            }
        });
        this.registerDecorator(LayoutService.class, (BeanDecorator)layoutServiceDecorator);
        SimpleBeanDecorator themeServiceDecorator = new SimpleBeanDecorator();
        themeServiceDecorator.setProperty((Object)"themeItems", (PropertyDecorator)new AbstractPropertyDecorator(SelectItem[].class){

            public Object getValue(Object bean) throws IllegalArgumentException {
                ThemeService layoutService = (ThemeService)bean;
                Collection themes = layoutService.getThemes();
                SelectItem[] items = new SelectItem[themes.size() + 1];
                IteratorStatus i = new IteratorStatus(themes.iterator());
                while (i.hasNext()) {
                    PortalTheme name = (PortalTheme)i.next();
                    SelectItem item = new SelectItem();
                    String themeName = name.getThemeInfo().getName();
                    item.setValue((Object)themeName);
                    item.setLabel(themeName);
                    items[i.getIndex()] = item;
                }
                items[items.length - 1] = new SelectItem((Object)"", "default");
                return items;
            }
        });
        this.registerDecorator(ThemeService.class, (BeanDecorator)themeServiceDecorator);
    }

    private String getValueForRequestLocale(LocalizedString string) {
        if (string != null) {
            FacesContext ctx = FacesContext.getCurrentInstance();
            Locale locale = ctx.getExternalContext().getRequestLocale();
            return string.getString(locale, true);
        }
        return null;
    }

    private class InstanceDisplayNamePropertyDecorator
    extends AbstractPropertyDecorator {
        public InstanceDisplayNamePropertyDecorator() {
            super(String.class);
        }

        public Object getValue(Object bean) throws IllegalArgumentException {
            Instance instance = (Instance)bean;
            String displayName = AdminPropertyResolver.this.getValueForRequestLocale(instance.getDisplayName());
            if (displayName == null) {
                displayName = instance.getId();
            }
            return displayName;
        }
    }

    private static class PortletIconPropertyDecorator
    extends AbstractPropertyDecorator {
        private String iconType;

        public PortletIconPropertyDecorator(String iconType) {
            super(String.class);
            this.iconType = iconType;
        }

        public Object getValue(Object bean) throws IllegalArgumentException {
            Portlet portlet = (Portlet)bean;
            PortletInfo info = portlet.getInfo();
            PortletInfoInfo portletInfo = (PortletInfoInfo)info.getAttachment(PortletInfoInfo.class);
            if (portletInfo != null && portletInfo != null && portletInfo.getPortletIconInfo() != null && portletInfo.getPortletIconInfo().getIconLocation(this.iconType) != null) {
                return portletInfo.getPortletIconInfo().getIconLocation(this.iconType);
            }
            return "/portal-core/images/portletIcon_Default1.gif";
        }
    }
}

