/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.admin.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.SelectItem;
import org.jboss.portal.core.admin.ui.PortalObjectManagerBean;
import org.jboss.portal.core.admin.ui.PropertiesInfo;
import org.jboss.portal.core.admin.ui.PropertyBean;
import org.jboss.portal.core.admin.ui.PropertyBeanContainer;
import org.jboss.portal.core.admin.ui.PropertyInfo;
import org.jboss.portal.core.admin.ui.actions.PropertyAction;
import org.jboss.portal.core.model.portal.PortalObject;

public class PropertiesBean
extends PropertyBeanContainer {
    private final SortedMap entryMap;
    private final PortalObjectManagerBean pomgr;
    private final PropertiesInfo info;
    private int selectedIndex;
    private List items;
    private String propertyActionRef;

    public PropertiesBean(PortalObjectManagerBean pomgr) {
        PortalObject selectedObject = pomgr.getSelectedObject();
        PropertiesInfo info = new PropertiesInfo(selectedObject);
        TreeMap<String, PropertyBean> entryMap = new TreeMap<String, PropertyBean>();
        boolean inheritable = selectedObject.getType() != 0;
        for (String propertyName : selectedObject.getProperties().keySet()) {
            boolean inherited;
            String propertyValue = selectedObject.getProperty(propertyName);
            PropertyInfo propertyInfo = info.getPropertyInfo(propertyName);
            boolean bl = inherited = !selectedObject.getDeclaredProperties().containsKey(propertyName);
            if (propertyInfo == null || propertyInfo.getScope() != 0) continue;
            PropertyBean propertyBean = new PropertyBean(this, propertyInfo, inherited, inheritable, propertyValue);
            entryMap.put(propertyName, propertyBean);
        }
        this.info = info;
        this.pomgr = pomgr;
        this.entryMap = entryMap;
        this.selectedIndex = -1;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int selectedIndex) {
        if (selectedIndex < 0 || selectedIndex >= this.entryMap.size()) {
            throw new IllegalArgumentException();
        }
        this.selectedIndex = selectedIndex;
    }

    public void unselectEntry() {
        this.selectedIndex = -1;
    }

    public DataModel getEntries() {
        return new ListDataModel(new ArrayList(this.entryMap.values()));
    }

    public int getSize() {
        return this.entryMap.size();
    }

    public SelectItem[] getPropertyItems() {
        if (this.items == null) {
            this.items = new ArrayList();
            for (String propertyName : this.info.getNames()) {
                PropertyInfo propertyInfo;
                if (this.entryMap.containsKey(propertyName) || (propertyInfo = this.info.getPropertyInfo(propertyName)).getScope() != 0 || propertyInfo.getAccessMode() != 1 || PropertiesInfo.isControlProperty(propertyName)) continue;
                Locale locale = FacesContext.getCurrentInstance().getExternalContext().getRequestLocale();
                this.items.add(new SelectItem((Object)propertyInfo.getName(), propertyInfo.getDisplayName().getString(locale, true), propertyInfo.getDescription().getDefaultString()));
            }
        }
        return this.items.toArray(new SelectItem[this.items.size()]);
    }

    public PortalObject getRelatedObject() {
        return this.pomgr.getSelectedObject();
    }

    public PropertyAction getAction() {
        return this.pomgr.propertyAction;
    }
}

