/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.admin.ui;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.portal.common.i18n.LocalizedString;
import org.jboss.portal.core.admin.ui.PropertiesInfoBuilder;
import org.jboss.portal.core.admin.ui.PropertyInfo;
import org.jboss.portal.core.model.portal.PortalObject;

public class PropertiesInfo {
    public static final PropertyInfo THEME_LAYOUT_ID = PropertiesInfoBuilder.getPropertiesInfo().get("layout.id");
    public static final PropertyInfo THEME_THEME_ID = PropertiesInfoBuilder.getPropertiesInfo().get("theme.id");
    public static final PropertyInfo THEME_RENDER_SET_ID = PropertiesInfoBuilder.getPropertiesInfo().get("theme.renderSetId");
    public static final PropertyInfo THEME_RENDER_REGION_ID = PropertiesInfoBuilder.getPropertiesInfo().get("theme.region");
    public static final PropertyInfo THEME_RENDER_REGION_ORDER = PropertiesInfoBuilder.getPropertiesInfo().get("theme.order");
    public static final PropertyInfo AJAX_PARTIAL_REFRESH = PropertiesInfoBuilder.getPropertiesInfo().get("theme.dyna.partial_refresh_enabled");
    public static final PropertyInfo AJAX_DND = PropertiesInfoBuilder.getPropertiesInfo().get("theme.dyna.dnd_enabled");
    public static final PropertyInfo WINDOW_CONTENT_TYPE = PropertiesInfoBuilder.getPropertiesInfo().get("portal.windowContentType");
    public static final PropertyInfo DEFAULT_CHILD_NAME = PropertiesInfoBuilder.getPropertiesInfo().get("portal.defaultObjectName");
    public static final PropertyInfo PAGE_ORDER = PropertiesInfoBuilder.getPropertiesInfo().get("order");
    public static final PropertyInfo INITIAL_WINDOW_STATE = PropertiesInfoBuilder.getPropertiesInfo().get("portal.windowInitialState");
    public static final PropertyInfo CONTROL_POLICY_PAGE_ACCESS_DENIED = PropertiesInfoBuilder.getPropertiesInfo().get("control.page.access_denied");
    public static final PropertyInfo CONTROL_POLICY_PAGE_UNAVAILABLE = PropertiesInfoBuilder.getPropertiesInfo().get("control.page.unavailable");
    public static final PropertyInfo CONTROL_POLICY_PAGE_ERROR = PropertiesInfoBuilder.getPropertiesInfo().get("control.page.error");
    public static final PropertyInfo CONTROL_POLICY_PAGE_INTERNAL_ERROR = PropertiesInfoBuilder.getPropertiesInfo().get("control.page.internal_error");
    public static final PropertyInfo CONTROL_POLICY_PAGE_NOT_FOUND = PropertiesInfoBuilder.getPropertiesInfo().get("control.page.not_found");
    public static final PropertyInfo CONTROL_POLICY_PAGE_RESOURCE_URI = PropertiesInfoBuilder.getPropertiesInfo().get("control.page.resource_uri");
    public static final PropertyInfo CONTROL_POLICY_PORTAL_ACCESS_DENIED = PropertiesInfoBuilder.getPropertiesInfo().get("control.portal.access_denied");
    public static final PropertyInfo CONTROL_POLICY_PORTAL_UNAVAILABLE = PropertiesInfoBuilder.getPropertiesInfo().get("control.portal.unavailable");
    public static final PropertyInfo CONTROL_POLICY_PORTAL_ERROR = PropertiesInfoBuilder.getPropertiesInfo().get("control.portal.error");
    public static final PropertyInfo CONTROL_POLICY_PORTAL_INTERNAL_ERROR = PropertiesInfoBuilder.getPropertiesInfo().get("control.portal.internal_error");
    public static final PropertyInfo CONTROL_POLICY_PORTAL_NOT_FOUND = PropertiesInfoBuilder.getPropertiesInfo().get("control.portal.not_found");
    public static final PropertyInfo CONTROL_POLICY_PORTAL_RESOURCE_URI = PropertiesInfoBuilder.getPropertiesInfo().get("control.portal.resource_uri");
    private static final PropertyInfoSet CONTEXT_PROPERTIES = new PropertyInfoSet();
    private static final PropertyInfoSet PORTAL_PROPERTIES = new PropertyInfoSet();
    private static final PropertyInfoSet PAGE_PROPERTIES = new PropertyInfoSet();
    private static final PropertyInfoSet WINDOW_PROPERTIES = new PropertyInfoSet();
    private static final PropertyInfoSet CONTROL_PROPERTIES = new PropertyInfoSet();
    private static final PropertyInfoSet CONTROL_PAGE_PROPERTIES = new PropertyInfoSet();
    private static final PropertyInfoSet CONTROL_PORTAL_PROPERTIES = new PropertyInfoSet();
    private static final PropertyInfoSet ALL_PROPERTIES = new PropertyInfoSet();
    private Map entries;

    public PropertiesInfo(PortalObject portalObject) {
        PropertyInfoSet objectProps = null;
        switch (portalObject.getType()) {
            case 0: {
                objectProps = CONTEXT_PROPERTIES;
                break;
            }
            case 1: {
                objectProps = PORTAL_PROPERTIES;
                break;
            }
            case 2: {
                objectProps = PAGE_PROPERTIES;
                break;
            }
            case 3: {
                objectProps = WINDOW_PROPERTIES;
            }
        }
        HashMap<String, PropertyInfo> entries = new HashMap<String, PropertyInfo>(objectProps);
        for (Map.Entry entry : portalObject.getDeclaredProperties().entrySet()) {
            String name = (String)entry.getKey();
            if (ALL_PROPERTIES.containsKey(name)) continue;
            LocalizedString displayName = new LocalizedString(name);
            PropertyInfo info = new PropertyInfo(name, displayName, new LocalizedString("The " + name + " property"), "java.lang.String", 1, 0);
            entries.put(name, info);
        }
        this.entries = entries;
    }

    public Set getNames() {
        return this.entries.keySet();
    }

    public PropertyInfo getPropertyInfo(String name) {
        return (PropertyInfo)this.entries.get(name);
    }

    public static boolean isControlProperty(String name) {
        return CONTROL_PROPERTIES.containsKey(name);
    }

    public static PropertyInfo getControlPropertyInfo(String name) {
        return (PropertyInfo)CONTROL_PROPERTIES.get(name);
    }

    static {
        CONTEXT_PROPERTIES.add(AJAX_PARTIAL_REFRESH);
        CONTEXT_PROPERTIES.add(AJAX_DND);
        CONTEXT_PROPERTIES.add(CONTROL_POLICY_PORTAL_ACCESS_DENIED);
        CONTEXT_PROPERTIES.add(CONTROL_POLICY_PORTAL_UNAVAILABLE);
        CONTEXT_PROPERTIES.add(CONTROL_POLICY_PORTAL_ERROR);
        CONTEXT_PROPERTIES.add(CONTROL_POLICY_PORTAL_INTERNAL_ERROR);
        CONTEXT_PROPERTIES.add(CONTROL_POLICY_PORTAL_NOT_FOUND);
        CONTEXT_PROPERTIES.add(CONTROL_POLICY_PORTAL_RESOURCE_URI);
        CONTEXT_PROPERTIES.add(CONTROL_POLICY_PAGE_ACCESS_DENIED);
        CONTEXT_PROPERTIES.add(CONTROL_POLICY_PAGE_UNAVAILABLE);
        CONTEXT_PROPERTIES.add(CONTROL_POLICY_PAGE_ERROR);
        CONTEXT_PROPERTIES.add(CONTROL_POLICY_PAGE_INTERNAL_ERROR);
        CONTEXT_PROPERTIES.add(CONTROL_POLICY_PAGE_NOT_FOUND);
        CONTEXT_PROPERTIES.add(CONTROL_POLICY_PAGE_RESOURCE_URI);
        PORTAL_PROPERTIES.add(THEME_LAYOUT_ID);
        PORTAL_PROPERTIES.add(THEME_THEME_ID);
        PORTAL_PROPERTIES.add(THEME_RENDER_SET_ID);
        PORTAL_PROPERTIES.add(DEFAULT_CHILD_NAME);
        PORTAL_PROPERTIES.add(AJAX_PARTIAL_REFRESH);
        PORTAL_PROPERTIES.add(CONTROL_POLICY_PORTAL_ACCESS_DENIED);
        PORTAL_PROPERTIES.add(CONTROL_POLICY_PORTAL_UNAVAILABLE);
        PORTAL_PROPERTIES.add(CONTROL_POLICY_PORTAL_ERROR);
        PORTAL_PROPERTIES.add(CONTROL_POLICY_PORTAL_INTERNAL_ERROR);
        PORTAL_PROPERTIES.add(CONTROL_POLICY_PORTAL_NOT_FOUND);
        PORTAL_PROPERTIES.add(CONTROL_POLICY_PORTAL_RESOURCE_URI);
        PORTAL_PROPERTIES.add(CONTROL_POLICY_PAGE_ACCESS_DENIED);
        PORTAL_PROPERTIES.add(CONTROL_POLICY_PAGE_UNAVAILABLE);
        PORTAL_PROPERTIES.add(CONTROL_POLICY_PAGE_ERROR);
        PORTAL_PROPERTIES.add(CONTROL_POLICY_PAGE_INTERNAL_ERROR);
        PORTAL_PROPERTIES.add(CONTROL_POLICY_PAGE_NOT_FOUND);
        PORTAL_PROPERTIES.add(CONTROL_POLICY_PAGE_RESOURCE_URI);
        PAGE_PROPERTIES.add(THEME_LAYOUT_ID);
        PAGE_PROPERTIES.add(THEME_THEME_ID);
        PAGE_PROPERTIES.add(THEME_RENDER_SET_ID);
        PAGE_PROPERTIES.add(DEFAULT_CHILD_NAME);
        PAGE_PROPERTIES.add(PAGE_ORDER);
        PAGE_PROPERTIES.add(AJAX_PARTIAL_REFRESH);
        PAGE_PROPERTIES.add(CONTROL_POLICY_PAGE_ACCESS_DENIED);
        PAGE_PROPERTIES.add(CONTROL_POLICY_PAGE_UNAVAILABLE);
        PAGE_PROPERTIES.add(CONTROL_POLICY_PAGE_ERROR);
        PAGE_PROPERTIES.add(CONTROL_POLICY_PAGE_INTERNAL_ERROR);
        PAGE_PROPERTIES.add(CONTROL_POLICY_PAGE_NOT_FOUND);
        PAGE_PROPERTIES.add(CONTROL_POLICY_PAGE_RESOURCE_URI);
        WINDOW_PROPERTIES.add(AJAX_PARTIAL_REFRESH);
        WINDOW_PROPERTIES.add(THEME_RENDER_REGION_ID);
        WINDOW_PROPERTIES.add(THEME_RENDER_REGION_ORDER);
        WINDOW_PROPERTIES.add(WINDOW_CONTENT_TYPE);
        WINDOW_PROPERTIES.add(INITIAL_WINDOW_STATE);
        CONTROL_PAGE_PROPERTIES.add(CONTROL_POLICY_PAGE_ACCESS_DENIED);
        CONTROL_PAGE_PROPERTIES.add(CONTROL_POLICY_PAGE_ERROR);
        CONTROL_PAGE_PROPERTIES.add(CONTROL_POLICY_PAGE_INTERNAL_ERROR);
        CONTROL_PAGE_PROPERTIES.add(CONTROL_POLICY_PAGE_NOT_FOUND);
        CONTROL_PAGE_PROPERTIES.add(CONTROL_POLICY_PAGE_UNAVAILABLE);
        CONTROL_PAGE_PROPERTIES.add(CONTROL_POLICY_PAGE_RESOURCE_URI);
        CONTROL_PORTAL_PROPERTIES.add(CONTROL_POLICY_PORTAL_ACCESS_DENIED);
        CONTROL_PORTAL_PROPERTIES.add(CONTROL_POLICY_PORTAL_ERROR);
        CONTROL_PORTAL_PROPERTIES.add(CONTROL_POLICY_PORTAL_INTERNAL_ERROR);
        CONTROL_PORTAL_PROPERTIES.add(CONTROL_POLICY_PORTAL_NOT_FOUND);
        CONTROL_PORTAL_PROPERTIES.add(CONTROL_POLICY_PORTAL_UNAVAILABLE);
        CONTROL_PORTAL_PROPERTIES.add(CONTROL_POLICY_PORTAL_RESOURCE_URI);
        CONTROL_PROPERTIES.putAll(CONTROL_PORTAL_PROPERTIES);
        CONTROL_PROPERTIES.putAll(CONTROL_PAGE_PROPERTIES);
        ALL_PROPERTIES.putAll(CONTEXT_PROPERTIES);
        ALL_PROPERTIES.putAll(PORTAL_PROPERTIES);
        ALL_PROPERTIES.putAll(PAGE_PROPERTIES);
        ALL_PROPERTIES.putAll(WINDOW_PROPERTIES);
    }

    private static class PropertyInfoSet
    extends HashMap {
        private PropertyInfoSet() {
        }

        public void add(PropertyInfo propertyInfo) {
            this.put(propertyInfo.getName(), propertyInfo);
        }
    }
}

