/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.invocation;

import java.util.HashMap;
import java.util.Map;
import org.jboss.portal.common.invocation.AttributeResolver;
import org.jboss.portal.common.invocation.InvocationContext;
import org.jboss.portal.common.invocation.Scope;

public class AbstractInvocationContext
implements InvocationContext {
    private final Map resolvers = new HashMap();

    protected final void addResolver(Scope resolverScope, InvocationContext federatedContext) throws IllegalArgumentException {
        if (resolverScope == null) {
            throw new IllegalArgumentException();
        }
        if (federatedContext == null) {
            throw new IllegalArgumentException();
        }
        this.resolvers.put(resolverScope, new InvocationContextRegistration(federatedContext));
    }

    protected final void addResolver(Scope resolverScope, AttributeResolver resolver) throws IllegalArgumentException {
        if (resolverScope == null) {
            throw new IllegalArgumentException();
        }
        if (resolver == null) {
            throw new IllegalArgumentException();
        }
        this.resolvers.put(resolverScope, new AttributeResolverRegistration(resolver));
    }

    public AttributeResolver getAttributeResolver(Scope attrScope) throws IllegalArgumentException {
        if (attrScope == null) {
            throw new IllegalArgumentException("Attribute name must not be null");
        }
        AttributeResolver resolver = null;
        Registration registration = (Registration)this.resolvers.get(attrScope);
        if (registration instanceof AttributeResolverRegistration) {
            resolver = ((AttributeResolverRegistration)registration).resolver;
        } else if (registration instanceof InvocationContextRegistration) {
            InvocationContext federaredContext = ((InvocationContextRegistration)registration).context;
            resolver = federaredContext.getAttributeResolver(attrScope);
        } else {
            throw new IllegalArgumentException("Scope not recognized " + attrScope);
        }
        return resolver;
    }

    public Object getAttribute(Scope attrScope, Object attrKey) throws IllegalArgumentException {
        if (attrKey == null) {
            throw new IllegalArgumentException("Attribute name must not be null");
        }
        if (attrScope == null) {
            throw new IllegalArgumentException("Attribute scope must not be null");
        }
        AttributeResolver resolver = this.getAttributeResolver(attrScope);
        if (resolver == null) {
            throw new IllegalArgumentException("Scope not recognized " + attrScope);
        }
        return resolver.getAttribute(attrKey);
    }

    public void setAttribute(Scope attrScope, Object attrKey, Object attrValue) throws IllegalArgumentException {
        if (attrKey == null) {
            throw new IllegalArgumentException("Attribute name must not be null");
        }
        if (attrScope == null) {
            throw new IllegalArgumentException("Attribute scope must not be null");
        }
        AttributeResolver resolver = this.getAttributeResolver(attrScope);
        if (resolver == null) {
            throw new IllegalArgumentException("Scope not recognized " + attrScope);
        }
        resolver.setAttribute(attrKey, attrValue);
    }

    public void removeAttribute(Scope attrScope, Object attrKey) {
        this.setAttribute(attrScope, attrKey, null);
    }

    private static final class InvocationContextRegistration
    extends Registration {
        private final InvocationContext context;

        private InvocationContextRegistration(InvocationContext context) {
            this.context = context;
        }
    }

    private static final class AttributeResolverRegistration
    extends Registration {
        private final AttributeResolver resolver;

        private AttributeResolverRegistration(AttributeResolver resolver) {
            this.resolver = resolver;
        }
    }

    private static abstract class Registration {
        private Registration() {
        }
    }
}

