/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionBuilder<C extends Collection<V>, V> {
    private C collection;

    private CollectionBuilder(C collection) {
        this.collection = collection;
    }

    public static <C extends Collection<V>, V> CollectionBuilder<C, V> create(C collection) {
        return new CollectionBuilder<C, V>(collection);
    }

    public static <V> CollectionBuilder<ArrayList<V>, V> arrayList() {
        return new CollectionBuilder(new ArrayList());
    }

    public static <V> CollectionBuilder<ArrayList<V>, V> arrayList(V v) {
        CollectionBuilder builder = new CollectionBuilder(new ArrayList());
        builder.add(v);
        return builder;
    }

    public static <V> CollectionBuilder<LinkedList<V>, V> linkedList() {
        return new CollectionBuilder(new LinkedList());
    }

    public static <V> CollectionBuilder<LinkedList<V>, V> linkedList(V v) {
        CollectionBuilder builder = new CollectionBuilder(new LinkedList());
        builder.add(v);
        return builder;
    }

    public static <V> CollectionBuilder<HashSet<V>, V> hashSet() {
        return new CollectionBuilder(new HashSet());
    }

    public static <V> CollectionBuilder<HashSet<V>, V> hashSet(V v) {
        CollectionBuilder builder = new CollectionBuilder(new HashSet());
        builder.add(v);
        return builder;
    }

    public CollectionBuilder<C, V> add(V o) {
        this.collection.add(o);
        return this;
    }

    public CollectionBuilder<C, V> addAll(Collection<V> all) {
        this.collection.addAll(all);
        return this;
    }

    public C get() {
        return this.collection;
    }
}

