/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.portal.common.util.MapAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyMap<K, V>
implements Map<K, V> {
    private MapAccessor<K, V> delegate;
    private boolean modified;

    public LazyMap(MapAccessor<K, V> delegate) throws IllegalArgumentException {
        if (delegate == null) {
            throw new IllegalArgumentException("No null delegate can be accepted");
        }
        this.delegate = delegate;
    }

    public boolean isModified() {
        return this.modified;
    }

    private Map<K, V> getDelegate(boolean wantWrite) {
        return this.delegate.getMap(wantWrite);
    }

    @Override
    public int size() {
        return this.getDelegate(false).size();
    }

    @Override
    public boolean isEmpty() {
        return this.getDelegate(false).isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getDelegate(false).containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getDelegate(false).containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.getDelegate(false).get(key);
    }

    @Override
    public V put(K key, V value) {
        this.modified = true;
        return this.getDelegate(true).put(key, value);
    }

    @Override
    public V remove(Object key) {
        this.modified = true;
        return this.getDelegate(true).remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        this.modified = true;
        this.getDelegate(true).putAll(t);
    }

    @Override
    public void clear() {
        this.modified = true;
        this.getDelegate(true).clear();
    }

    @Override
    public Set<K> keySet() {
        return new Set<K>(){
            Set<K> keySet;
            {
                this.keySet = LazyMap.this.getDelegate(true).keySet();
            }

            @Override
            public int size() {
                return this.keySet.size();
            }

            @Override
            public boolean isEmpty() {
                return this.keySet.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return this.keySet.contains(o);
            }

            @Override
            public Iterator<K> iterator() {
                return this.keySet.iterator();
            }

            @Override
            public Object[] toArray() {
                return this.keySet.toArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                return this.keySet.toArray(a);
            }

            @Override
            public boolean add(K o) {
                LazyMap.this.modified = true;
                return this.keySet.add(o);
            }

            @Override
            public boolean remove(Object o) {
                LazyMap.this.modified = true;
                return this.keySet.remove(o);
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                return this.keySet.containsAll(c);
            }

            @Override
            public boolean addAll(Collection<? extends K> c) {
                LazyMap.this.modified = true;
                return this.keySet.addAll(c);
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                return this.keySet.retainAll(c);
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                LazyMap.this.modified = true;
                return this.keySet.removeAll(c);
            }

            @Override
            public void clear() {
                LazyMap.this.modified = true;
                this.keySet.clear();
            }

            @Override
            public boolean equals(Object o) {
                return ((Object)this.keySet).equals(o);
            }

            @Override
            public int hashCode() {
                return ((Object)this.keySet).hashCode();
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new Collection<V>(){
            Collection<V> values;
            {
                this.values = LazyMap.this.getDelegate(true).values();
            }

            @Override
            public int size() {
                return this.values.size();
            }

            @Override
            public boolean isEmpty() {
                return this.values.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return this.values.contains(o);
            }

            @Override
            public Iterator<V> iterator() {
                return this.values.iterator();
            }

            @Override
            public Object[] toArray() {
                return this.values.toArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                return this.values.toArray(a);
            }

            @Override
            public boolean add(V o) {
                LazyMap.this.modified = true;
                return this.values.add(o);
            }

            @Override
            public boolean remove(Object o) {
                LazyMap.this.modified = true;
                return this.values.remove(o);
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                return this.values.containsAll(c);
            }

            @Override
            public boolean addAll(Collection<? extends V> c) {
                LazyMap.this.modified = true;
                return this.values.addAll(c);
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                LazyMap.this.modified = true;
                return this.values.removeAll(c);
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                return this.values.retainAll(c);
            }

            @Override
            public void clear() {
                LazyMap.this.modified = true;
                this.values.clear();
            }

            @Override
            public boolean equals(Object o) {
                return ((Object)this.values).equals(o);
            }

            @Override
            public int hashCode() {
                return ((Object)this.values).hashCode();
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new Set<Map.Entry<K, V>>(){
            Set<Map.Entry<K, V>> entrySet;
            {
                this.entrySet = LazyMap.this.getDelegate(true).entrySet();
            }

            @Override
            public int size() {
                return this.entrySet.size();
            }

            @Override
            public boolean isEmpty() {
                return this.entrySet.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return this.entrySet.contains(o);
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return this.entrySet.iterator();
            }

            @Override
            public Object[] toArray() {
                return this.entrySet.toArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                return this.entrySet.toArray(a);
            }

            @Override
            public boolean add(Map.Entry<K, V> o) {
                LazyMap.this.modified = true;
                return this.entrySet.add(o);
            }

            @Override
            public boolean remove(Object o) {
                LazyMap.this.modified = true;
                return this.entrySet.remove(o);
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                return this.entrySet.containsAll(c);
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
                LazyMap.this.modified = true;
                return this.entrySet.addAll(c);
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                LazyMap.this.modified = true;
                return this.entrySet.retainAll(c);
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                LazyMap.this.modified = true;
                return this.entrySet.removeAll(c);
            }

            @Override
            public void clear() {
                LazyMap.this.modified = true;
                this.entrySet.clear();
            }

            @Override
            public boolean equals(Object o) {
                return ((Object)this.entrySet).equals(o);
            }

            @Override
            public int hashCode() {
                return ((Object)this.entrySet).hashCode();
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.getDelegate(false)).equals(o);
    }

    @Override
    public int hashCode() {
        return ((Object)this.getDelegate(false)).hashCode();
    }
}

