/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.api.html;

import java.text.NumberFormat;
import java.util.Locale;
import org.osivia.portal.api.internationalization.Bundle;

public class HtmlFormatter {
    private static final String[] UNITS = new String[]{"BYTE", "KILOBYTE", "MEGABYTE", "GIGABYTE", "TERABYTE"};
    private static final double UNIT_FACTOR = 1024.0;

    public static String formatSize(Locale locale, Bundle bundle, long size) {
        StringBuffer res = new StringBuffer();
        if (size > 0L) {
            int factor = Double.valueOf(Math.log10(size) / Math.log10(1024.0)).intValue();
            double factorizedSize = (double)size / Math.pow(1024.0, factor);
            String unit = bundle.getString(UNITS[factor]);
            NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
            numberFormat.setMaximumFractionDigits(1);
            res.append(numberFormat.format(factorizedSize));
            res.append("&nbsp;");
            res.append(unit);
        } else {
            res.append("0&nbsp;");
            res.append(bundle.getString(UNITS[0]));
        }
        return res.toString();
    }
}

