/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.core.error;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.portal.core.error.ErrorDescriptor;

public class GlobalErrorHandler {
    private static final String DATE_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss";
    protected static final Log logger = LogFactory.getLog(GlobalErrorHandler.class);
    private static GlobalErrorHandler s_instance = null;
    private long currentErrorId = 0L;
    private Log log = LogFactory.getLog((String)"PORTAL_USER_ERROR");

    public static synchronized GlobalErrorHandler getInstance() {
        if (s_instance == null) {
            s_instance = new GlobalErrorHandler();
        }
        return s_instance;
    }

    protected GlobalErrorHandler() {
    }

    public long logError(ErrorDescriptor error) {
        ++this.currentErrorId;
        error.setErrorId(this.currentErrorId);
        this.log.error((Object)GlobalErrorHandler.asString(error));
        logger.error((Object)error.getTrace());
        return this.currentErrorId;
    }

    public static String asString(ErrorDescriptor error) {
        StringBuffer sb = new StringBuffer();
        GlobalErrorHandler.appendAsText(sb, error);
        return sb.toString();
    }

    public static void appendAsText(StringBuffer sb, ErrorDescriptor error) {
        if (error != null) {
            Map<String, Object> errContext;
            String userId;
            sb.append("\nNum\u00e9ro: " + error.getErrorId());
            Date errDate = error.getDate();
            if (errDate != null) {
                sb.append("\ndate: ");
                sb.append(GlobalErrorHandler.format(errDate));
                sb.append("\n");
            }
            if (GlobalErrorHandler.isNotEmpty(userId = error.getUserId())) {
                sb.append("user: ");
                sb.append(userId);
                sb.append("\n");
            }
            if ((errContext = error.getProperties()) != null) {
                for (Map.Entry<String, Object> entry : errContext.entrySet()) {
                    sb.append(entry.getKey()).append(": ");
                    sb.append(entry.getValue());
                    sb.append("\n");
                }
            }
            sb.append("\n");
            sb.append(error.getTrace());
        }
    }

    private static String format(Date date) {
        return new SimpleDateFormat(DATE_TIME_FORMAT).format(date);
    }

    private static boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }
}

