/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.core.portalobjects;

import java.util.Iterator;
import org.jboss.portal.common.text.FastURLEncoder;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectContainer;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.command.mapping.PortalObjectPathMapper;
import org.jboss.portal.server.servlet.PathMapping;
import org.jboss.portal.server.servlet.PathMappingResult;
import org.jboss.portal.server.servlet.PathParser;

public class DynamicPortalObjectPathMapper
implements PortalObjectPathMapper {
    protected String namespace;
    protected PortalObjectContainer container;
    protected PathMapping mapping;
    protected PathParser pathParser = new PathParser();
    protected String effectiveNamespace;

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public PortalObjectContainer getContainer() {
        return this.container;
    }

    public void setContainer(PortalObjectContainer container) {
        this.container = container;
    }

    public void start() {
        this.effectiveNamespace = this.namespace == null ? "" : this.namespace;
        this.mapping = new PathMapping(){

            public Object getRoot() {
                return DynamicPortalObjectPathMapper.this.container.getContext(DynamicPortalObjectPathMapper.this.namespace != null ? DynamicPortalObjectPathMapper.this.namespace : "");
            }

            public Object getChild(Object parent, String name) {
                PortalObject po = (PortalObject)parent;
                if (po instanceof Page) {
                    po = DynamicPortalObjectPathMapper.this.container.getObject(po.getId());
                }
                return po.getChild(name);
            }
        };
    }

    public void stop() {
        this.mapping = null;
    }

    public PortalObject getTarget(ControllerContext controllerContext, String path) {
        if (path.length() == 0 || "/".equals(path)) {
            return this.container.getContext(this.effectiveNamespace);
        }
        PathMappingResult result = this.pathParser.map(this.mapping, path);
        return (PortalObject)result.getTarget();
    }

    public PortalObject getDefaultTarget() {
        return this.container.getContext(this.namespace);
    }

    public PathMapping createPathMapper(ControllerContext controllerContext) {
        return this.mapping;
    }

    public void appendPath(StringBuffer buffer, PortalObjectId id) {
        Iterator i = id.getPath().names();
        while (i.hasNext()) {
            String name = (String)i.next();
            name = FastURLEncoder.getUTF8Instance().encode(name);
            buffer.append('/').append(name);
        }
    }
}

