/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transporter;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.remoting.detection.Detector;
import org.jboss.remoting.network.NetworkRegistry;

public class InternalTransporterServices {
    public static final ObjectName DEFAULT_DETECTOR_OBJECTNAME = ObjectNameFactory.create((String)"remoting:type=Detector");
    public static final ObjectName DEFAULT_NETWORKREGISTRY_OBJECTNAME = ObjectNameFactory.create((String)"remoting:type=NetworkRegistry");
    private static final InternalTransporterServices SINGLETON = new InternalTransporterServices();
    private MBeanServer m_mBeanServer = null;
    private Detector m_detector = null;
    private ObjectName m_detectorName = null;
    private NetworkRegistry m_networkRegistry = null;
    private ObjectName m_networkRegistryName = null;

    public static InternalTransporterServices getInstance() {
        return SINGLETON;
    }

    private InternalTransporterServices() {
    }

    public MBeanServer getMBeanServer() {
        return this.m_mBeanServer;
    }

    public Detector getDetector() {
        return this.m_detector;
    }

    public ObjectName getDetectorName() {
        return this.m_detectorName;
    }

    public NetworkRegistry getNetworkRegistry() {
        return this.m_networkRegistry;
    }

    public ObjectName getNetworkRegistryName() {
        return this.m_networkRegistryName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSetup() {
        InternalTransporterServices internalTransporterServices = this;
        synchronized (internalTransporterServices) {
            return this.m_mBeanServer != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        InternalTransporterServices internalTransporterServices = this;
        synchronized (internalTransporterServices) {
            this.m_mBeanServer = null;
            this.m_detector = null;
            this.m_detectorName = null;
            this.m_networkRegistry = null;
            this.m_networkRegistryName = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignDetector(Detector detector, ObjectName detectorName, boolean registerDetector) throws IllegalArgumentException, IllegalStateException, Exception {
        InternalTransporterServices internalTransporterServices = this;
        synchronized (internalTransporterServices) {
            if (detector == null) {
                throw new IllegalArgumentException("Detector was null");
            }
            if (this.m_mBeanServer == null) {
                throw new IllegalStateException("There is no MBeanServer setup yet");
            }
            if (this.m_detector != null) {
                throw new IllegalStateException("A detector is already assigned");
            }
            if (detectorName == null) {
                detectorName = DEFAULT_DETECTOR_OBJECTNAME;
            }
            this.m_detector = detector;
            this.m_detectorName = detectorName;
            if (registerDetector) {
                this.m_mBeanServer.registerMBean(this.m_detector, this.m_detectorName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignNetworkRegistry(NetworkRegistry registry, ObjectName registryName, boolean registerRegistry) throws IllegalArgumentException, IllegalStateException, Exception {
        InternalTransporterServices internalTransporterServices = this;
        synchronized (internalTransporterServices) {
            if (registry == null) {
                throw new IllegalArgumentException("Registry was null");
            }
            if (this.m_mBeanServer == null) {
                throw new IllegalStateException("There is no MBeanServer setup yet");
            }
            if (this.m_networkRegistry != null) {
                throw new IllegalStateException("A network registry is already assigned");
            }
            if (registryName == null) {
                registryName = DEFAULT_NETWORKREGISTRY_OBJECTNAME;
            }
            this.m_networkRegistry = registry;
            this.m_networkRegistryName = registryName;
            if (registerRegistry) {
                this.m_mBeanServer.registerMBean(this.m_networkRegistry, this.m_networkRegistryName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup(MBeanServer mbs) throws IllegalArgumentException, IllegalStateException {
        InternalTransporterServices internalTransporterServices = this;
        synchronized (internalTransporterServices) {
            if (this.m_mBeanServer != null) {
                throw new IllegalStateException("The internal transporter services have already been setup");
            }
            if (mbs == null) {
                throw new IllegalArgumentException("MBeanServer must not be null");
            }
            this.m_mBeanServer = mbs;
            this.m_detector = null;
            this.m_detectorName = null;
            this.m_networkRegistry = null;
            this.m_networkRegistryName = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup(MBeanServer mbs, Detector detector, ObjectName detectorName, NetworkRegistry registry, ObjectName registryName, boolean registerDetector, boolean registerRegistry) throws Exception {
        InternalTransporterServices internalTransporterServices = this;
        synchronized (internalTransporterServices) {
            this.setup(mbs);
            if (detector != null) {
                this.assignDetector(detector, detectorName, registerDetector);
            }
            if (registry != null) {
                this.assignNetworkRegistry(registry, registryName, registerRegistry);
            }
        }
    }
}

