/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.jems.as.system;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.mx.util.MBeanProxyCreationException;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.portal.jems.as.JMX;
import org.jboss.system.ServiceController;
import org.jboss.system.ServiceControllerMBean;

public class LifeCycleAdapter {
    private static final ObjectName MBEAN_SERVER_DELEGATE = ObjectNameFactory.create((String)"JMImplementation:type=MBeanServerDelegate");
    protected Logger log;
    protected ServiceControllerMBean controller;
    protected MBeanServer server;
    private Listener listener;
    private Set watched;

    public LifeCycleAdapter(MBeanServer server) {
        try {
            this.log = Logger.getLogger(this.getClass());
            this.controller = (ServiceControllerMBean)MBeanProxy.get(ServiceControllerMBean.class, (ObjectName)ServiceController.OBJECT_NAME, (MBeanServer)server);
            this.server = server;
            this.listener = new Listener();
            this.watched = Collections.synchronizedSet(new HashSet());
        }
        catch (MBeanProxyCreationException mBeanProxyCreationException) {
            // empty catch block
        }
    }

    public void start() throws IllegalStateException {
        JMX.addNotificationListener(this.server, MBEAN_SERVER_DELEGATE, this.listener, this.listener, null);
        if (!JMX.addNotificationListener(this.server, ServiceControllerMBean.OBJECT_NAME, this.listener, this.listener, null)) {
            throw new IllegalStateException("The service controller is not here");
        }
    }

    public void stop() {
        JMX.removeNotificationListener(this.server, ServiceControllerMBean.OBJECT_NAME, this.listener);
        JMX.removeNotificationListener(this.server, MBEAN_SERVER_DELEGATE, this.listener);
        this.server = null;
        this.watched.clear();
    }

    public void addStateListener(ObjectName name) {
        try {
            this.server.addNotificationListener(name, this.listener, (NotificationFilter)this.listener, (Object)name);
            this.watched.add(name);
        }
        catch (Exception e) {
            this.log.error((Object)("Cannot become a listener of " + name), (Throwable)e);
        }
    }

    public void removeStateListener(ObjectName name) {
        try {
            this.server.removeNotificationListener(name, this.listener);
            this.watched.remove(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void created(ObjectName name) {
    }

    protected void starting(ObjectName name) {
    }

    protected void started(ObjectName name) {
    }

    protected void stopping(ObjectName name) {
    }

    protected void stopped(ObjectName name) {
    }

    protected void destroyed(ObjectName name) {
    }

    private class Listener
    implements NotificationListener,
    NotificationFilter {
        private static final long serialVersionUID = 4049015398272819164L;

        private Listener() {
        }

        public boolean isNotificationEnabled(Notification notification) {
            return true;
        }

        public void handleNotification(Notification notification, Object handback) {
            String type = notification.getType();
            if (type == "JMX.mbean.registered") {
                MBeanServerNotification msn = (MBeanServerNotification)notification;
                ObjectName name = msn.getMBeanName();
            } else if (type == "JMX.mbean.unregistered") {
                MBeanServerNotification msn = (MBeanServerNotification)notification;
                ObjectName name = msn.getMBeanName();
            } else if (type == "jmx.attribute.change") {
                AttributeChangeNotification acn = (AttributeChangeNotification)notification;
                ObjectName name = (ObjectName)handback;
                if ("State".equals(acn.getAttributeName())) {
                    int state = (Integer)acn.getNewValue();
                    switch (state) {
                        case 2: {
                            LifeCycleAdapter.this.starting(name);
                            break;
                        }
                        case 3: {
                            LifeCycleAdapter.this.started(name);
                            break;
                        }
                        case 1: {
                            LifeCycleAdapter.this.stopping(name);
                            break;
                        }
                        case 0: {
                            LifeCycleAdapter.this.stopped(name);
                            break;
                        }
                    }
                }
            } else if (type == "org.jboss.system.ServiceMBean.create") {
                ObjectName name = (ObjectName)notification.getUserData();
                if (LifeCycleAdapter.this.watched.contains(name)) {
                    LifeCycleAdapter.this.created(name);
                }
            } else if (type == "org.jboss.system.ServiceMBean.destroy") {
                ObjectName name = (ObjectName)notification.getUserData();
                if (LifeCycleAdapter.this.watched.contains(name)) {
                    LifeCycleAdapter.this.destroyed(name);
                }
            }
        }
    }
}

