/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portlet.content;

import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.portal.Mode;
import org.jboss.portal.core.impl.model.content.InternalContentProviderRegistry;
import org.jboss.portal.core.impl.model.content.generic.InternalGenericContentProvider;
import org.jboss.portal.core.model.content.ContentType;
import org.jboss.portal.core.model.content.spi.portlet.ContentPortlet;
import org.jboss.portal.core.model.instance.InstanceContainer;
import org.jboss.portal.jems.as.system.JBossServiceModelMBean;
import org.jboss.portal.security.spi.auth.PortalAuthorizationManagerFactory;

public class ContentTypeRegistration
implements ServletContextListener {
    private static final Logger log = Logger.getLogger(ContentTypeRegistration.class);
    private ContentType contentType;

    public void contextInitialized(ServletContextEvent event) {
        ServletContext ctx = event.getServletContext();
        String tmp = ctx.getInitParameter("org.jboss.portal.content_type");
        if (tmp == null) {
            log.warn((Object)"The content type of the content registration is not defined, please define the init parameter org.jboss.portal.content_type in web.xml");
            return;
        }
        this.contentType = ContentType.create((String)tmp);
        final String portletInstanceName = event.getServletContext().getInitParameter("org.jboss.portal.portlet_instance");
        if (portletInstanceName == null) {
            log.warn((Object)"The portlet instance name of the content registration is not defined, please define the init parameter org.jboss.portal.portlet_instance in web.xml");
            return;
        }
        ContentPortlet contentPortlet = new ContentPortlet(){

            public String getPortletName(Mode mode) {
                return portletInstanceName;
            }
        };
        log.debug((Object)("About to register content type " + this.contentType + " with portlet instance " + portletInstanceName));
        InternalGenericContentProvider provider = new InternalGenericContentProvider();
        provider.setContentType(this.contentType.toString());
        provider.setDecorateContent(true);
        provider.setContentPortletInfo(contentPortlet);
        try {
            String name = "portal:service=ContentRenderer,type=" + portletInstanceName;
            ObjectName objectName = new ObjectName(name);
            MBeanServer mbeanServer = MBeanServerLocator.locateJBoss();
            JBossServiceModelMBean mbean = new JBossServiceModelMBean((Object)provider);
            mbeanServer.registerMBean(mbean, objectName);
            ObjectName scObjectName = new ObjectName("jboss.system:service=ServiceController");
            mbeanServer.invoke(scObjectName, "create", new ObjectName[]{objectName}, new String[]{"javax.management.ObjectName"});
            ObjectName contentProviderRegistryON = new ObjectName("portal:service=ContentProviderRegistry");
            Object registry = MBeanProxy.get(InternalContentProviderRegistry.class, (ObjectName)contentProviderRegistryON, (MBeanServer)mbeanServer);
            mbean.setAttribute(new Attribute("Registry", registry));
            ObjectName instanceContainerON = new ObjectName("portal:container=Instance");
            Object container = MBeanProxy.get(InstanceContainer.class, (ObjectName)instanceContainerON, (MBeanServer)mbeanServer);
            mbean.setAttribute(new Attribute("InstanceContainer", container));
            ObjectName pamfON = new ObjectName("portal:service=PortalAuthorizationManagerFactory");
            Object factory = MBeanProxy.get(PortalAuthorizationManagerFactory.class, (ObjectName)pamfON, (MBeanServer)mbeanServer);
            mbean.setAttribute(new Attribute("PortalAuthorizationManagerFactory", factory));
            ArrayList<ObjectName> dependencies = new ArrayList<ObjectName>();
            dependencies.add(contentProviderRegistryON);
            dependencies.add(instanceContainerON);
            dependencies.add(pamfON);
            mbeanServer.invoke(scObjectName, "register", new Object[]{objectName, dependencies}, new String[]{"javax.management.ObjectName", "java.util.Collection"});
            mbeanServer.invoke(scObjectName, "start", new ObjectName[]{objectName}, new String[]{"javax.management.ObjectName"});
            log.debug((Object)("Registered InternalGenericContentProvider with name:" + name));
        }
        catch (Exception e) {
            log.warn((Object)"Couldn't perform ContentProvider registration", (Throwable)e);
            return;
        }
        log.debug((Object)("Registered content type " + this.contentType + " with portlet instance " + portletInstanceName));
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (this.contentType != null) {
            log.debug((Object)("About to unregister content type " + this.contentType));
            String portletInstanceName = event.getServletContext().getInitParameter("org.jboss.portal.portlet_instance");
            String name = "portal:service=ContentRenderer,type=" + portletInstanceName;
            try {
                ObjectName objectName = new ObjectName(name);
                ObjectName scObjectName = new ObjectName("jboss.system:service=ServiceController");
                MBeanServer mbeanServer = MBeanServerLocator.locateJBoss();
                mbeanServer.invoke(scObjectName, "stop", new ObjectName[]{objectName}, new String[]{"javax.management.ObjectName"});
                mbeanServer.invoke(scObjectName, "remove", new Object[]{objectName}, new String[]{"javax.management.ObjectName"});
            }
            catch (Exception e) {
                log.warn((Object)"Couldn't perform ContentProvider registration", (Throwable)e);
                return;
            }
            log.debug((Object)("Content type " + this.contentType + " has been unregistered"));
        }
    }
}

