/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.portlet;

import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.RenderResponse;
import javax.servlet.jsp.PageContext;
import org.displaytag.portlet.PortletHref;
import org.displaytag.util.Href;
import org.displaytag.util.RequestHelper;

public class PortletRequestHelper
implements RequestHelper {
    public static final String JAVAX_PORTLET_RESPONSE = "javax.portlet.response";
    public static final String JAVAX_PORTLET_REQUEST = "javax.portlet.request";
    private final PortletRequest portletRequest;
    private final RenderResponse renderResponse;

    public PortletRequestHelper(PageContext pageContext) {
        if (pageContext == null) {
            throw new IllegalArgumentException("pageContext may not be null");
        }
        this.portletRequest = (PortletRequest)pageContext.findAttribute(JAVAX_PORTLET_REQUEST);
        if (this.portletRequest == null) {
            throw new IllegalStateException("A PortletRequest could not be found in the PageContext for the key='javax.portlet.request'");
        }
        this.renderResponse = (RenderResponse)pageContext.findAttribute(JAVAX_PORTLET_RESPONSE);
        if (this.portletRequest == null) {
            throw new IllegalStateException("A RenderResponse could not be found in the PageContext for the key='javax.portlet.response'");
        }
    }

    public Href getHref() {
        PortletHref href = new PortletHref(this.portletRequest, this.renderResponse);
        href.setParameterMap(this.portletRequest.getParameterMap());
        if (this.portletRequest.isSecure()) {
            href.setRequestedSecure(true);
        }
        return href;
    }

    public String getParameter(String key) {
        return this.portletRequest.getParameter(key);
    }

    public Integer getIntParameter(String key) {
        try {
            return new Integer(this.getParameter(key));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public Map getParameterMap() {
        return this.portletRequest.getParameterMap();
    }
}

