/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.controller;

import org.jboss.logging.Logger;
import org.jboss.portal.common.invocation.Invocation;
import org.jboss.portal.common.invocation.InvocationContext;
import org.jboss.portal.common.invocation.InvocationException;
import org.jboss.portal.common.invocation.InvocationHandler;
import org.jboss.portal.common.invocation.Scope;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.controller.ControllerException;
import org.jboss.portal.core.controller.ControllerResponse;
import org.jboss.portal.core.controller.NoSuchResourceException;
import org.jboss.portal.core.controller.SecurityException;
import org.jboss.portal.core.controller.command.info.CommandInfo;
import org.jboss.portal.security.spi.auth.PortalAuthorizationManager;

public abstract class ControllerCommand
extends Invocation {
    public static final Scope PRINCIPAL_SCOPE = Scope.PRINCIPAL_SCOPE;
    public static final Scope SESSION_SCOPE = Scope.SESSION_SCOPE;
    public static final Scope REQUEST_SCOPE = Scope.REQUEST_SCOPE;
    public static final Scope NAVIGATIONAL_STATE_SCOPE = new Scope("navigationalstate");
    protected static Logger log = Logger.getLogger(ControllerCommand.class);
    protected ControllerContext context;
    private static final InvocationHandler handler = new InvocationHandler(){

        public Object invoke(Invocation invocation) throws Exception, InvocationException {
            ControllerCommand cmd = (ControllerCommand)invocation;
            return cmd.execute();
        }
    };

    protected ControllerCommand() {
        this.setHandler(handler);
    }

    public abstract CommandInfo getInfo();

    public final InvocationContext getContext() {
        if (this.context == null) {
            throw new IllegalStateException();
        }
        return this.context;
    }

    public final ControllerContext getControllerContext() {
        return this.context;
    }

    public void enforceSecurity(PortalAuthorizationManager pam) throws SecurityException {
    }

    public void acquireResources() throws NoSuchResourceException {
    }

    public void releaseResources() {
    }

    public final void createContext(ControllerContext context) throws ControllerException {
        this.context = context;
        this.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroyContext() {
        try {
            this.destroy();
        }
        finally {
            this.context = null;
        }
    }

    protected void create() {
    }

    protected void destroy() {
    }

    public abstract ControllerResponse execute() throws ControllerException;

    public static void rethrow(Exception e) throws ControllerException, InvocationException, RuntimeException {
        if (e instanceof InvocationException) {
            throw (InvocationException)e;
        }
        if (e instanceof ControllerException) {
            throw (ControllerException)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new ControllerException(e);
    }
}

