/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.event;

import org.jboss.portal.core.event.PortalEventListenerRegistry;
import org.jboss.portal.core.event.PortalEventListenerService;
import org.jboss.portal.jems.as.system.AbstractJBossService;

public class PortalEventListenerServiceImpl
extends AbstractJBossService
implements PortalEventListenerService {
    protected String registryId;
    protected PortalEventListenerRegistry registry;
    protected Object listener;
    protected String listenerClassName;

    public String getListenerClassName() {
        return this.listenerClassName;
    }

    public void setListenerClassName(String listenerClassName) {
        this.listenerClassName = listenerClassName;
    }

    public String getRegistryId() {
        return this.registryId;
    }

    public void setRegistryId(String registryId) {
        this.registryId = registryId;
    }

    public PortalEventListenerRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(PortalEventListenerRegistry registry) {
        this.registry = registry;
    }

    public Object getListener() {
        return this.listener;
    }

    protected void startService() throws Exception {
        this.log.debug((Object)("Getting listener class " + this.listenerClassName));
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> listenerClass = loader.loadClass(this.listenerClassName);
        this.log.debug((Object)("Creating listener instance of  " + listenerClass.getName()));
        this.listener = listenerClass.newInstance();
        this.log.debug((Object)("Registering listener instance " + listenerClass.getName() + " with id " + this.registryId));
        this.registry.registerListener(this.registryId, this.listener);
    }

    protected void stopService() {
        this.log.debug((Object)("Unregistering listener instance with id " + this.registryId));
        this.registry.unregisterListener(this.registryId);
        this.listener = null;
    }
}

