/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.portlet.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jboss.portal.common.NotYetImplemented;
import org.jboss.portal.common.util.AbstractTypedMap;
import org.jboss.portal.common.util.LazyMap;
import org.jboss.portal.common.util.MapAccessor;
import org.jboss.portal.common.util.TypedMap;
import org.jboss.portal.core.impl.portlet.state.PersistentConsumer;
import org.jboss.portal.registration.Consumer;
import org.jboss.portal.registration.Registration;
import org.jboss.portal.registration.RegistrationStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentRegistration
implements Registration {
    private Long key = null;
    private String persistentHandle = null;
    private RegistrationStatus persistentStatus;
    private Map<String, Object> persistentProperties;
    private PersistentConsumer relatedConsumer = null;
    private Set relatedPortletStates;
    private Properties properties;
    private static final AbstractTypedMap.Converter KEY_CONVERTER = new AbstractTypedMap.Converter(){

        protected Object getInternal(Object o) throws IllegalArgumentException, ClassCastException {
            if (!(o instanceof QName)) {
                throw new ClassCastException();
            }
            return o;
        }

        protected Object getExternal(Object o) {
            return o;
        }

        protected boolean equals(Object o, Object o1) {
            return o.equals(o1);
        }
    };
    private static final AbstractTypedMap.Converter VALUE_CONVERTER = new AbstractTypedMap.Converter(){

        protected Object getInternal(Object o) throws IllegalArgumentException, ClassCastException {
            if (!(o instanceof String)) {
                throw new ClassCastException();
            }
            return o;
        }

        protected Object getExternal(Object o) {
            return o;
        }

        protected boolean equals(Object o, Object o1) {
            return o.equals(o1);
        }
    };
    private LazyMap<String, Object> lazyMap = new LazyMap((MapAccessor)new MapAccessor<String, Object>(){

        public Map<String, Object> getMap(boolean writable) {
            return PersistentRegistration.this.persistentProperties;
        }
    });

    PersistentRegistration() {
        this.persistentStatus = null;
        this.persistentProperties = new HashMap<String, Object>();
        this.properties = new Properties();
        this.relatedPortletStates = null;
    }

    public PersistentRegistration(Map<String, Object> properties, RegistrationStatus status) {
        this.persistentStatus = status;
        this.persistentProperties = properties;
        this.properties = new Properties();
        this.relatedPortletStates = new HashSet();
        this.properties.validate();
    }

    public Long getKey() {
        return this.key;
    }

    public void setKey(Long key) {
        this.key = key;
    }

    public Set getRelatedPortletStates() {
        return this.relatedPortletStates;
    }

    public void setRelatedPortletStates(Set relatedPortletStates) {
        this.relatedPortletStates = relatedPortletStates;
    }

    public String getPersistentHandle() {
        return this.persistentHandle;
    }

    public void setPersistentHandle(String persistentHandle) {
        this.persistentHandle = persistentHandle;
    }

    public PersistentConsumer getRelatedConsumer() {
        return this.relatedConsumer;
    }

    public void setRelatedConsumer(PersistentConsumer relatedConsumer) {
        this.relatedConsumer = relatedConsumer;
    }

    public RegistrationStatus getPersistentStatus() {
        return this.persistentStatus;
    }

    public void setPersistentStatus(RegistrationStatus persistentStatus) {
        this.persistentStatus = persistentStatus;
    }

    public Map<String, Object> getPersistentProperties() {
        return this.persistentProperties;
    }

    public void setPersistentProperties(Map<String, Object> persistentProperties) {
        this.persistentProperties = persistentProperties;
    }

    public String getId() {
        if (this.key == null) {
            throw new IllegalStateException("Transient registration object");
        }
        return this.key.toString();
    }

    public void setRegistrationHandle(String handle) {
        this.persistentHandle = handle;
    }

    public String getRegistrationHandle() {
        return this.persistentHandle;
    }

    public Consumer getConsumer() {
        return this.relatedConsumer;
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public void setPropertyValueFor(QName propertyName, Object value) {
        this.properties.setProperty(propertyName, value);
    }

    public void setPropertyValueFor(String propertyName, Object value) {
        this.properties.setProperty(propertyName, value);
    }

    public void removeProperty(QName propertyName) {
        this.properties.removeProperty(propertyName);
    }

    public void removeProperty(String propertyName) {
        this.properties.removeProperty(propertyName);
    }

    public Object getPropertyValueFor(QName propertyName) {
        return this.properties.getProperty(propertyName);
    }

    public Object getPropertyValueFor(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    public void updateProperties(Map registrationProperties) {
        this.properties.replace(registrationProperties);
    }

    public boolean hasEqualProperties(Registration registration) {
        if (registration != null) {
            PersistentRegistration preg = (PersistentRegistration)registration;
            return this.hasEqualProperties(preg.persistentProperties);
        }
        return false;
    }

    public boolean hasEqualProperties(Map properties) {
        return this.properties.equals(properties);
    }

    public RegistrationStatus getStatus() {
        return this.persistentStatus;
    }

    public void setStatus(RegistrationStatus status) {
        this.persistentStatus = status;
    }

    public void clearAssociatedState() {
        throw new NotYetImplemented();
    }

    public class Properties
    extends TypedMap {
        public Properties() {
            super((Map)PersistentRegistration.this.lazyMap, KEY_CONVERTER, VALUE_CONVERTER);
        }

        public void setProperty(String propertyName, Object value) {
            if (propertyName == null) {
                throw new IllegalArgumentException("No null property name accepted");
            }
            this.setProperty(new QName(propertyName), value);
        }

        public void setProperty(QName propertyName, Object value) {
            if (propertyName == null) {
                throw new IllegalArgumentException("No null property name accepted");
            }
            this.put(propertyName, value);
        }

        public void removeProperty(QName propertyName) {
            if (propertyName == null) {
                throw new IllegalArgumentException("No null property name accepted");
            }
            this.remove(propertyName);
        }

        public void removeProperty(String propertyName) {
            if (propertyName == null) {
                throw new IllegalArgumentException("No null property name accepted");
            }
            this.removeProperty(new QName(propertyName));
        }

        public Object getProperty(QName propertyName) {
            if (propertyName == null) {
                throw new IllegalArgumentException("No null property name accepted");
            }
            return this.get(propertyName);
        }

        public Object getProperty(String propertyName) {
            if (propertyName == null) {
                throw new IllegalArgumentException("No null property name accepted");
            }
            return this.getProperty(new QName(propertyName));
        }
    }
}

