/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model.portal.command.action;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.core.controller.ControllerException;
import org.jboss.portal.core.controller.command.info.ActionCommandInfo;
import org.jboss.portal.core.controller.command.info.CommandInfo;
import org.jboss.portal.core.controller.portlet.ControllerPageNavigationalState;
import org.jboss.portal.core.controller.portlet.ControllerPortletControllerContext;
import org.jboss.portal.core.controller.portlet.ControllerResponseFactory;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.command.action.InvokePortletWindowCommand;
import org.jboss.portal.core.model.portal.command.response.UpdatePageResponse;
import org.jboss.portal.portlet.ParametersStateString;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.StateString;
import org.jboss.portal.portlet.controller.PortletController;
import org.jboss.portal.portlet.controller.PortletControllerContext;
import org.jboss.portal.portlet.controller.request.ContainerRequest;
import org.jboss.portal.portlet.controller.request.ControllerRequest;
import org.jboss.portal.portlet.controller.request.PortletRenderRequest;
import org.jboss.portal.portlet.controller.response.ControllerResponse;
import org.jboss.portal.portlet.controller.response.PageUpdateResponse;
import org.jboss.portal.portlet.controller.state.PortletPageNavigationalState;
import org.jboss.portal.portlet.controller.state.PortletWindowNavigationalState;
import org.jboss.portal.portlet.info.ParameterInfo;
import org.jboss.portal.portlet.info.PortletInfo;

public class InvokePortletWindowRenderCommand
extends InvokePortletWindowCommand {
    private static final String[] REMOVED_PARAMETER = new String[0];
    private static final CommandInfo info = new ActionCommandInfo(true);

    public InvokePortletWindowRenderCommand(PortalObjectId windowId, Mode mode, WindowState windowState, StateString navigationalState) throws IllegalArgumentException {
        super(windowId, mode, windowState, navigationalState);
    }

    public InvokePortletWindowRenderCommand(PortalObjectId windowId, Mode mode, WindowState windowState) throws IllegalArgumentException {
        super(windowId, mode, windowState, null);
    }

    public CommandInfo getInfo() {
        return info;
    }

    protected ContainerRequest createPortletRequest(PortletInfo portletInfo, PortletPageNavigationalState pageNS, PortletWindowNavigationalState windowNS) {
        Mode newMode = null;
        WindowState newWindowState = null;
        StateString newNavigationalState = null;
        if (windowNS != null) {
            newMode = windowNS.getMode();
            newWindowState = windowNS.getWindowState();
            newNavigationalState = windowNS.getPortletNavigationalState();
        }
        if (this.mode != null) {
            newMode = this.mode;
        }
        if (this.windowState != null) {
            newWindowState = this.windowState;
        }
        if (this.navigationalState != null) {
            newNavigationalState = this.navigationalState;
        }
        Map<String, String[]> publicChanges = Collections.emptyMap();
        if (this.navigationalState instanceof ParametersStateString) {
            ParametersStateString navigationalParameters = (ParametersStateString)this.navigationalState;
            Map parameters = navigationalParameters.getParameters();
            for (ParameterInfo parameterInfo : portletInfo.getNavigation().getPublicParameters()) {
                String key = parameterInfo.getId();
                String[] values = (String[])parameters.remove(key);
                if (values == null) {
                    values = REMOVED_PARAMETER;
                }
                if (publicChanges.isEmpty()) {
                    publicChanges = new HashMap();
                }
                publicChanges.put(key, values);
            }
        }
        return new PortletRenderRequest(this.window.getName(), new PortletWindowNavigationalState(newNavigationalState, newMode, newWindowState), publicChanges, pageNS);
    }

    public org.jboss.portal.core.controller.ControllerResponse execute() throws ControllerException {
        try {
            ControllerPortletControllerContext cpcc = new ControllerPortletControllerContext(this.context, this.page);
            ControllerPageNavigationalState pageNS = cpcc.getStateControllerContext().createPortletPageNavigationalState(false);
            PortletWindowNavigationalState windowNS = pageNS.getPortletWindowNavigationalState(this.window.getName());
            PortletInfo portletInfo = cpcc.getPortletInfo(this.window.getName());
            ContainerRequest containerRequest = this.createPortletRequest(portletInfo, pageNS, windowNS);
            PortletController controller = new PortletController();
            ControllerResponse cr = controller.process((PortletControllerContext)cpcc, (ControllerRequest)containerRequest);
            PageUpdateResponse pageUpdate = (PageUpdateResponse)cr;
            ControllerPageNavigationalState pageNavigationalState = (ControllerPageNavigationalState)pageUpdate.getPageNavigationalState();
            pageNavigationalState.flushUpdates();
            return new UpdatePageResponse(this.page.getId());
        }
        catch (PortletInvokerException e) {
            return ControllerResponseFactory.createResponse(e);
        }
    }
}

