/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server.jmx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.jms.IllegalStateException;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.MessageStatistics;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.Subscription;
import org.jboss.mq.server.BasicQueue;
import org.jboss.mq.server.JMSDestinationManager;
import org.jboss.mq.server.JMSTopic;
import org.jboss.mq.server.MessageCounter;
import org.jboss.mq.server.PersistentQueue;
import org.jboss.mq.server.jmx.DestinationMBeanSupport;
import org.jboss.mq.server.jmx.TopicMBean;

public class Topic
extends DestinationMBeanSupport
implements TopicMBean {
    protected JMSTopic destination;

    public String getTopicName() {
        return this.destinationName;
    }

    public void startService() throws Exception {
        if (this.destinationName == null || this.destinationName.length() == 0) {
            throw new IllegalStateException("TopicName was not set");
        }
        JMSDestinationManager jmsServer = (JMSDestinationManager)this.server.getAttribute(this.jbossMQService, "Interceptor");
        this.spyDest = new SpyTopic(this.destinationName);
        this.destination = new JMSTopic(this.spyDest, null, jmsServer, this.parameters);
        jmsServer.addDestination(this.destination);
        if (this.jndiName == null) {
            this.setJNDIName("topic/" + this.destinationName);
        } else {
            this.setJNDIName(this.jndiName);
        }
        super.startService();
    }

    public void stopService() throws Exception {
        super.stopService();
        this.destination = null;
    }

    public void removeAllMessages() throws Exception {
        if (this.destination == null) {
            return;
        }
        this.destination.removeAllMessages();
    }

    public int getAllMessageCount() {
        if (this.destination == null) {
            return 0;
        }
        return this.destination.getAllMessageCount();
    }

    public int getDurableMessageCount() {
        if (this.destination == null) {
            return 0;
        }
        return this.destination.getDurableMessageCount();
    }

    public int getNonDurableMessageCount() {
        if (this.destination == null) {
            return 0;
        }
        return this.destination.getNonDurableMessageCount();
    }

    public int getAllSubscriptionsCount() {
        if (this.destination == null) {
            return 0;
        }
        return this.destination.getAllSubscriptionsCount();
    }

    public int getDurableSubscriptionsCount() {
        if (this.destination == null) {
            return 0;
        }
        return this.destination.getDurableSubscriptionsCount();
    }

    public int getNonDurableSubscriptionsCount() {
        if (this.destination == null) {
            return 0;
        }
        return this.destination.getNonDurableSubscriptionsCount();
    }

    public List listAllSubscriptions() {
        if (this.destination == null) {
            return null;
        }
        return this.destination.getAllSubscriptions();
    }

    public List listDurableSubscriptions() {
        if (this.destination == null) {
            return null;
        }
        return this.destination.getDurableSubscriptions();
    }

    public List listNonDurableSubscriptions() {
        if (this.destination == null) {
            return null;
        }
        return this.destination.getNonDurableSubscriptions();
    }

    public List listMessages(String id) throws Exception {
        if (this.destination == null) {
            return null;
        }
        BasicQueue queue = this.findBasicQueue(id);
        return Arrays.asList(queue.browse(null));
    }

    public List listMessages(String id, String selector) throws Exception {
        if (this.destination == null) {
            return null;
        }
        BasicQueue queue = this.findBasicQueue(id);
        return Arrays.asList(queue.browse(selector));
    }

    public List listNonDurableMessages(String id, String sub) throws Exception {
        if (this.destination == null) {
            return null;
        }
        BasicQueue queue = this.findNonDurableBasicQueue(id, sub);
        return Arrays.asList(queue.browse(null));
    }

    public List listNonDurableMessages(String id, String sub, String selector) throws Exception {
        if (this.destination == null) {
            return null;
        }
        BasicQueue queue = this.findNonDurableBasicQueue(id, sub);
        return Arrays.asList(queue.browse(selector));
    }

    public List listDurableMessages(String id, String name) throws Exception {
        if (this.destination == null) {
            return null;
        }
        BasicQueue queue = this.findDurableBasicQueue(id, name);
        return Arrays.asList(queue.browse(null));
    }

    public List listDurableMessages(String id, String name, String selector) throws Exception {
        if (this.destination == null) {
            return null;
        }
        BasicQueue queue = this.findDurableBasicQueue(id, name);
        return Arrays.asList(queue.browse(selector));
    }

    public long getNonDurableMessageCount(String id, String sub) throws Exception {
        if (this.destination == null) {
            return 0L;
        }
        BasicQueue queue = this.findNonDurableBasicQueue(id, sub);
        return queue.getQueueDepth();
    }

    public long getDurableMessageCount(String id, String name) throws Exception {
        if (this.destination == null) {
            return 0L;
        }
        BasicQueue queue = this.findDurableBasicQueue(id, name);
        return queue.getQueueDepth();
    }

    public List listNonDurableScheduledMessages(String id, String sub) throws Exception {
        if (this.destination == null) {
            return null;
        }
        BasicQueue queue = this.findNonDurableBasicQueue(id, sub);
        return queue.browseScheduled(null);
    }

    public List listNonDurableScheduledMessages(String id, String sub, String selector) throws Exception {
        if (this.destination == null) {
            return null;
        }
        BasicQueue queue = this.findNonDurableBasicQueue(id, sub);
        return queue.browseScheduled(selector);
    }

    public List listDurableScheduledMessages(String id, String name) throws Exception {
        if (this.destination == null) {
            return null;
        }
        BasicQueue queue = this.findDurableBasicQueue(id, name);
        return queue.browseScheduled(null);
    }

    public List listDurableScheduledMessages(String id, String name, String selector) throws Exception {
        if (this.destination == null) {
            return null;
        }
        BasicQueue queue = this.findDurableBasicQueue(id, name);
        return queue.browseScheduled(selector);
    }

    public long getNonDurableScheduledMessageCount(String id, String sub) throws Exception {
        if (this.destination == null) {
            return 0L;
        }
        BasicQueue queue = this.findNonDurableBasicQueue(id, sub);
        return queue.getScheduledMessageCount();
    }

    public long getDurableScheduledMessageCount(String id, String name) throws Exception {
        if (this.destination == null) {
            return 0L;
        }
        BasicQueue queue = this.findDurableBasicQueue(id, name);
        return queue.getScheduledMessageCount();
    }

    public List listNonDurableInProcessMessages(String id, String sub) throws Exception {
        if (this.destination == null) {
            return null;
        }
        BasicQueue queue = this.findNonDurableBasicQueue(id, sub);
        return queue.browseInProcess(null);
    }

    public List listNonDurableInProcessMessages(String id, String sub, String selector) throws Exception {
        if (this.destination == null) {
            return null;
        }
        BasicQueue queue = this.findNonDurableBasicQueue(id, sub);
        return queue.browseInProcess(selector);
    }

    public List listDurableInProcessMessages(String id, String name) throws Exception {
        if (this.destination == null) {
            return null;
        }
        BasicQueue queue = this.findDurableBasicQueue(id, name);
        return queue.browseInProcess(null);
    }

    public List listDurableInProcessMessages(String id, String name, String selector) throws Exception {
        if (this.destination == null) {
            return null;
        }
        BasicQueue queue = this.findDurableBasicQueue(id, name);
        return queue.browseInProcess(selector);
    }

    public long getNonDurableInProcessMessageCount(String id, String sub) throws Exception {
        if (this.destination == null) {
            return 0L;
        }
        BasicQueue queue = this.findNonDurableBasicQueue(id, sub);
        return queue.getInProcessMessageCount();
    }

    public long getDurableInProcessMessageCount(String id, String name) throws Exception {
        if (this.destination == null) {
            return 0L;
        }
        BasicQueue queue = this.findDurableBasicQueue(id, name);
        return queue.getInProcessMessageCount();
    }

    public MessageCounter[] getMessageCounter() {
        if (this.destination == null) {
            return null;
        }
        return this.destination.getMessageCounter();
    }

    public MessageStatistics[] getMessageStatistics() throws Exception {
        if (this.destination == null) {
            return null;
        }
        return MessageCounter.getMessageStatistics(this.destination.getMessageCounter());
    }

    protected BasicQueue findBasicQueue(String id) throws Exception {
        if (this.destination == null) {
            return null;
        }
        ArrayList queues = this.destination.getAllQueues();
        if (id == null) {
            throw new IllegalArgumentException("Null subscription id: " + this.help(queues));
        }
        Iterator i = queues.iterator();
        while (i.hasNext()) {
            BasicQueue q = (BasicQueue)i.next();
            if (!q.getDescription().equals(id)) continue;
            return q;
        }
        throw new IllegalArgumentException("Invalid subscription id: " + this.help(queues));
    }

    protected BasicQueue findNonDurableBasicQueue(String id, String sub) throws Exception {
        if (this.destination == null) {
            return null;
        }
        ArrayList subscriptions = this.destination.getNonDurableSubscriptions();
        if (id == null) {
            throw new IllegalArgumentException("Null subscription id, enter client id plus the subscription id: " + this.help(subscriptions));
        }
        Iterator i = subscriptions.iterator();
        while (i.hasNext()) {
            Subscription s = (Subscription)i.next();
            String clientId = s.connectionToken.getClientID();
            if (sub != null && sub.trim().length() != 0 && !Integer.toString(s.subscriptionId).equals(sub) || clientId == null || !clientId.equals(id)) continue;
            return this.destination.getQueue(s);
        }
        throw new IllegalArgumentException("Invalid subscription id, enter client id plus the subscription id: " + this.help(subscriptions));
    }

    protected BasicQueue findDurableBasicQueue(String id, String name) throws Exception {
        if (this.destination == null) {
            return null;
        }
        ArrayList subscriptions = this.destination.getDurableSubscriptions();
        if (id == null || name == null) {
            throw new IllegalArgumentException("Null durable subscription enter client id and subscription name: " + this.help(subscriptions));
        }
        DurableSubscriptionID durID = new DurableSubscriptionID(id, name, null);
        PersistentQueue result = this.destination.getDurableSubscription(durID);
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException("Invalid durable subscription enter client id and subscription name: " + this.help(subscriptions));
    }

    protected String help(List queues) {
        return "id must be one from the following list " + queues;
    }
}

