/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.sm.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.sm.AbstractStateManager;
import org.jboss.mq.sm.StateManager;
import org.jboss.mq.sm.file.DynamicStateManagerMBean;
import org.jboss.mq.xml.XElement;
import org.jboss.mq.xml.XElementException;
import org.jboss.system.server.ServerConfigLocator;

public class DynamicStateManager
extends AbstractStateManager
implements DynamicStateManagerMBean {
    boolean hasSecurityManager = true;
    XElement stateConfig = new XElement("StateManager");
    private String stateFile = "jbossmq-state.xml";
    private URL systemConfigURL;

    public StateManager getInstance() {
        return this;
    }

    protected void createService() throws Exception {
        this.systemConfigURL = ServerConfigLocator.locate().getServerConfigURL();
    }

    public void startService() throws Exception {
        this.loadConfig();
    }

    public String displayStateConfig() throws Exception {
        return this.stateConfig.toString();
    }

    public void setStateFile(String newStateFile) {
        this.stateFile = newStateFile.trim();
    }

    public String getStateFile() {
        return this.stateFile;
    }

    public boolean hasSecurityManager() {
        return this.hasSecurityManager;
    }

    public void setHasSecurityManager(boolean hasSecurityManager) {
        this.hasSecurityManager = hasSecurityManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfig() throws IOException, XElementException {
        URL configURL = new URL(this.systemConfigURL, this.stateFile);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Loading config from: " + configURL));
        }
        BufferedInputStream in = new BufferedInputStream(configURL.openStream());
        try {
            XElement xElement = this.stateConfig;
            synchronized (xElement) {
                this.stateConfig = XElement.createFrom(in);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            ((InputStream)in).close();
            throw throwable;
        }
        ((InputStream)in).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfig() throws IOException {
        URL configURL = new URL(this.systemConfigURL, this.stateFile);
        if (configURL.getProtocol().equals("file")) {
            File file = new File(configURL.getFile());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Saving config to: " + file));
            }
            PrintStream stream = new PrintStream(new FileOutputStream(file));
            try {
                XElement xElement = this.stateConfig;
                synchronized (xElement) {
                    stream.print(this.stateConfig.toXML(true));
                }
                Object var7_6 = null;
                stream.close();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                stream.close();
                throw throwable;
            }
        }
        this.log.error((Object)("Can not save configuration to non-file URL: " + configURL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getPreconfClientId(String login, String passwd) throws JMSException {
        try {
            XElement xElement = this.stateConfig;
            synchronized (xElement) {
                Enumeration enumeration = this.stateConfig.getElementsNamed("Users/User");
                while (enumeration.hasMoreElements()) {
                    String pw;
                    XElement element = (XElement)enumeration.nextElement();
                    String name = element.getField("Name");
                    if (!name.equals(login)) continue;
                    if (!this.hasSecurityManager && !passwd.equals(pw = element.getField("Password"))) {
                        throw new JMSSecurityException("Bad password");
                    }
                    String clientId = null;
                    if (element.containsField("Id")) {
                        clientId = element.getField("Id");
                    }
                    return clientId;
                }
                if (!this.hasSecurityManager) {
                    throw new JMSSecurityException("This user does not exist");
                }
                return null;
            }
        }
        catch (XElementException e) {
            this.log.error((Object)e);
            throw new JMSException("Invalid server user configuration.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractStateManager.DurableSubscription getDurableSubscription(DurableSubscriptionID sub) throws JMSException {
        boolean debug = this.log.isDebugEnabled();
        try {
            XElement xElement = this.stateConfig;
            synchronized (xElement) {
                Enumeration enumeration = this.stateConfig.getElementsNamed("DurableSubscriptions/DurableSubscription");
                while (enumeration.hasMoreElements()) {
                    XElement dur = (XElement)enumeration.nextElement();
                    if (!dur.containsField("ClientID") || !dur.getField("ClientID").equals(sub.getClientID()) || !dur.getField("Name").equals(sub.getSubscriptionName())) continue;
                    if (debug) {
                        this.log.debug((Object)"Found a matching ClientID configuration section.");
                    }
                    return new DynamicDurableSubscription(dur);
                }
                return null;
            }
        }
        catch (XElementException e) {
            SpyJMSException newE = new SpyJMSException("Could not find durable subscription");
            newE.setLinkedException(e);
            throw newE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkLoggedOnClientId(String clientID) throws JMSException {
        XElement xElement = this.stateConfig;
        synchronized (xElement) {
            Enumeration enumeration = this.stateConfig.getElementsNamed("Users/User");
            while (enumeration.hasMoreElements()) {
                XElement element = (XElement)enumeration.nextElement();
                try {
                    if (!element.containsField("Id") || !element.getField("Id").equals(clientID)) continue;
                    throw new InvalidClientIDException("This loggedOnClientIds is password protected !");
                }
                catch (XElementException ignore) {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void saveDurableSubscription(AbstractStateManager.DurableSubscription ds) throws JMSException {
        try {
            XElement xElement = this.stateConfig;
            synchronized (xElement) {
                if (ds instanceof DynamicDurableSubscription) {
                    XElement s = ((DynamicDurableSubscription)ds).getElement();
                    if (s == null) throw new JMSException("Can not save a null subscription");
                    s.setField("TopicName", ds.getTopic());
                    s.setOptionalField("Selector", ds.getSelector());
                } else {
                    XElement dur = this.stateConfig.getElement("DurableSubscriptions");
                    XElement subscription = new XElement("DurableSubscription");
                    subscription.addField("ClientID", ds.getClientID());
                    subscription.addField("Name", ds.getName());
                    subscription.addField("TopicName", ds.getTopic());
                    subscription.setOptionalField("Selector", ds.getSelector());
                    dur.addElement(subscription);
                }
                this.saveConfig();
                return;
            }
        }
        catch (XElementException e) {
            SpyJMSException newE = new SpyJMSException("Could not save the durable subscription");
            newE.setLinkedException(e);
            throw newE;
        }
        catch (IOException e) {
            SpyJMSException newE = new SpyJMSException("Could not save the durable subscription");
            newE.setLinkedException(e);
            throw newE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDurableSubscription(AbstractStateManager.DurableSubscription ds) throws JMSException {
        try {
            XElement xElement = this.stateConfig;
            synchronized (xElement) {
                XElement s = ((DynamicDurableSubscription)ds).getElement();
                if (s == null) {
                    throw new JMSException("Can not remove a null subscription");
                }
                s.removeFromParent();
                this.saveConfig();
            }
        }
        catch (XElementException e) {
            SpyJMSException newE = new SpyJMSException("Could not remove the durable subscription");
            newE.setLinkedException(e);
            throw newE;
        }
        catch (IOException e) {
            SpyJMSException newE = new SpyJMSException("Could not remove the durable subscription");
            newE.setLinkedException(e);
            throw newE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getDurableSubscriptionIdsForTopic(SpyTopic topic) throws JMSException {
        ArrayList<DurableSubscriptionID> durableSubs = new ArrayList<DurableSubscriptionID>();
        try {
            XElement xElement = this.stateConfig;
            synchronized (xElement) {
                Enumeration enumeration = this.stateConfig.getElementsNamed("DurableSubscriptions/DurableSubscription");
                while (enumeration.hasMoreElements()) {
                    XElement element = (XElement)enumeration.nextElement();
                    String clientId = element.getField("ClientID");
                    String name = element.getField("Name");
                    String topicName = element.getField("TopicName");
                    String selector = element.getOptionalField("Selector");
                    if (!topic.getName().equals(topicName)) continue;
                    durableSubs.add(new DurableSubscriptionID(clientId, name, selector));
                }
            }
        }
        catch (XElementException e) {
            JMSException jmse = new JMSException("Error in statemanager xml");
            jmse.setLinkedException((Exception)e);
            throw jmse;
        }
        return durableSubs;
    }

    public void addUser(String name, String password, String preconfID) throws Exception {
        if (this.findUser(name) != null) {
            throw new Exception("Can not add, user exist");
        }
        XElement users = this.stateConfig.getElement("Users");
        XElement user = new XElement("User");
        user.addField("Name", name);
        user.addField("Password", password);
        if (preconfID != null) {
            user.addField("Id", preconfID);
        }
        users.addElement(user);
        this.saveConfig();
    }

    public void removeUser(String name) throws Exception {
        XElement user = this.findUser(name);
        if (user == null) {
            throw new Exception("Cant remove user that does not exist");
        }
        user.removeFromParent();
        String[] roles = this.getRoles(name);
        if (roles != null) {
            for (int i = 0; i < roles.length; ++i) {
                try {
                    this.removeUserFromRole(roles[i], name);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        this.saveConfig();
    }

    public void addRole(String name) throws Exception {
        if (this.findRole(name) != null) {
            throw new Exception("Cant add role, it already exists");
        }
        XElement roles = this.stateConfig.getElement("Roles");
        XElement role = new XElement("Role");
        role.setAttribute("name", name);
        roles.addElement(role);
        this.saveConfig();
    }

    public void removeRole(String name) throws Exception {
        XElement role = this.findRole(name);
        if (role == null) {
            throw new Exception("Cant remove role that does not exist");
        }
        role.removeFromParent();
        this.saveConfig();
    }

    public void addUserToRole(String roleName, String user) throws Exception {
        XElement role = this.findRole(roleName);
        if (role == null) {
            throw new Exception("Cant add to role that does not exist");
        }
        if (this.findUser(user) == null) {
            throw new Exception("Cant add user to role, user does to exist");
        }
        if (this.findUserInRole(role, user) != null) {
            throw new Exception("Cant add user to role, user already part of role");
        }
        XElement u = new XElement("UserName");
        u.setValue(user);
        role.addElement(u);
        this.saveConfig();
    }

    public void removeUserFromRole(String roleName, String user) throws Exception {
        XElement role = this.findRole(roleName);
        if (role == null) {
            throw new Exception("Cant remove user from role that does not exist");
        }
        XElement u = this.findUserInRole(role, user);
        if (u == null) {
            throw new Exception("Cant remove user from role, user does not exist");
        }
        u.removeFromParent();
        this.saveConfig();
    }

    protected XElement findUser(String user) throws Exception {
        Enumeration enumeration = this.stateConfig.getElementsNamed("Users/User");
        while (enumeration.hasMoreElements()) {
            XElement element = (XElement)enumeration.nextElement();
            if (!element.getField("Name").equals(user)) continue;
            return element;
        }
        return null;
    }

    protected XElement findRole(String role) throws Exception {
        Enumeration enumeration = this.stateConfig.getElementsNamed("Roles/Role");
        while (enumeration.hasMoreElements()) {
            XElement element = (XElement)enumeration.nextElement();
            if (!element.getAttribute("name").equals(role)) continue;
            return element;
        }
        return null;
    }

    protected XElement findUserInRole(XElement role, String user) throws Exception {
        Enumeration enumeration = role.getElementsNamed("UserName");
        while (enumeration.hasMoreElements()) {
            XElement element = (XElement)enumeration.nextElement();
            if (!user.equals(element.getValue())) continue;
            return element;
        }
        return null;
    }

    public String[] getRoles(String user) throws Exception {
        ArrayList<String> roles = new ArrayList<String>();
        Enumeration enumeration = this.stateConfig.getElementsNamed("Roles/Role");
        while (enumeration.hasMoreElements()) {
            XElement element = (XElement)enumeration.nextElement();
            XElement u = this.findUserInRole(element, user);
            if (u == null) continue;
            roles.add(element.getAttribute("name"));
        }
        return roles.toArray(new String[roles.size()]);
    }

    public boolean validatePassword(String user, String inputPassword) throws Exception {
        boolean valid = false;
        XElement u = this.findUser(user);
        if (u != null) {
            String pw = u.getField("Password");
            if (inputPassword != null && inputPassword.equals(pw)) {
                valid = true;
            }
        }
        return valid;
    }

    class DynamicDurableSubscription
    extends AbstractStateManager.DurableSubscription {
        XElement element;

        public DynamicDurableSubscription(XElement element) throws XElementException {
            super(element.getField("ClientID"), element.getField("Name"), element.getField("TopicName"), element.getOptionalField("Selector"));
            this.element = element;
        }

        XElement getElement() {
            return this.element;
        }
    }
}

