/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.filebrowser.portlet.service;

import fr.gouv.education.foad.filebrowser.portlet.configuration.FileBrowserConfiguration;
import fr.gouv.education.foad.filebrowser.portlet.model.FileBrowserBulkDownloadContent;
import fr.gouv.education.foad.filebrowser.portlet.model.FileBrowserForm;
import fr.gouv.education.foad.filebrowser.portlet.model.FileBrowserItem;
import fr.gouv.education.foad.filebrowser.portlet.model.FileBrowserSort;
import fr.gouv.education.foad.filebrowser.portlet.model.FileBrowserSortCriteria;
import fr.gouv.education.foad.filebrowser.portlet.model.FileBrowserView;
import fr.gouv.education.foad.filebrowser.portlet.model.comparator.FileBrowserItemComparator;
import fr.gouv.education.foad.filebrowser.portlet.repository.FileBrowserRepository;
import fr.gouv.education.foad.filebrowser.portlet.service.FileBrowserService;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.portlet.ActionResponse;
import javax.portlet.MimeResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.ResourceURL;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.dom4j.Element;
import org.jboss.portal.common.invocation.Scope;
import org.jboss.portal.core.controller.ControllerContext;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.cms.impl.BasicPermissions;
import org.osivia.portal.api.cms.impl.BasicPublicationInfos;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.html.AccessibilityRoles;
import org.osivia.portal.api.html.DOM4JUtils;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.urls.PortalUrlType;
import org.osivia.portal.api.user.UserPreferences;
import org.osivia.portal.core.cms.CMSBinaryContent;
import org.osivia.portal.core.context.ControllerContextAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class FileBrowserServiceImpl
implements FileBrowserService {
    private static final String SORT_CRITERIA_ATTRIBUTE = "foad.file-browser.criteria";
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private FileBrowserRepository repository;
    @Autowired
    private IPortalUrlFactory portalUrlFactory;
    @Autowired
    private IBundleFactory bundleFactory;
    @Autowired
    private INotificationsService notificationsService;
    @Autowired
    private DocumentDAO documentDao;

    public FileBrowserView getView(PortalControllerContext portalControllerContext, String viewId) throws PortletException {
        FileBrowserView view;
        if (StringUtils.isEmpty((String)viewId)) {
            NuxeoDocumentContext documentContext = this.repository.getCurrentDocumentContext(portalControllerContext);
            Document document = documentContext.getDoc();
            String webId = document.getString("ttc:webid");
            UserPreferences userPreferences = this.repository.getUserPreferences(portalControllerContext);
            if (userPreferences != null) {
                String savedView = userPreferences.getFolderDisplayMode(webId);
                view = FileBrowserView.fromId((String)savedView);
            } else {
                view = FileBrowserView.DEFAULT;
            }
        } else {
            view = FileBrowserView.fromId((String)viewId);
        }
        return view;
    }

    public void saveView(PortalControllerContext portalControllerContext, FileBrowserView view) throws PortletException {
        NuxeoDocumentContext documentContext = this.repository.getCurrentDocumentContext(portalControllerContext);
        Document document = documentContext.getDoc();
        String webId = document.getString("ttc:webid");
        UserPreferences userPreferences = this.repository.getUserPreferences(portalControllerContext);
        if (userPreferences != null) {
            userPreferences.updateFolderDisplayMode(webId, view.getId());
        }
    }

    public FileBrowserForm getForm(PortalControllerContext portalControllerContext) throws PortletException {
        FileBrowserForm form = (FileBrowserForm)this.applicationContext.getBean(FileBrowserForm.class);
        if (!form.isInitialized()) {
            ArrayList<FileBrowserItem> items;
            NuxeoDocumentContext documentContext = this.repository.getCurrentDocumentContext(portalControllerContext);
            List documents = this.repository.getDocuments(portalControllerContext);
            Set userSubscriptions = this.repository.getUserSubscriptions(portalControllerContext);
            if (CollectionUtils.isEmpty((Collection)documents)) {
                items = null;
            } else {
                items = new ArrayList<FileBrowserItem>(documents.size());
                for (Document document : documents) {
                    FileBrowserItem item = this.createItem(portalControllerContext, document);
                    boolean subscription = userSubscriptions.contains(document.getId());
                    item.setSubscription(subscription);
                    items.add(item);
                }
            }
            form.setItems(items);
            this.sortItems(portalControllerContext, form, FileBrowserSort.TITLE, false);
            boolean uploadable = documentContext.getType() != null && CollectionUtils.isNotEmpty((Collection)documentContext.getType().getPortalFormSubTypes());
            form.setUploadable(uploadable);
            form.setMaxFileSize(FileBrowserConfiguration.MAX_UPLOAD_SIZE_PER_FILE);
            form.setInitialized(true);
        }
        return form;
    }

    private FileBrowserItem createItem(PortalControllerContext portalControllerContext, Document nuxeoDocument) throws PortletException {
        PropertyMap fileContent;
        PortletRequest request = portalControllerContext.getRequest();
        FileBrowserItem item = (FileBrowserItem)this.applicationContext.getBean(FileBrowserItem.class);
        DocumentDTO documentDto = this.documentDao.toDTO(nuxeoDocument);
        item.setDocument(documentDto);
        DocumentType type = documentDto.getType();
        String title = documentDto.getTitle();
        item.setTitle(title);
        String lockOwner = nuxeoDocument.getString("ttc:lockOwner");
        String lockIcon = StringUtils.isEmpty((String)lockOwner) ? null : (StringUtils.equals((String)request.getRemoteUser(), (String)lockOwner) ? "glyphicons glyphicons-user-lock" : "glyphicons glyphicons-lock");
        item.setLock(lockIcon);
        Date lastModification = nuxeoDocument.getDate("dc:modified");
        item.setLastModification(lastModification);
        String lastContributor = nuxeoDocument.getString("dc:lastContributor");
        item.setLastContributor(lastContributor);
        Long size = nuxeoDocument.getLong("common:size");
        item.setSize(size);
        boolean folderish = type != null && type.isFolderish();
        item.setFolderish(folderish);
        if (type != null && type.isFile() && (fileContent = nuxeoDocument.getProperties().getMap("file:content")) != null) {
            String mimeType = fileContent.getString("mime-type");
            item.setMimeType(mimeType);
        }
        if (folderish) {
            List acceptedTypes = type.getPortalFormSubTypes();
            item.setAcceptedTypes(StringUtils.join((Collection)acceptedTypes, (String)","));
        }
        return item;
    }

    public void sortItems(PortalControllerContext portalControllerContext, FileBrowserForm form, FileBrowserSort sort, boolean alt) throws PortletException {
        FileBrowserSortCriteria criteria;
        ControllerContext controllerContext = ControllerContextAdapter.getControllerContext((PortalControllerContext)portalControllerContext);
        if (form.isInitialized()) {
            criteria = (FileBrowserSortCriteria)this.applicationContext.getBean(FileBrowserSortCriteria.class);
            criteria.setSort(sort);
            criteria.setAlt(alt);
            controllerContext.setAttribute(Scope.PRINCIPAL_SCOPE, (Object)SORT_CRITERIA_ATTRIBUTE, (Object)criteria);
        } else {
            Object criteriaAttribute = controllerContext.getAttribute(Scope.PRINCIPAL_SCOPE, (Object)SORT_CRITERIA_ATTRIBUTE);
            if (criteriaAttribute == null || !(criteriaAttribute instanceof FileBrowserSortCriteria)) {
                criteria = (FileBrowserSortCriteria)this.applicationContext.getBean(FileBrowserSortCriteria.class);
                criteria.setSort(sort);
                criteria.setAlt(alt);
            } else {
                criteria = (FileBrowserSortCriteria)criteriaAttribute;
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)form.getItems())) {
            FileBrowserItemComparator comparator = (FileBrowserItemComparator)this.applicationContext.getBean(FileBrowserItemComparator.class, new Object[]{criteria});
            Collections.sort(form.getItems(), comparator);
        }
        form.setCriteria(criteria);
    }

    public Element getToolbar(PortalControllerContext portalControllerContext, List<String> indexes, String viewId) throws PortletException {
        Element container = DOM4JUtils.generateDivElement(null);
        Element toolbar = DOM4JUtils.generateDivElement((String)"btn-toolbar", (AccessibilityRoles)AccessibilityRoles.TOOLBAR);
        container.add(toolbar);
        if (CollectionUtils.isNotEmpty(indexes)) {
            Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
            FileBrowserForm form = this.getForm(portalControllerContext);
            List items = form.getItems();
            ArrayList<FileBrowserItem> selectedItems = new ArrayList<FileBrowserItem>(indexes.size());
            for (String index : indexes) {
                int i = NumberUtils.toInt((String)index, (int)-1);
                if (i <= -1 || i >= items.size()) continue;
                FileBrowserItem item = (FileBrowserItem)items.get(i);
                selectedItems.add(item);
            }
            if (indexes.size() == selectedItems.size()) {
                DocumentDTO documentDto;
                FileBrowserItem item;
                boolean allEditable = true;
                boolean allFile = true;
                FileBrowserView view = this.getView(portalControllerContext, viewId);
                ArrayList<DocumentDTO> selection = new ArrayList<DocumentDTO>(selectedItems.size());
                Iterator iterator = selectedItems.iterator();
                while (iterator.hasNext() && (allEditable || allFile)) {
                    item = (FileBrowserItem)iterator.next();
                    documentDto = item.getDocument();
                    selection.add(documentDto);
                    DocumentType type = documentDto.getType();
                    if (type != null && type.isSupportsPortalForms()) {
                        BasicPermissions permissions = item.getPermissions();
                        if (permissions == null) {
                            permissions = this.repository.getPermissions(portalControllerContext, documentDto.getDocument());
                            item.setPermissions(permissions);
                        }
                        allEditable = allEditable && permissions.isEditableByUser();
                    } else {
                        allEditable = false;
                    }
                    allFile = allFile && type != null && type.isFile();
                }
                if (indexes.size() == 1) {
                    item = (FileBrowserItem)selectedItems.get(0);
                    documentDto = item.getDocument();
                    BasicPermissions permissions = item.getPermissions();
                    if (permissions == null) {
                        permissions = this.repository.getPermissions(portalControllerContext, documentDto.getDocument());
                        item.setPermissions(permissions);
                    }
                    Element liveEditionGroup = this.getToolbarLiveEditionGroup(portalControllerContext, documentDto, permissions, bundle);
                    toolbar.add(liveEditionGroup);
                    Element singleSelectionGroup = this.getToolbarSingleSelectionGroup(portalControllerContext, view, documentDto, permissions, bundle);
                    toolbar.add(singleSelectionGroup);
                } else {
                    Element bulkDownload;
                    if (allFile) {
                        String title = bundle.getString("FILE_BROWSER_TOOLBAR_DOWNLOAD");
                        String url = this.getBulkDownloadUrl(portalControllerContext, selection);
                        bulkDownload = DOM4JUtils.generateLinkElement((String)url, null, null, (String)"btn btn-default btn-sm no-ajax-link", null, (String)"glyphicons glyphicons-download-alt");
                        DOM4JUtils.addAttribute((Element)bulkDownload, (String)"title", (String)title);
                    } else {
                        bulkDownload = DOM4JUtils.generateLinkElement((String)"#", null, null, (String)"btn btn-default btn-sm disabled", null, (String)"glyphicons glyphicons-download-alt");
                    }
                    toolbar.add(bulkDownload);
                }
                Element multipleSelectionGroup = this.getToolbarMultipleSelectionGroup(portalControllerContext, view, selection, allEditable, container, bundle);
                toolbar.add(multipleSelectionGroup);
            }
        }
        return container;
    }

    private Element getToolbarLiveEditionGroup(PortalControllerContext portalControllerContext, DocumentDTO documentDto, BasicPermissions permissions, Bundle bundle) throws PortletException {
        Element dropdownMenu;
        Element dropdownGroup;
        boolean drive;
        BasicPublicationInfos publicationInfos;
        PortletRequest portletRequest = portalControllerContext.getRequest();
        String path = documentDto.getPath();
        DocumentType documentType = documentDto.getType();
        if (permissions.isEditableByUser() && documentType != null && documentType.isFile() && documentType.isLiveEditable()) {
            publicationInfos = this.repository.getPublicationInfos(portalControllerContext, documentDto.getDocument());
            drive = StringUtils.isNotEmpty((String)publicationInfos.getDriveUrl()) || publicationInfos.isDriveEnabled();
        } else {
            publicationInfos = null;
            drive = false;
        }
        Element liveEditionGroup = DOM4JUtils.generateDivElement((String)"btn-group btn-group-sm hidden-xs");
        if (permissions.isEditableByUser() && (documentDto.isLiveEditable() || drive)) {
            dropdownGroup = DOM4JUtils.generateDivElement((String)"btn-group btn-group-sm");
            Element dropdownButton = DOM4JUtils.generateElement((String)"button", (String)"btn btn-default dropdown-toggle", null);
            DOM4JUtils.addAttribute((Element)dropdownButton, (String)"type", (String)"button");
            DOM4JUtils.addDataAttribute((Element)dropdownButton, (String)"toggle", (String)"dropdown");
            dropdownGroup.add(dropdownButton);
            Element dropdownButtonCaret = DOM4JUtils.generateElement((String)"span", (String)"caret", (String)"");
            dropdownButton.add(dropdownButtonCaret);
            dropdownMenu = DOM4JUtils.generateElement((String)"ul", (String)"dropdown-menu dropdown-menu-right", null);
            dropdownGroup.add(dropdownMenu);
        } else {
            dropdownGroup = null;
            dropdownMenu = null;
        }
        if (documentDto.isLiveEditable()) {
            if (permissions.isEditableByUser()) {
                String onlyOfficeTitle = bundle.getString("FILE_BROWSER_TOOLBAR_ONLYOFFICE_TITLE");
                String onlyOfficeWithLockText = bundle.getString("FILE_BROWSER_TOOLBAR_ONLYOFFICE_WITH_LOCK");
                String onlyOfficeWithoutLockText = bundle.getString("FILE_BROWSER_TOOLBAR_ONLYOFFICE_WITHOUT_LOCK");
                String onlyOfficeWithLockUrl = this.getOnlyOfficeUrl(portalControllerContext, path, onlyOfficeTitle, true, true);
                String onlyOfficeWithoutLockUrl = this.getOnlyOfficeUrl(portalControllerContext, path, onlyOfficeWithoutLockText, true, false);
                Element onlyOffice = DOM4JUtils.generateLinkElement((String)onlyOfficeWithLockUrl, null, null, (String)"btn btn-default no-ajax-link", (String)onlyOfficeTitle, (String)"glyphicons glyphicons-pencil");
                liveEditionGroup.add(onlyOffice);
                Element onlyOfficeWithLockDropdownItem = DOM4JUtils.generateElement((String)"li", null, null);
                dropdownMenu.add(onlyOfficeWithLockDropdownItem);
                Element onlyOfficeWithLockLink = DOM4JUtils.generateLinkElement((String)onlyOfficeWithLockUrl, null, null, (String)"no-ajax-link", (String)onlyOfficeWithLockText);
                onlyOfficeWithLockDropdownItem.add(onlyOfficeWithLockLink);
                Element onlyOfficeWithoutLockDropdownItem = DOM4JUtils.generateElement((String)"li", null, null);
                dropdownMenu.add(onlyOfficeWithoutLockDropdownItem);
                Element onlyOfficeWithoutLockLink = DOM4JUtils.generateLinkElement((String)onlyOfficeWithoutLockUrl, null, null, (String)"no-ajax-link", (String)onlyOfficeWithoutLockText);
                onlyOfficeWithoutLockDropdownItem.add(onlyOfficeWithoutLockLink);
            }
            if (StringUtils.isNotEmpty((String)portletRequest.getRemoteUser())) {
                String onlyOfficeReadOnlyTitle = bundle.getString("FILE_BROWSER_TOOLBAR_ONLYOFFICE_READ_ONLY_TITLE");
                String onlyOfficeReadOnlyText = bundle.getString("FILE_BROWSER_TOOLBAR_ONLYOFFICE_READ_ONLY");
                String onlyOfficeReadOnlyUrl = this.getOnlyOfficeUrl(portalControllerContext, path, onlyOfficeReadOnlyTitle, false, false);
                if (permissions.isEditableByUser()) {
                    Element onlyOfficeReadOnlyDropdownItem = DOM4JUtils.generateElement((String)"li", null, null);
                    dropdownMenu.add(onlyOfficeReadOnlyDropdownItem);
                    Element onlyOfficeReadOnlyLink = DOM4JUtils.generateLinkElement((String)onlyOfficeReadOnlyUrl, null, null, (String)"no-ajax-link", (String)onlyOfficeReadOnlyText);
                    onlyOfficeReadOnlyDropdownItem.add(onlyOfficeReadOnlyLink);
                } else {
                    Element onlyOfficeReadOnly = DOM4JUtils.generateLinkElement((String)onlyOfficeReadOnlyUrl, null, null, (String)"btn btn-default no-ajax-link", (String)onlyOfficeReadOnlyText);
                    liveEditionGroup.add(onlyOfficeReadOnly);
                }
            }
        }
        if (drive) {
            if (documentDto.isLiveEditable()) {
                Element divider = DOM4JUtils.generateElement((String)"li", (String)"divider", (String)"");
                dropdownMenu.add(divider);
            }
            if (StringUtils.isNotEmpty((String)publicationInfos.getDriveUrl())) {
                Element driveDropdownItem = DOM4JUtils.generateElement((String)"li", null, null);
                dropdownMenu.add(driveDropdownItem);
                Element driveLink = DOM4JUtils.generateLinkElement((String)publicationInfos.getDriveUrl(), null, null, (String)"no-ajax-link", (String)bundle.getString("FILE_BROWSER_TOOLBAR_DRIVE_EDIT"));
                driveDropdownItem.add(driveLink);
            } else {
                Element warning = DOM4JUtils.generateElement((String)"li", (String)"dropdown-header", (String)bundle.getString("FILE_BROWSER_TOOLBAR_DRIVE_NOT_STARTED_WARNING"));
                dropdownMenu.add(warning);
                Element driveDropdownItem = DOM4JUtils.generateElement((String)"li", (String)"disabled", null);
                dropdownMenu.add(driveDropdownItem);
                Element driveLink = DOM4JUtils.generateLinkElement((String)"#", null, null, null, (String)bundle.getString("FILE_BROWSER_TOOLBAR_DRIVE_EDIT"));
                driveDropdownItem.add(driveLink);
            }
        }
        if (dropdownGroup != null) {
            liveEditionGroup.add(dropdownGroup);
        }
        return liveEditionGroup;
    }

    private Element getToolbarSingleSelectionGroup(PortalControllerContext portalControllerContext, FileBrowserView view, DocumentDTO documentDto, BasicPermissions permissions, Bundle bundle) throws PortletException {
        Element duplicate;
        Element download;
        Element rename;
        Document nuxeoDocument = documentDto.getDocument();
        String path = documentDto.getPath();
        Element group = DOM4JUtils.generateDivElement((String)"btn-group btn-group-sm");
        if (permissions.isEditableByUser()) {
            String title = bundle.getString("FILE_BROWSER_TOOLBAR_RENAME");
            String url = this.getRenameUrl(portalControllerContext, path);
            rename = DOM4JUtils.generateLinkElement((String)"javascript:;", null, null, (String)"btn btn-default no-ajax-link", null, (String)"glyphicons glyphicons-edit");
            DOM4JUtils.addAttribute((Element)rename, (String)"title", (String)title);
            DOM4JUtils.addDataAttribute((Element)rename, (String)"target", (String)"#osivia-modal");
            DOM4JUtils.addDataAttribute((Element)rename, (String)"load-url", (String)url);
        } else {
            rename = DOM4JUtils.generateLinkElement((String)"#", null, null, (String)"btn btn-default disabled", null, (String)"glyphicons glyphicons-edit");
        }
        group.add(rename);
        if (documentDto.getType() != null && documentDto.getType().isFile()) {
            String title = bundle.getString("FILE_BROWSER_TOOLBAR_DOWNLOAD");
            String url = this.repository.getDownloadUrl(portalControllerContext, nuxeoDocument);
            download = DOM4JUtils.generateLinkElement((String)url, (String)"_blank", null, (String)"btn btn-default no-ajax-link", null, (String)"glyphicons glyphicons-download-alt");
            DOM4JUtils.addAttribute((Element)download, (String)"title", (String)title);
        } else {
            download = DOM4JUtils.generateLinkElement((String)"#", null, null, (String)"btn btn-default disabled", null, (String)"glyphicons glyphicons-download-alt");
        }
        group.add(download);
        if (permissions.isCopiable()) {
            String title = bundle.getString("FILE_BROWSER_TOOLBAR_DUPLICATE");
            String url = this.getDuplicateUrl(portalControllerContext, path, view);
            duplicate = DOM4JUtils.generateLinkElement((String)url, null, null, (String)"btn btn-default", null, (String)"glyphicons glyphicons-duplicate");
            DOM4JUtils.addAttribute((Element)duplicate, (String)"title", (String)title);
        } else {
            duplicate = DOM4JUtils.generateLinkElement((String)"#", null, null, (String)"btn btn-default disabled", null, (String)"glyphicons glyphicons-duplicate");
        }
        group.add(duplicate);
        return group;
    }

    private Element getToolbarMultipleSelectionGroup(PortalControllerContext portalControllerContext, FileBrowserView view, List<DocumentDTO> selection, boolean allEditable, Element container, Bundle bundle) throws PortletException {
        Element delete;
        Element move;
        HashSet<String> acceptedTypes;
        ArrayList<String> paths;
        ArrayList<String> identifiers;
        String namespace = portalControllerContext.getResponse().getNamespace();
        String deleteId = namespace + "-delete";
        boolean unknownType = false;
        if (allEditable) {
            identifiers = new ArrayList<String>(selection.size());
            paths = new ArrayList<String>(selection.size());
            acceptedTypes = new HashSet<String>();
            for (DocumentDTO documentDto : selection) {
                String identifier = documentDto.getId();
                identifiers.add(identifier);
                String path = documentDto.getPath();
                paths.add(path);
                String type = documentDto.getType() == null ? null : documentDto.getType().getName();
                if (StringUtils.isEmpty((String)type)) {
                    unknownType = true;
                    continue;
                }
                acceptedTypes.add(type);
            }
        } else {
            identifiers = null;
            paths = null;
            acceptedTypes = null;
        }
        Element group = DOM4JUtils.generateDivElement((String)"btn-group btn-group-sm");
        if (allEditable && !unknownType) {
            String title = bundle.getString("FILE_BROWSER_TOOLBAR_MOVE");
            String url = this.getMoveUrl(portalControllerContext, identifiers, paths, acceptedTypes);
            move = DOM4JUtils.generateLinkElement((String)url, null, null, (String)"btn btn-default fancyframe_refresh no-ajax-link", null, (String)"glyphicons glyphicons-move");
            DOM4JUtils.addAttribute((Element)move, (String)"title", (String)title);
        } else {
            move = DOM4JUtils.generateLinkElement((String)"#", null, null, (String)"btn btn-default disabled", null, (String)"glyphicons glyphicons-move");
        }
        group.add(move);
        if (allEditable) {
            String title = bundle.getString("FILE_BROWSER_TOOLBAR_DELETE");
            delete = DOM4JUtils.generateLinkElement((String)("#" + deleteId), null, null, (String)"btn btn-default no-ajax-link", null, (String)"glyphicons glyphicons-bin");
            DOM4JUtils.addAttribute((Element)delete, (String)"title", (String)title);
            DOM4JUtils.addDataAttribute((Element)delete, (String)"toggle", (String)"modal");
            Element modal = this.getToolbarDeleteModal(portalControllerContext, identifiers, view, deleteId, bundle);
            container.add(modal);
        } else {
            delete = DOM4JUtils.generateLinkElement((String)"#", null, null, (String)"btn btn-default disabled", null, (String)"glyphicons glyphicons-bin");
        }
        group.add(delete);
        return group;
    }

    private String getOnlyOfficeUrl(PortalControllerContext portalControllerContext, String path, String title, boolean edit, boolean lock) throws PortletException {
        String url;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("osivia.cms.uri", path);
        properties.put("osivia.hideTitle", String.valueOf(1));
        properties.put("osivia.onlyoffice.mode", BooleanUtils.toString((boolean)edit, (String)"edit", (String)"view"));
        properties.put("osivia.onlyoffice.withLock", String.valueOf(lock));
        properties.put("osivia.title", title);
        try {
            url = this.portalUrlFactory.getStartPortletUrl(portalControllerContext, "osivia-services-onlyoffice-portletInstance", properties);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        return url;
    }

    private String getRenameUrl(PortalControllerContext portalControllerContext, String path) throws PortletException {
        String url;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("osivia.cms.uri", path);
        properties.put("osivia.rename.document.redirect.path", this.repository.getCurrentPath(portalControllerContext));
        try {
            url = this.portalUrlFactory.getStartPortletUrl(portalControllerContext, "toutatice-portail-cms-nuxeo-rename-portlet-instance", properties, PortalUrlType.MODAL);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        return url;
    }

    private String getDuplicateUrl(PortalControllerContext portalControllerContext, String path, FileBrowserView view) throws PortletException {
        String url;
        PortletResponse portletResponse = portalControllerContext.getResponse();
        if (portletResponse instanceof MimeResponse) {
            MimeResponse mimeResponse = (MimeResponse)portletResponse;
            PortletURL actionUrl = mimeResponse.createActionURL();
            actionUrl.setParameter("javax.portlet.action", "duplicate");
            actionUrl.setParameter("path", path);
            actionUrl.setParameter("view", view.getId());
            url = actionUrl.toString();
        } else {
            url = "#";
        }
        return url;
    }

    private String getBulkDownloadUrl(PortalControllerContext portalControllerContext, List<DocumentDTO> selection) {
        String url;
        PortletResponse portletResponse = portalControllerContext.getResponse();
        if (portletResponse instanceof MimeResponse) {
            MimeResponse mimeResponse = (MimeResponse)portletResponse;
            String[] paths = new String[selection.size()];
            int i = 0;
            for (DocumentDTO documentDto : selection) {
                paths[i] = documentDto.getPath();
                ++i;
            }
            ResourceURL resourceUrl = mimeResponse.createResourceURL();
            resourceUrl.setResourceID("bulk-download");
            resourceUrl.setParameter("paths", paths);
            url = resourceUrl.toString();
        } else {
            url = "#";
        }
        return url;
    }

    private String getMoveUrl(PortalControllerContext portalControllerContext, List<String> identifiers, List<String> paths, Set<String> acceptedTypes) throws PortletException {
        String url;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("osivia.move.documentPath", this.repository.getCurrentPath(portalControllerContext));
        properties.put("osivia.move.documentsIdentifiers", StringUtils.join(identifiers, (String)","));
        properties.put("osivia.move.ignoredPaths", StringUtils.join(paths, (String)","));
        properties.put("osivia.move.cmsBasePath", this.repository.getBasePath(portalControllerContext));
        properties.put("osivia.move.acceptedTypes", StringUtils.join(acceptedTypes, (String)","));
        try {
            url = this.portalUrlFactory.getStartPortletUrl(portalControllerContext, "toutatice-portail-cms-nuxeo-move-portlet-instance", properties, PortalUrlType.POPUP);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        return url;
    }

    private String getDeleteUrl(PortalControllerContext portalControllerContext, List<String> identifiers, FileBrowserView view) throws PortletException {
        String url;
        PortletResponse portletResponse = portalControllerContext.getResponse();
        if (portletResponse instanceof MimeResponse) {
            MimeResponse mimeResponse = (MimeResponse)portletResponse;
            PortletURL actionUrl = mimeResponse.createActionURL();
            actionUrl.setParameter("javax.portlet.action", "delete");
            actionUrl.setParameter("identifiers", StringUtils.join(identifiers, (String)","));
            actionUrl.setParameter("view", view.getId());
            url = actionUrl.toString();
        } else {
            url = "#";
        }
        return url;
    }

    private Element getToolbarDeleteModal(PortalControllerContext portalControllerContext, List<String> identifiers, FileBrowserView view, String id, Bundle bundle) throws PortletException {
        Element modal = DOM4JUtils.generateDivElement((String)"modal fade");
        DOM4JUtils.addAttribute((Element)modal, (String)"id", (String)id);
        Element modalDialog = DOM4JUtils.generateDivElement((String)"modal-dialog");
        modal.add(modalDialog);
        Element modalContent = DOM4JUtils.generateDivElement((String)"modal-content");
        modalDialog.add(modalContent);
        Element modalHeader = DOM4JUtils.generateDivElement((String)"modal-header");
        modalContent.add(modalHeader);
        Element close = DOM4JUtils.generateElement((String)"button", (String)"close", null, (String)"glyphicons glyphicons-remove", null);
        DOM4JUtils.addAttribute((Element)close, (String)"type", (String)"button");
        DOM4JUtils.addDataAttribute((Element)close, (String)"dismiss", (String)"modal");
        modalHeader.add(close);
        Element modalTitle = DOM4JUtils.generateElement((String)"h4", (String)"modal-title", (String)bundle.getString("FILE_BROWSER_TOOLBAR_DELETE_MODAL_TITLE"));
        modalHeader.add(modalTitle);
        Element modalBody = DOM4JUtils.generateDivElement((String)"modal-body");
        modalContent.add(modalBody);
        Element message = DOM4JUtils.generateElement((String)"p", null, (String)bundle.getString("FILE_BROWSER_TOOLBAR_DELETE_MODAL_MESSAGE"));
        modalBody.add(message);
        Element modalFooter = DOM4JUtils.generateDivElement((String)"modal-footer");
        modalContent.add(modalFooter);
        String url = this.getDeleteUrl(portalControllerContext, identifiers, view);
        Element confirm = DOM4JUtils.generateLinkElement((String)url, null, null, (String)"btn btn-warning no-ajax-link", (String)bundle.getString("FILE_BROWSER_TOOLBAR_DELETE"), (String)"glyphicons glyphicons-bin");
        modalFooter.add(confirm);
        Element cancel = DOM4JUtils.generateElement((String)"button", (String)"btn btn-default", (String)bundle.getString("CANCEL"), (String)"glyphicons glyphicons-remove", null);
        DOM4JUtils.addAttribute((Element)cancel, (String)"type", (String)"button");
        DOM4JUtils.addDataAttribute((Element)cancel, (String)"dismiss", (String)"modal");
        modalFooter.add(cancel);
        return modal;
    }

    public void duplicate(PortalControllerContext portalControllerContext, String path) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        PortletResponse response = portalControllerContext.getResponse();
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        try {
            this.repository.duplicate(portalControllerContext, path);
            String message = bundle.getString("FILE_BROWSER_DUPLICATE_SUCCESS_MESSAGE");
            this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
        }
        catch (NuxeoException e) {
            String message = e.getUserMessage(portalControllerContext);
            if (message == null) {
                message = bundle.getString("FILE_BROWSER_DUPLICATE_ERROR_MESSAGE");
            }
            this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.ERROR);
        }
        request.setAttribute("osivia.updateContents", (Object)"true");
        if (response instanceof ActionResponse) {
            ActionResponse actionResponse = (ActionResponse)response;
            actionResponse.setRenderParameter("dnd-update", String.valueOf(System.currentTimeMillis()));
        }
    }

    public void delete(PortalControllerContext portalControllerContext, List<String> identifiers) throws PortletException, IOException {
        PortletRequest request = portalControllerContext.getRequest();
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        try {
            this.repository.delete(portalControllerContext, identifiers);
            String message = bundle.getString("FILE_BROWSER_DELETE_SUCCESS_MESSAGE");
            this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
        }
        catch (NuxeoException e) {
            String message = bundle.getString("FILE_BROWSER_DELETE_ERROR_MESSAGE");
            this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.ERROR);
        }
        request.setAttribute("osivia.updateContents", (Object)"true");
    }

    public FileBrowserBulkDownloadContent getBulkDownload(PortalControllerContext portalControllerContext, List<String> paths) throws PortletException, IOException {
        CMSBinaryContent binaryContent = this.repository.getBinaryContent(portalControllerContext, paths);
        FileBrowserBulkDownloadContent content = (FileBrowserBulkDownloadContent)this.applicationContext.getBean(FileBrowserBulkDownloadContent.class);
        String mimeType = binaryContent.getMimeType();
        content.setType(mimeType);
        StringBuilder disposition = new StringBuilder();
        disposition.append("inline; ");
        disposition.append("filename=\"");
        disposition.append(StringUtils.trimToEmpty((String)binaryContent.getName()));
        disposition.append("\"");
        content.setDisposition(disposition.toString());
        File file = binaryContent.getFile();
        content.setFile(file);
        return content;
    }

    public void drop(PortalControllerContext portalControllerContext, List<String> sourceIdentifiers, String targetIdentifier) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        PortletResponse response = portalControllerContext.getResponse();
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        try {
            this.repository.move(portalControllerContext, sourceIdentifiers, targetIdentifier);
            String message = bundle.getString("FILE_BROWSER_MOVE_SUCCESS_MESSAGE");
            this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
        }
        catch (NuxeoException e) {
            String message = bundle.getString("FILE_BROWSER_MOVE_WARNING_MESSAGE");
            this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.WARNING);
        }
        request.setAttribute("osivia.updateContents", (Object)"true");
        if (response instanceof ActionResponse) {
            ActionResponse actionResponse = (ActionResponse)response;
            actionResponse.setRenderParameter("dnd-update", String.valueOf(System.currentTimeMillis()));
        }
    }

    public void upload(PortalControllerContext portalControllerContext, FileBrowserForm form) throws PortletException, IOException {
        PortletRequest request = portalControllerContext.getRequest();
        PortletResponse response = portalControllerContext.getResponse();
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        List upload = form.getUpload();
        if (CollectionUtils.isNotEmpty((Collection)upload)) {
            try {
                this.repository.importFiles(portalControllerContext, upload);
            }
            catch (NuxeoException e) {
                String message = e.getUserMessage(portalControllerContext);
                if (message == null) {
                    message = bundle.getString("FILE_BROWSER_UPLOAD_ERROR_MESSAGE");
                }
                request.getPortletSession().setAttribute("uploadMsg", (Object)message);
            }
        }
    }

    public void updateMenubar(PortalControllerContext portalControllerContext) throws PortletException {
        this.repository.updateMenubar(portalControllerContext);
    }

    public void endUpload(PortalControllerContext portalControllerContext) throws PortletException {
        NotificationsType type;
        PortletRequest request = portalControllerContext.getRequest();
        PortletResponse response = portalControllerContext.getResponse();
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        request.setAttribute("osivia.updateContents", (Object)"true");
        if (response instanceof ActionResponse) {
            ActionResponse actionResponse = (ActionResponse)response;
            actionResponse.setRenderParameter("dnd-update", String.valueOf(System.currentTimeMillis()));
        }
        String message = (String)request.getPortletSession().getAttribute("uploadMsg");
        request.getPortletSession().removeAttribute("uploadMsg");
        if (StringUtils.isEmpty((String)message)) {
            message = bundle.getString("FILE_BROWSER_UPLOAD_SUCCESS_MESSAGE");
            type = NotificationsType.SUCCESS;
        } else {
            type = NotificationsType.ERROR;
        }
        this.notificationsService.addSimpleNotification(portalControllerContext, message, type);
    }
}

