/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.filebrowser.portlet.repository;

import fr.gouv.education.foad.filebrowser.portlet.repository.FileBrowserRepository;
import fr.gouv.education.foad.filebrowser.portlet.repository.command.CopyDocumentCommand;
import fr.gouv.education.foad.filebrowser.portlet.repository.command.GetFileBrowserDocumentsCommand;
import fr.gouv.education.foad.filebrowser.portlet.repository.command.ImportFilesCommand;
import fr.gouv.education.foad.filebrowser.portlet.repository.command.MoveDocumentsCommand;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cms.EcmDocument;
import org.osivia.portal.api.cms.impl.BasicPermissions;
import org.osivia.portal.api.cms.impl.BasicPublicationInfos;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.api.user.UserPreferences;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSBinaryContent;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.ICMSServiceLocator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Repository;
import org.springframework.web.multipart.MultipartFile;

@Repository
public class FileBrowserRepositoryImpl
implements FileBrowserRepository {
    private static final String ZIP_FILE_NAME_REGEX = "(.+) \\(([0-9]+)\\)";
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ICMSServiceLocator cmsServiceLocator;
    private final Pattern zipFileNamePattern = Pattern.compile("(.+) \\(([0-9]+)\\)");

    public String getCurrentPath(PortalControllerContext portalControllerContext) throws PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        return window.getProperty("osivia.cms.uri");
    }

    public String getBasePath(PortalControllerContext portalControllerContext) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        return nuxeoController.getBasePath();
    }

    public NuxeoDocumentContext getCurrentDocumentContext(PortalControllerContext portalControllerContext) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        String path = this.getCurrentPath(portalControllerContext);
        return nuxeoController.getDocumentContext(path);
    }

    public List<Document> getDocuments(PortalControllerContext portalControllerContext) throws PortletException {
        List documents;
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        String path = this.getCurrentPath(portalControllerContext);
        NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(path);
        Document document = documentContext.getDoc();
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(GetFileBrowserDocumentsCommand.class, new Object[]{document.getId()});
        Object result = nuxeoController.executeNuxeoCommand(command);
        if (result != null && result instanceof Documents) {
            Documents resultDocuments = (Documents)result;
            documents = resultDocuments.list();
        } else {
            documents = null;
        }
        return documents;
    }

    public BasicPublicationInfos getPublicationInfos(PortalControllerContext portalControllerContext, Document document) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(document.getPath());
        return (BasicPublicationInfos)documentContext.getPublicationInfos(BasicPublicationInfos.class);
    }

    public BasicPermissions getPermissions(PortalControllerContext portalControllerContext, Document document) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(document.getPath());
        return (BasicPermissions)documentContext.getPermissions(BasicPermissions.class);
    }

    public Set<String> getUserSubscriptions(PortalControllerContext portalControllerContext) throws PortletException {
        HashSet<String> identifiers;
        List ecmDocuments;
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        CMSServiceCtx cmsContext = new CMSServiceCtx();
        cmsContext.setPortalControllerContext(portalControllerContext);
        try {
            ecmDocuments = cmsService.getUserSubscriptions(cmsContext);
        }
        catch (CMSException e) {
            ecmDocuments = null;
        }
        if (CollectionUtils.isEmpty((Collection)ecmDocuments)) {
            identifiers = new HashSet<String>(0);
        } else {
            identifiers = new HashSet(ecmDocuments.size());
            for (EcmDocument ecmDocument : ecmDocuments) {
                if (!(ecmDocument instanceof Document)) continue;
                Document nuxeoDocument = (Document)ecmDocument;
                identifiers.add(nuxeoDocument.getId());
            }
        }
        return identifiers;
    }

    public UserPreferences getUserPreferences(PortalControllerContext portalControllerContext) throws PortletException {
        UserPreferences userPreferences;
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        CMSServiceCtx cmsContext = new CMSServiceCtx();
        cmsContext.setPortalControllerContext(portalControllerContext);
        try {
            userPreferences = cmsService.getUserPreferences(portalControllerContext);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        return userPreferences;
    }

    public String getDownloadUrl(PortalControllerContext portalControllerContext, Document document) throws PortletException {
        Link link;
        String url;
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        if ("Picture".equals(document.getType())) {
            url = nuxeoController.createPictureLink(document.getPath(), "Original");
            link = new Link(url, false);
        } else {
            link = nuxeoController.getLink(document, "download");
        }
        url = link == null ? "#" : link.getUrl();
        return url;
    }

    public void duplicate(PortalControllerContext portalControllerContext, String sourcePath) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        String targetPath = this.getCurrentPath(portalControllerContext);
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(CopyDocumentCommand.class, new Object[]{sourcePath, targetPath});
        nuxeoController.executeNuxeoCommand(command);
    }

    public void delete(PortalControllerContext portalControllerContext, List<String> identifiers) throws PortletException {
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        CMSServiceCtx cmsContext = new CMSServiceCtx();
        cmsContext.setPortalControllerContext(portalControllerContext);
        for (String identifier : identifiers) {
            try {
                cmsService.putDocumentInTrash(cmsContext, identifier);
            }
            catch (CMSException e) {
                throw new PortletException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMSBinaryContent getBinaryContent(PortalControllerContext portalControllerContext, List<String> paths) throws PortletException, IOException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        nuxeoController.setStreamingSupport(true);
        ArrayList<CMSBinaryContent> contents = new ArrayList<CMSBinaryContent>(paths.size());
        for (String path : paths) {
            CMSBinaryContent content = nuxeoController.fetchFileContent(path, "file:content");
            contents.add(content);
        }
        File zipFile = File.createTempFile("file-browser-bulk-download-", ".tmp");
        zipFile.deleteOnExit();
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(zipFile));
        zipOutputStream.setMethod(0);
        zipOutputStream.setLevel(0);
        CountingOutputStream countingOutputStream = new CountingOutputStream((OutputStream)zipOutputStream);
        HashSet<String> zipFileNames = new HashSet<String>();
        try {
            for (CMSBinaryContent content : contents) {
                String fileName = content.getName();
                while (zipFileNames.contains(fileName)) {
                    int counter;
                    String name = StringUtils.substringBeforeLast((String)fileName, (String)".");
                    String extension = StringUtils.substringAfterLast((String)fileName, (String)".");
                    Matcher matcher = this.zipFileNamePattern.matcher(name);
                    if (matcher.matches()) {
                        name = matcher.group(1);
                        counter = NumberUtils.toInt((String)matcher.group(2), (int)0);
                    } else {
                        counter = 0;
                    }
                    StringBuilder builder = new StringBuilder();
                    builder.append(name);
                    builder.append(" (");
                    builder.append(counter + 1);
                    builder.append(").");
                    builder.append(extension);
                    fileName = builder.toString();
                }
                zipFileNames.add(fileName);
                ZipEntry zipEntry = new ZipEntry(fileName);
                zipEntry.setSize(content.getFileSize());
                zipEntry.setCompressedSize(-1L);
                byte[] buffer = new byte[1000000];
                if (content.getFile() != null) {
                    File file = content.getFile();
                    zipEntry.setTime(file.lastModified());
                    FileInputStream fileInputStream = new FileInputStream(file);
                    CheckedInputStream checkedInputStream = new CheckedInputStream(fileInputStream, new CRC32());
                    try {
                        while (checkedInputStream.read(buffer) >= 0) {
                        }
                        zipEntry.setCrc(checkedInputStream.getChecksum().getValue());
                        zipOutputStream.putNextEntry(zipEntry);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)checkedInputStream);
                    }
                    fileInputStream = new FileInputStream(file);
                    try {
                        int i = -1;
                        while ((i = fileInputStream.read(buffer)) != -1) {
                            countingOutputStream.write(buffer, 0, i);
                        }
                        countingOutputStream.flush();
                        continue;
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)fileInputStream);
                        continue;
                    }
                }
                if (content.getStream() == null) continue;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                CheckedInputStream checkedInputStream = new CheckedInputStream(content.getStream(), new CRC32());
                try {
                    int i = -1;
                    while ((i = checkedInputStream.read(buffer)) != -1) {
                        byteArrayOutputStream.write(buffer, 0, i);
                    }
                    zipEntry.setCrc(checkedInputStream.getChecksum().getValue());
                    zipOutputStream.putNextEntry(zipEntry);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)checkedInputStream);
                }
                try {
                    byteArrayOutputStream.writeTo((OutputStream)countingOutputStream);
                    countingOutputStream.flush();
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)byteArrayOutputStream);
                }
            }
        }
        finally {
            IOUtils.closeQuietly((OutputStream)countingOutputStream);
        }
        CMSBinaryContent zipBinaryContent = new CMSBinaryContent();
        zipBinaryContent.setName("export.zip");
        zipBinaryContent.setFile(zipFile);
        zipBinaryContent.setMimeType("application/zip");
        zipBinaryContent.setFileSize(Long.valueOf(countingOutputStream.getByteCount()));
        return zipBinaryContent;
    }

    public void move(PortalControllerContext portalControllerContext, List<String> sourceIdentifiers, String targetIdentifier) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(MoveDocumentsCommand.class, new Object[]{sourceIdentifiers, targetIdentifier});
        nuxeoController.executeNuxeoCommand(command);
    }

    public void importFiles(PortalControllerContext portalControllerContext, List<MultipartFile> upload) throws PortletException, IOException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        String path = this.getCurrentPath(portalControllerContext);
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(ImportFilesCommand.class, new Object[]{path, upload});
        nuxeoController.executeNuxeoCommand(command);
    }

    public void updateMenubar(PortalControllerContext portalControllerContext) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        String path = this.getCurrentPath(portalControllerContext);
        NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(path);
        Document document = documentContext.getDoc();
        nuxeoController.setCurrentDoc(document);
        nuxeoController.insertContentMenuBarItems();
    }
}

