/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.generator.repository;

import fr.gouv.education.foad.generator.model.Configuration;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import io.codearte.jfairy.Fairy;
import java.io.File;
import java.net.URL;
import java.util.Random;
import org.apache.log4j.Logger;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.PathRef;
import org.nuxeo.ecm.automation.client.model.PropertyMap;

public class GenerateCommand
implements INuxeoCommand {
    private static Logger LOGGER = Logger.getLogger(GenerateCommand.class);
    private final Configuration configuration;
    private String path;
    private String space_prefix;
    private Fairy fairy;
    private URL realPath;

    public GenerateCommand(Configuration configuration, String path, String space_prefix, Fairy fairy, URL exampleFile) {
        this.configuration = configuration;
        this.path = path;
        this.space_prefix = space_prefix;
        this.fairy = fairy;
        this.realPath = exampleFile;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        DocumentService documentService = (DocumentService)nuxeoSession.getAdapter(DocumentService.class);
        Document docRoot = documentService.getDocument((DocRef)new PathRef(this.path));
        Random random = new Random();
        int folderId = 0;
        int fileId = 0;
        for (int i = 0; i < this.configuration.getNbOfRootFolers(); ++i) {
            Document folder = this.createFolder(documentService, docRoot, random, Integer.toString(folderId));
            ++folderId;
            for (int j = 0; j < this.configuration.getNbOfSubFolers(); ++j) {
                Document subfolder = this.createFolder(documentService, folder, random, Integer.toString(folderId));
                ++folderId;
                for (int k = 0; k < this.configuration.getNbOfSubItems(); ++k) {
                    this.createFile(documentService, random, subfolder, Integer.toString(fileId));
                    ++fileId;
                }
            }
            for (int k = 0; k < this.configuration.getNbOfSubItems(); ++k) {
                this.createFile(documentService, random, folder, Integer.toString(fileId));
                ++fileId;
            }
        }
        return null;
    }

    private void createFile(DocumentService documentService, Random random, Document folder, String id) throws Exception {
        PropertyMap properties = new PropertyMap();
        properties.set("dc:title", "fichier-tmc-" + this.space_prefix + "-" + id);
        String user = "utilisateur-" + this.space_prefix + "-" + random.nextInt(this.configuration.getNbOfUsersPerWks()) + "@example.org";
        properties.set("dc:creator", user);
        if (random.nextInt(2) % 2 == 0) {
            LOGGER.debug((Object)("Create note fichier-tmc-" + this.space_prefix + "-" + id));
            properties.set("note:note", this.fairy.textProducer().latinWord(12));
            documentService.createDocument((DocRef)folder, "Note", "fichier-tmc-" + this.space_prefix + "-" + id, properties);
        } else {
            LOGGER.debug((Object)("Create file fichier-tmc-" + this.space_prefix + "-" + id));
            Document file = documentService.createDocument((DocRef)folder, "File", "fichier-tmc-" + this.space_prefix + "-" + id, properties);
            FileBlob attachmentBlob = new FileBlob(new File(this.realPath.getFile()));
            documentService.setBlob((DocRef)file, (Blob)attachmentBlob, "file:content");
        }
    }

    private Document createFolder(DocumentService documentService, Document docRoot, Random random, String id) throws Exception {
        LOGGER.info((Object)("Create folder dossier-tmc-" + this.space_prefix + "-" + id));
        PropertyMap properties = new PropertyMap();
        properties.set("dc:title", "dossier-tmc-" + this.space_prefix + "-" + id);
        String user = "utilisateur-" + this.space_prefix + "-" + random.nextInt(this.configuration.getNbOfUsersPerWks()) + "@example.org";
        properties.set("dc:creator", user);
        Document folder = documentService.createDocument((DocRef)docRoot, "Folder", "dossier-tmc-" + this.space_prefix + "-" + id, properties);
        return folder;
    }

    public String getId() {
        return "generator" + this.space_prefix;
    }
}

