/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.generator.repository;

import fr.gouv.education.foad.generator.model.Configuration;
import fr.gouv.education.foad.generator.repository.GenerateCommand;
import fr.gouv.education.foad.generator.repository.GeneratorRepository;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import io.codearte.jfairy.Fairy;
import io.codearte.jfairy.producer.person.PersonProperties;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import javax.naming.NamingException;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;
import org.osivia.directory.v2.model.ext.WorkspaceRole;
import org.osivia.directory.v2.service.PersonUpdateService;
import org.osivia.directory.v2.service.WorkspaceService;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.workspace.edition.portlet.model.WorkspaceEditionForm;
import org.osivia.services.workspace.edition.portlet.service.WorkspaceEditionService;
import org.osivia.services.workspace.portlet.model.WorkspaceCreationForm;
import org.osivia.services.workspace.portlet.service.WorkspaceCreationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class GeneratorRepositoryImpl
implements GeneratorRepository {
    private static Logger LOGGER = Logger.getLogger(GeneratorRepositoryImpl.class);
    private static final String PROPERTIES_FILE_NAME = "generator.properties";
    private static final String NB_WORKSPACES_PROPERTY = "generator.nbOfworkspaces";
    private static final String NB_USERS = "generator.nbOfUsersPerWks";
    private static final String NB_FOLDERS = "generator.nbOfRootFolers";
    private static final String NB_SUBFOLDERS = "generator.nbOfSubFolers";
    private static final String NB_SUBITEMS = "generator.nbOfSubItems";
    private final Properties properties = new Properties();
    @Autowired
    private PersonUpdateService personService;
    @Autowired
    private WorkspaceService workspaceService;
    @Autowired
    private WorkspaceCreationService workspaceCreationService;
    @Autowired
    private WorkspaceEditionService workspaceEditionService;

    public GeneratorRepositoryImpl() throws IOException, NamingException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(PROPERTIES_FILE_NAME);
        if (inputStream == null) {
            throw new FileNotFoundException(PROPERTIES_FILE_NAME);
        }
        this.properties.load(inputStream);
    }

    public Configuration getConfiguration(PortalControllerContext portalControllerContext) throws PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        int nbOfworkspaces = NumberUtils.toInt((String)StringUtils.defaultIfEmpty((String)window.getProperty(NB_WORKSPACES_PROPERTY), (String)this.properties.getProperty(NB_WORKSPACES_PROPERTY)));
        int nbOfUsers = NumberUtils.toInt((String)StringUtils.defaultIfEmpty((String)window.getProperty(NB_USERS), (String)this.properties.getProperty(NB_USERS)));
        int nbOfRootFolers = NumberUtils.toInt((String)StringUtils.defaultIfEmpty((String)window.getProperty(NB_FOLDERS), (String)this.properties.getProperty(NB_FOLDERS)));
        int nbOfSubFolers = NumberUtils.toInt((String)StringUtils.defaultIfEmpty((String)window.getProperty(NB_SUBFOLDERS), (String)this.properties.getProperty(NB_SUBFOLDERS)));
        int nbOfSubItems = NumberUtils.toInt((String)StringUtils.defaultIfEmpty((String)window.getProperty(NB_SUBITEMS), (String)this.properties.getProperty(NB_SUBITEMS)));
        Configuration configuration = new Configuration();
        configuration.setNbOfworkspaces(Integer.valueOf(nbOfworkspaces));
        configuration.setNbOfUsersPerWks(Integer.valueOf(nbOfUsers));
        configuration.setNbOfRootFolers(Integer.valueOf(nbOfRootFolers));
        configuration.setNbOfSubFolers(Integer.valueOf(nbOfSubFolers));
        configuration.setNbOfSubItems(Integer.valueOf(nbOfSubItems));
        return configuration;
    }

    public void setConfiguration(PortalControllerContext portalControllerContext, Configuration configuration) throws PortletException {
        if (configuration.getNbOfworkspaces() == null) {
            configuration.setNbOfworkspaces(Integer.valueOf(NumberUtils.toInt((String)this.properties.getProperty(NB_WORKSPACES_PROPERTY))));
        }
        if (configuration.getNbOfUsersPerWks() == null) {
            configuration.setNbOfUsersPerWks(Integer.valueOf(NumberUtils.toInt((String)this.properties.getProperty(NB_USERS))));
        }
        if (configuration.getNbOfRootFolers() == null) {
            configuration.setNbOfRootFolers(Integer.valueOf(NumberUtils.toInt((String)this.properties.getProperty(NB_FOLDERS))));
        }
        if (configuration.getNbOfSubFolers() == null) {
            configuration.setNbOfSubFolers(Integer.valueOf(NumberUtils.toInt((String)this.properties.getProperty(NB_SUBFOLDERS))));
        }
        if (configuration.getNbOfSubItems() == null) {
            configuration.setNbOfSubItems(Integer.valueOf(NumberUtils.toInt((String)this.properties.getProperty(NB_SUBITEMS))));
        }
    }

    public void generate(PortalControllerContext portalControllerContext) throws PortletException {
        URL exampleFile = this.getClass().getResource("/WEB-INF/classes/example.doc");
        Configuration configuration = this.getConfiguration(portalControllerContext);
        NuxeoController nuxeoController = this.getNuxeoController(portalControllerContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
        nuxeoController.setAsynchronousCommand(false);
        Locale locale = nuxeoController.getRequest().getLocale();
        Fairy fairy = Fairy.create((Locale)locale);
        for (int i = 0; i < configuration.getNbOfworkspaces(); ++i) {
            LOGGER.info((Object)("creating space  " + Integer.toString(i)));
            Person owner = this.createUser(portalControllerContext, fairy, i, 0);
            String workspaceId = "espace-tmc-" + Integer.toString(i);
            WorkspaceCreationForm form = new WorkspaceCreationForm();
            form.setTitle(workspaceId);
            form.setDescription(workspaceId);
            form.setOwner(owner.getUid());
            this.workspaceCreationService.create(portalControllerContext, form);
            WorkspaceRole[] roles = WorkspaceRole.values();
            int rolesSize = roles.length;
            Random random = new Random();
            for (int j = 1; j < configuration.getNbOfUsersPerWks(); ++j) {
                Person createUser = this.createUser(portalControllerContext, fairy, i, j);
                LOGGER.debug((Object)("Adding user  " + createUser.getCn() + " in " + workspaceId));
                this.workspaceService.addOrModifyMember(workspaceId, createUser.getDn(), roles[random.nextInt(rolesSize)]);
            }
            nuxeoController.executeNuxeoCommand((INuxeoCommand)new GenerateCommand(configuration, "/default-domain/workspaces/espace-tmc-" + Integer.toString(i) + "/documents", Integer.toString(i), fairy, exampleFile));
        }
    }

    private Person createUser(PortalControllerContext portalControllerContext, Fairy fairy, int i, int j) {
        LOGGER.debug((Object)("creating user  " + Integer.toString(i) + "-" + Integer.toString(j)));
        Person owner = this.personService.getEmptyPerson();
        String uid = "utilisateur-" + Integer.toString(i) + "-" + Integer.toString(j) + "@example.org";
        owner.setUid(uid);
        owner.setMail(uid);
        io.codearte.jfairy.producer.person.Person personGen = fairy.person(new PersonProperties.PersonProperty[0]);
        owner.setSn(personGen.firstName());
        owner.setGivenName(personGen.lastName());
        owner.setDisplayName(personGen.firstName() + " " + personGen.lastName());
        owner.setCn(personGen.lastName() + " " + personGen.firstName());
        if (personGen.isMale()) {
            owner.setTitle("M.");
        } else {
            owner.setTitle("Mme.");
        }
        this.personService.create(owner);
        this.personService.updatePassword(owner, "tmc");
        HashMap<String, String> nxproperties = new HashMap<String, String>();
        nxproperties.put("ttc_userprofile:terms_of_use_agreement", "1");
        try {
            this.personService.update(portalControllerContext, owner, null, nxproperties);
        }
        catch (PortalException e) {
            LOGGER.error((Object)"error cgu");
        }
        return owner;
    }

    public void purge(PortalControllerContext portalControllerContext) throws PortletException {
        Configuration configuration = this.getConfiguration(portalControllerContext);
        NuxeoController nuxeoController = this.getNuxeoController(portalControllerContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
        nuxeoController.setAsynchronousCommand(false);
        for (int i = 0; i < configuration.getNbOfworkspaces(); ++i) {
            try {
                LOGGER.info((Object)("deleting space  " + Integer.toString(i)));
                NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext("/default-domain/workspaces/espace-tmc-" + Integer.toString(i));
                if (documentContext.getDoc() == null) continue;
                WorkspaceEditionForm form = new WorkspaceEditionForm(documentContext.getDoc());
                this.workspaceEditionService.delete(portalControllerContext, form);
                continue;
            }
            catch (NuxeoException e) {
                LOGGER.warn((Object)("error deleting space number " + Integer.toString(i)));
            }
        }
        Person personsToDeleteQuery = this.personService.getEmptyPerson();
        String uid = "utilisateur-*";
        personsToDeleteQuery.setUid(uid);
        List personsToDelete = this.personService.findByCriteria(personsToDeleteQuery);
        while (!personsToDelete.isEmpty()) {
            for (Person p : personsToDelete) {
                LOGGER.warn((Object)("deleting " + p.getUid()));
                this.personService.delete(p);
            }
            personsToDelete = this.personService.findByCriteria(personsToDeleteQuery);
        }
    }

    private NuxeoController getNuxeoController(PortalControllerContext portalControllerContext) {
        PortletRequest request = portalControllerContext.getRequest();
        PortletResponse response = portalControllerContext.getResponse();
        PortletContext portletContext = portalControllerContext.getPortletCtx();
        return new NuxeoController(request, response, portletContext);
    }
}

