/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.integrity.service;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class GetProceduresInstancesCommand
implements INuxeoCommand {
    public static final String PAGE_SIZE = "200";
    private final String modelId;
    private final String step;
    private String uid;
    private Date referenceDate;

    public GetProceduresInstancesCommand(String step, String modelId, String uid) {
        this.step = step;
        this.modelId = modelId;
        this.uid = uid;
    }

    public GetProceduresInstancesCommand(String step, String modelId, Date referenceDate) {
        this.step = step;
        this.modelId = modelId;
        this.referenceDate = referenceDate;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        StringBuilder clause = new StringBuilder();
        clause.append("ecm:primaryType = 'ProcedureInstance' ");
        if (this.modelId != null) {
            clause.append(" AND pi:procedureModelWebId = 'procedure_" + this.modelId + "' ");
        }
        if (this.step != null) {
            clause.append(" AND pi:currentStep = '").append(this.step).append("' ");
        }
        if (this.uid != null) {
            clause.append(" AND pi:globalVariablesValues.").append("uid").append(" IN (");
            clause.append("'").append(this.uid).append("')");
        }
        if (this.referenceDate != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-dd");
            clause.append("AND dc:modified <= DATE '" + sdf.format(this.referenceDate) + "' ");
        }
        clause.append(" ORDER BY dc:created");
        String filteredClause = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)NuxeoQueryFilterContext.CONTEXT_LIVE, (String)clause.toString());
        OperationRequest request = nuxeoSession.newRequest("Document.QueryES");
        request.set("X-NXDocumentProperties", (Object)"dublincore, procedureInstance");
        request.set("query", (Object)("SELECT * FROM Document WHERE " + filteredClause));
        request.set("pageSize", (Object)PAGE_SIZE);
        request.set("currentPageIndex", (Object)0);
        return request.execute();
    }

    public String getId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("/");
        if (this.step != null) {
            builder.append(this.step);
        }
        builder.append("/");
        return builder.toString();
    }
}

