/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.room.controller;

import fr.gouv.education.foad.room.controller.RoomMigForm;
import fr.gouv.education.foad.room.controller.RoomMigration;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;

public class AnalyzeRoomsCommand
implements INuxeoCommand {
    private Log log = LogFactory.getLog((String)"org.osivia.directory.v2");
    public static final String FILTER_NOT_IN_TRASH = " AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted'";
    private String wsPath;
    private RoomMigForm form;

    public AnalyzeRoomsCommand(String wsPath, RoomMigForm form) {
        this.wsPath = wsPath;
        this.form = form;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        OperationRequest request = nuxeoSession.newRequest("Document.QueryES");
        request.set("query", (Object)("SELECT * FROM Document WHERE ecm:primaryType = 'Room' AND ecm:path STARTSWITH '" + this.wsPath + "' " + FILTER_NOT_IN_TRASH));
        request.set("pageSize", (Object)1000);
        request.set("currentPageIndex", (Object)0);
        Documents rooms = (Documents)request.execute();
        this.log.info((Object)(rooms.size() + " salle(s) trouv\u00e9e(s)."));
        ArrayList<RoomMigration> lrm = new ArrayList<RoomMigration>();
        Integer maxLevelOfPath = 0;
        Integer nbRooms = 0;
        for (Document room : rooms) {
            String[] split = room.getPath().split("/");
            int levelOfPath = split.length;
            if (levelOfPath > maxLevelOfPath) {
                maxLevelOfPath = levelOfPath;
            }
            String id = room.getId();
            RoomMigration rm = new RoomMigration();
            rm.setId(id);
            rm.setLevelOfPath(levelOfPath);
            rm.setDocument(room);
            lrm.add(rm);
            Integer n = nbRooms;
            Integer n2 = nbRooms = Integer.valueOf(nbRooms + 1);
        }
        this.form.setNbRooms(nbRooms);
        this.testRoom(nuxeoSession, lrm);
        return lrm;
    }

    private void testRoom(Session nuxeoSession, List<RoomMigration> lrm) throws Exception {
        this.log.info((Object)"= Phase 1 - recherche des dossiers \u00e0 extraire.");
        Integer nbRoomsInError = 0;
        for (RoomMigration rm : lrm) {
            this.log.info((Object)("Analyse de la salle  " + rm.getRoom().getTitle() + " . Niveau : " + rm.getLevelOfPath()));
            OperationRequest request = nuxeoSession.newRequest("Document.QueryES");
            request.set("query", (Object)("SELECT * FROM Document WHERE ecm:primaryType IN ('Folder','Note') AND ecm:parentId = '" + rm.getId() + "' " + FILTER_NOT_IN_TRASH));
            Documents rootFolders = (Documents)request.execute();
            if (rootFolders.size() == 0) {
                this.log.info((Object)" La salle ne contient pas de dossier document, un dossier vide sera cr\u00e9\u00e9.");
            } else {
                for (Document rootFolder : rootFolders) {
                    this.log.info((Object)(" La salle contient " + rootFolder.getTitle() + " (" + rootFolder.getType() + ") \u00e0 migrer."));
                }
            }
            request = nuxeoSession.newRequest("Document.QueryES");
            request.set("query", (Object)("SELECT * FROM Document WHERE ecm:primaryType NOT IN ( 'File','Folder','Audio','Video','Note','Staple', 'Room') AND ecm:parentId = '" + rm.getId() + "' " + FILTER_NOT_IN_TRASH));
            Documents docsToWarn = (Documents)request.execute();
            if (docsToWarn.size() <= 0) continue;
            for (Document docToWarn : docsToWarn) {
                this.log.info((Object)(" La salle contient un document " + docToWarn.getTitle() + " (" + docToWarn.getType() + ") qui sera d\u00e9plac\u00e9 dans l'espace parent."));
            }
            rm.setMiscDocs(docsToWarn);
        }
        this.form.setNbRoomsInError(nbRoomsInError);
    }

    public String getId() {
        return null;
    }
}

