/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.bns.batch;

import fr.gouv.education.foad.bns.batch.GetUserProfileCommand;
import fr.gouv.education.foad.bns.batch.RemoveUserProfile;
import fr.gouv.education.foad.bns.controller.BnsRepareForm;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.batch.NuxeoBatch;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.Name;
import javax.portlet.PortletContext;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.directory.v2.model.CollabProfile;
import org.osivia.directory.v2.model.ext.WorkspaceGroupType;
import org.osivia.directory.v2.service.PersonUpdateService;
import org.osivia.directory.v2.service.WorkspaceService;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.model.Person;

public class BnsRepareBatch
extends NuxeoBatch {
    private static final Log logger = LogFactory.getLog((String)"org.osivia.directory.v2");
    private static PortletContext portletContext;
    private BnsRepareForm form;
    private PersonUpdateService personService = (PersonUpdateService)DirServiceFactory.getService(PersonUpdateService.class);
    private WorkspaceService workspaceService = (WorkspaceService)DirServiceFactory.getService(WorkspaceService.class);
    private CSVPrinter rejectsPrinter;

    public BnsRepareBatch(BnsRepareForm form) {
        super(form.getTemporaryFile().getName());
        this.form = form;
    }

    public String getJobScheduling() {
        return null;
    }

    public void execute(Map<String, Object> parameters) throws PortalException {
        logger.warn((Object)("Fire extraction of : " + this.form.getTemporaryFile().getAbsolutePath()));
        try {
            CSVParser parser = CSVParser.parse((File)this.form.getTemporaryFile(), (Charset)StandardCharsets.UTF_8, (CSVFormat)CSVFormat.EXCEL);
            boolean hasRejects = false;
            int count = 1;
            for (CSVRecord record : parser) {
                String uid = record.get(0);
                if (StringUtils.isNotBlank((String)uid)) {
                    logger.info((Object)("Repare " + record.get(0) + " line " + count));
                    Person person = this.personService.getPerson(uid);
                    if (person == null) {
                        logger.info((Object)("uid " + uid + " not found"));
                    } else {
                        String uidInDirectory;
                        String uidLowerCase = StringUtils.lowerCase((String)uid);
                        if (!uidLowerCase.equals(uidInDirectory = person.getUid())) {
                            try {
                                GetUserProfileCommand command = new GetUserProfileCommand(uid);
                                Document nxprofile = (Document)this.getNuxeoController().executeNuxeoCommand((INuxeoCommand)command);
                                int lastIndexOf = StringUtils.lastIndexOf((String)nxprofile.getPath(), (String)"/");
                                String userworkspacePath = nxprofile.getPath().substring(0, lastIndexOf);
                                RemoveUserProfile removeCommand = new RemoveUserProfile(userworkspacePath);
                                this.getNuxeoController().executeNuxeoCommand((INuxeoCommand)removeCommand);
                                CollabProfile collab = this.workspaceService.getEmptyProfile();
                                ArrayList<Name> uniqueMember = new ArrayList<Name>();
                                uniqueMember.add(person.getDn());
                                collab.setType(WorkspaceGroupType.security_group);
                                collab.setUniqueMember(uniqueMember);
                                List findByCriteria = this.workspaceService.findByCriteria(collab);
                                for (CollabProfile profile : findByCriteria) {
                                    this.workspaceService.removeMember(profile.getWorkspaceId(), person.getDn());
                                }
                                this.personService.delete(person);
                                person.setUid(uidLowerCase);
                                this.personService.create(person);
                                for (CollabProfile profile : findByCriteria) {
                                    this.workspaceService.addOrModifyMember(profile.getWorkspaceId(), person.getDn(), profile.getRole());
                                }
                            }
                            catch (Exception e) {
                                logger.info((Object)("Rejected  " + record.get(0)));
                                this.rejectsPrinter = this.getRejectPrinter();
                                this.rejectsPrinter.printRecord(new Object[]{uid});
                                hasRejects = true;
                            }
                        } else {
                            logger.info((Object)("uid " + uid + " is alredy in lowercase"));
                        }
                    }
                }
                ++count;
            }
            if (hasRejects) {
                this.rejectsPrinter.flush();
                this.rejectsPrinter.close();
            }
        }
        catch (IOException e) {
            throw new PortalException((Exception)e);
        }
    }

    private CSVPrinter getRejectPrinter() throws IOException {
        if (this.rejectsPrinter == null) {
            File rejects = new File(this.form.getTemporaryFile().getAbsolutePath() + "_rejects");
            rejects.createNewFile();
            this.rejectsPrinter = new CSVPrinter((Appendable)new FileWriter(rejects), CSVFormat.EXCEL);
        }
        return this.rejectsPrinter;
    }

    public void setPortletContext(PortletContext portletContext) {
        BnsRepareBatch.portletContext = portletContext;
    }

    protected PortletContext getPortletContext() {
        return portletContext;
    }
}

