/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.bns.controller;

import fr.gouv.education.foad.bns.batch.BnsImportBatch;
import fr.gouv.education.foad.bns.batch.BnsRepareBatch;
import fr.gouv.education.foad.bns.controller.BnsImportForm;
import fr.gouv.education.foad.bns.controller.BnsRepareForm;
import fr.gouv.education.foad.bns.controller.GetDuplicatesCommand;
import fr.gouv.education.foad.bns.controller.RepareDuplicateCommand;
import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.batch.AbstractBatch;
import org.osivia.portal.api.batch.IBatchService;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.NotificationsType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;

@Controller
@RequestMapping(value={"VIEW"})
@SessionAttributes(value={"form"})
public class BnsImportController
extends CMSPortlet
implements PortletConfigAware,
PortletContextAware {
    private Log log = LogFactory.getLog((String)"org.osivia.directory.v2");
    private PortletConfig portletConfig;
    private PortletContext portletContext;
    @Autowired
    protected IBundleFactory bundleFactory;
    @Autowired
    protected INotificationsService notificationsService;
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    private IBatchService batchService;

    @PostConstruct
    public void postConstruct() throws PortletException {
        super.init(this.portletConfig);
    }

    @PreDestroy
    public void preDestroy() {
        super.destroy();
    }

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response) {
        return "view";
    }

    @ExceptionHandler
    public String exceptionHandler(PortletRequest request, PortletResponse response) throws PortletException {
        return "error";
    }

    @ActionMapping(value="executeImport")
    public void executeImport(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") BnsImportForm form) throws PortletException, IOException, ParseException, PortalException {
        MultipartFile upload = form.getFile().getUpload();
        File temporaryFile = File.createTempFile("bns-", ".tmp");
        temporaryFile.deleteOnExit();
        upload.transferTo(temporaryFile);
        form.setTemporaryFile(temporaryFile);
        BnsImportBatch batch = new BnsImportBatch(form);
        batch.setPortletContext(this.portletContext);
        this.batchService.addBatch((AbstractBatch)batch);
        PortalControllerContext pcc = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.getNotificationsService().addSimpleNotification(pcc, "Batch programm\u00e9", NotificationsType.SUCCESS);
    }

    @ActionMapping(value="detectDuplicate")
    public void detectDuplicate(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") BnsImportForm form) throws PortalException {
        PortalControllerContext pcc = new PortalControllerContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
        NuxeoController controller = new NuxeoController(pcc);
        GetDuplicatesCommand command = new GetDuplicatesCommand(form.getDuplicatePath());
        Blob json = (Blob)controller.executeNuxeoCommand((INuxeoCommand)command);
        try {
            if (json != null) {
                this.log.warn((Object)("directory : " + form.getDuplicatePath() + (form.isTestOnly() ? " (test only)" : "")));
                String jsonStr = IOUtils.toString((InputStream)json.getStream(), (String)"UTF-8");
                JSONObject duplicates = JSONObject.fromObject((Object)jsonStr);
                JSONArray docs = duplicates.getJSONArray("docs");
                for (int i = 0; i < docs.size(); ++i) {
                    JSONObject jsonobject = docs.getJSONObject(i);
                    String path = jsonobject.getString("path");
                    String count = jsonobject.getString("count");
                    this.log.warn((Object)(i + " " + path + " => " + count));
                    if (form.isTestOnly()) continue;
                    controller.executeNuxeoCommand((INuxeoCommand)new RepareDuplicateCommand(path));
                }
            }
        }
        catch (IOException e) {
            throw new PortalException((Exception)e);
        }
    }

    @ModelAttribute(value="form")
    public BnsImportForm getForm() {
        BnsImportForm form = new BnsImportForm();
        form.setDuplicatePath("/default-domain/workspaces/bnsujet");
        return form;
    }

    @ModelAttribute(value="repareform")
    public BnsRepareForm getRepareForm() {
        BnsRepareForm form = new BnsRepareForm();
        return form;
    }

    @ActionMapping(value="repareAccounts")
    public void repareAccounts(ActionRequest request, ActionResponse response, @ModelAttribute(value="repareform") BnsRepareForm form) throws PortletException, IOException, ParseException, PortalException {
        MultipartFile upload = form.getFile().getUpload();
        File temporaryFile = File.createTempFile("bnsrepare-", ".tmp");
        temporaryFile.deleteOnExit();
        upload.transferTo(temporaryFile);
        form.setTemporaryFile(temporaryFile);
        BnsRepareBatch batch = new BnsRepareBatch(form);
        batch.setPortletContext(this.portletContext);
        this.batchService.addBatch((AbstractBatch)batch);
        PortalControllerContext pcc = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.getNotificationsService().addSimpleNotification(pcc, "Batch programm\u00e9", NotificationsType.SUCCESS);
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }
}

