/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.bns.controller;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.IdRef;
import org.nuxeo.ecm.automation.client.model.PathRef;

public class RepareDuplicateCommand
implements INuxeoCommand {
    private Log log = LogFactory.getLog((String)"org.osivia.directory.v2");
    private String path;

    public RepareDuplicateCommand(String path) {
        this.path = path;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        OperationRequest request = nuxeoSession.newRequest("Document.QueryES");
        request.set("query", (Object)("SELECT * FROM Document WHERE ecm:path ='" + this.path + "'  AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted'"));
        Documents duplicates = (Documents)request.execute();
        DocumentService documentService = (DocumentService)nuxeoSession.getAdapter(DocumentService.class);
        for (Document duplicate : duplicates) {
            try {
                this.log.warn((Object)("Repare " + this.path + " (" + duplicate.getId() + ")"));
                Document parent = documentService.getParent((DocRef)new PathRef(this.path));
                String originalTitle = duplicate.getTitle();
                Document copy = documentService.copy((DocRef)new IdRef(duplicate.getId()), (DocRef)parent);
                this.log.warn((Object)("Relocate copy on " + copy.getId() + " with new path " + copy.getPath()));
                documentService.remove((DocRef)new IdRef(duplicate.getId()));
                documentService.setProperty((DocRef)copy, "dc:title", originalTitle);
            }
            catch (Exception e) {
                this.log.error((Object)("Error when reparing " + this.path));
            }
        }
        return null;
    }

    public String getId() {
        return null;
    }
}

